/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.potion;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.contraptions.fluids.VirtualFluid;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class PotionFluid
extends VirtualFluid {
    public PotionFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public static FluidStack of(int amount, Potion potion) {
        FluidStack fluidStack = new FluidStack(((PotionFluid)AllFluids.POTION.get()).m_5613_(), amount);
        PotionFluid.addPotionToFluidStack(fluidStack, potion);
        return fluidStack;
    }

    public static FluidStack withEffects(int amount, Potion potion, List<MobEffectInstance> customEffects) {
        FluidStack fluidStack = PotionFluid.of(amount, potion);
        PotionFluid.appendEffects(fluidStack, customEffects);
        return fluidStack;
    }

    public static FluidStack addPotionToFluidStack(FluidStack fs, Potion potion) {
        ResourceLocation resourcelocation = RegisteredObjects.getKeyOrThrow(potion);
        if (potion == Potions.f_43598_) {
            fs.removeChildTag("Potion");
            return fs;
        }
        fs.getOrCreateTag().m_128359_("Potion", resourcelocation.toString());
        return fs;
    }

    public static FluidStack appendEffects(FluidStack fs, Collection<MobEffectInstance> customEffects) {
        if (customEffects.isEmpty()) {
            return fs;
        }
        CompoundTag compoundnbt = fs.getOrCreateTag();
        ListTag listnbt = compoundnbt.m_128437_("CustomPotionEffects", 9);
        for (MobEffectInstance effectinstance : customEffects) {
            listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
        }
        compoundnbt.m_128365_("CustomPotionEffects", (Tag)listnbt);
        return fs;
    }

    public static class PotionFluidAttributes
    extends FluidAttributes {
        public PotionFluidAttributes(FluidAttributes.Builder builder, Fluid fluid) {
            super(builder, fluid);
        }

        public int getColor(FluidStack stack) {
            CompoundTag tag = stack.getOrCreateTag();
            int color = PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)tag)) | 0xFF000000;
            return color;
        }

        public Component getDisplayName(FluidStack stack) {
            return Components.translatable(this.getTranslationKey(stack));
        }

        public String getTranslationKey(FluidStack stack) {
            CompoundTag tag = stack.getOrCreateTag();
            ItemLike itemFromBottleType = PotionFluidHandler.itemFromBottleType(NBTHelper.readEnum(tag, "Bottle", BottleType.class));
            return PotionUtils.m_43577_((CompoundTag)tag).m_43492_(itemFromBottleType.m_5456_().m_5524_() + ".effect.");
        }
    }

    public static enum BottleType {
        REGULAR,
        SPLASH,
        LINGERING;

    }
}

