/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.BlockMovementChecks;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.content.schematics.MaterialChecklist;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.schematics.item.SchematicItem;
import com.simibubi.create.foundation.tileEntity.IMergeableTE;
import com.simibubi.create.foundation.utility.BBHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SchematicPrinter {
    private boolean schematicLoaded;
    private SchematicWorld blockReader;
    private BlockPos schematicAnchor;
    private BlockPos currentPos;
    private int printingEntityIndex = -1;
    private PrintStage printStage = PrintStage.BLOCKS;
    private List<BlockPos> deferredBlocks = new LinkedList<BlockPos>();

    public void fromTag(CompoundTag compound, boolean clientPacket) {
        if (compound.m_128441_("CurrentPos")) {
            this.currentPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("CurrentPos"));
        }
        if (clientPacket) {
            this.schematicLoaded = false;
            if (compound.m_128441_("Anchor")) {
                this.schematicAnchor = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Anchor"));
                this.schematicLoaded = true;
            }
        }
        this.printingEntityIndex = compound.m_128451_("EntityProgress");
        this.printStage = PrintStage.valueOf(compound.m_128461_("PrintStage"));
        compound.m_128437_("DeferredBlocks", 10).stream().map(p -> NbtUtils.m_129239_((CompoundTag)((CompoundTag)p))).collect(Collectors.toCollection(() -> this.deferredBlocks));
    }

    public void write(CompoundTag compound) {
        if (this.currentPos != null) {
            compound.m_128365_("CurrentPos", (Tag)NbtUtils.m_129224_((BlockPos)this.currentPos));
        }
        if (this.schematicAnchor != null) {
            compound.m_128365_("Anchor", (Tag)NbtUtils.m_129224_((BlockPos)this.schematicAnchor));
        }
        compound.m_128405_("EntityProgress", this.printingEntityIndex);
        compound.m_128359_("PrintStage", this.printStage.name());
        ListTag tagDeferredBlocks = new ListTag();
        for (BlockPos p : this.deferredBlocks) {
            tagDeferredBlocks.add((Object)NbtUtils.m_129224_((BlockPos)p));
        }
        compound.m_128365_("DeferredBlocks", (Tag)tagDeferredBlocks);
    }

    public void loadSchematic(ItemStack blueprint, Level originalWorld, boolean processNBT) {
        if (!blueprint.m_41782_() || !blueprint.m_41783_().m_128471_("Deployed")) {
            return;
        }
        StructureTemplate activeTemplate = SchematicItem.loadSchematic(blueprint);
        StructurePlaceSettings settings = SchematicItem.getSettings(blueprint, processNBT);
        this.schematicAnchor = NbtUtils.m_129239_((CompoundTag)blueprint.m_41783_().m_128469_("Anchor"));
        this.blockReader = new SchematicWorld(this.schematicAnchor, originalWorld);
        activeTemplate.m_74536_((ServerLevelAccessor)this.blockReader, this.schematicAnchor, this.schematicAnchor, settings, this.blockReader.m_5822_(), 2);
        BlockPos extraBounds = StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)new BlockPos(activeTemplate.m_163801_()).m_142082_(-1, -1, -1));
        this.blockReader.bounds = BBHelper.encapsulate(this.blockReader.bounds, extraBounds);
        StructureTransform transform = new StructureTransform(settings.m_74407_(), Direction.Axis.Y, settings.m_74404_(), settings.m_74401_());
        for (BlockEntity te : this.blockReader.tileEntities.values()) {
            transform.apply(te);
        }
        this.printingEntityIndex = -1;
        this.printStage = PrintStage.BLOCKS;
        this.deferredBlocks.clear();
        BoundingBox bounds = this.blockReader.getBounds();
        this.currentPos = new BlockPos(bounds.m_162395_() - 1, bounds.m_162396_(), bounds.m_162398_());
        this.schematicLoaded = true;
    }

    public void resetSchematic() {
        this.schematicLoaded = false;
        this.schematicAnchor = null;
        this.currentPos = null;
        this.blockReader = null;
        this.printingEntityIndex = -1;
        this.printStage = PrintStage.BLOCKS;
        this.deferredBlocks.clear();
    }

    public boolean isLoaded() {
        return this.schematicLoaded;
    }

    public BlockPos getCurrentTarget() {
        if (!this.isLoaded()) {
            return null;
        }
        return this.schematicAnchor.m_141952_((Vec3i)this.currentPos);
    }

    public PrintStage getPrintStage() {
        return this.printStage;
    }

    public BlockPos getAnchor() {
        return this.schematicAnchor;
    }

    public boolean isWorldEmpty() {
        return this.blockReader.getAllPositions().isEmpty();
    }

    public void handleCurrentTarget(BlockTargetHandler blockHandler, EntityTargetHandler entityHandler) {
        BlockPos target = this.getCurrentTarget();
        if (this.printStage == PrintStage.ENTITIES) {
            Entity entity = (Entity)this.blockReader.getEntityStream().collect(Collectors.toList()).get(this.printingEntityIndex);
            entityHandler.handle(target, entity);
        } else {
            BlockState blockState = BlockHelper.setZeroAge(this.blockReader.m_8055_(target));
            BlockEntity tileEntity = this.blockReader.m_7702_(target);
            blockHandler.handle(target, blockState, tileEntity);
        }
    }

    public boolean shouldPlaceCurrent(Level world) {
        return this.shouldPlaceCurrent(world, (a, b, c, d, e, f) -> true);
    }

    public boolean shouldPlaceCurrent(Level world, PlacementPredicate predicate) {
        if (world == null) {
            return false;
        }
        if (this.printStage == PrintStage.ENTITIES) {
            return true;
        }
        return this.shouldPlaceBlock(world, predicate, this.getCurrentTarget());
    }

    /*
     * Unable to fully structure code
     */
    public boolean shouldPlaceBlock(Level world, PlacementPredicate predicate, BlockPos pos) {
        state = BlockHelper.setZeroAge(this.blockReader.m_8055_(pos));
        tileEntity = this.blockReader.m_7702_(pos);
        toReplace = world.m_8055_(pos);
        toReplaceTE = world.m_7702_(pos);
        toReplaceOther = null;
        if (state.m_61138_((Property)BlockStateProperties.f_61391_) && state.m_61138_((Property)BlockStateProperties.f_61374_) && state.m_61143_((Property)BlockStateProperties.f_61391_) == BedPart.FOOT) {
            toReplaceOther = world.m_8055_(pos.m_142300_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61401_) && state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            toReplaceOther = world.m_8055_(pos.m_7494_());
        }
        if (tileEntity == null || !(toReplaceTE instanceof IMergeableTE)) ** GOTO lbl-1000
        mergeTE = (IMergeableTE)toReplaceTE;
        if (toReplaceTE.m_58903_().equals(tileEntity.m_58903_())) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = mergeTEs = false;
        }
        if (!world.m_46749_(pos)) {
            return false;
        }
        if (!world.m_6857_().m_61937_(pos)) {
            return false;
        }
        if (toReplace == state && !mergeTEs) {
            return false;
        }
        if (toReplace.m_60800_((BlockGetter)world, pos) == -1.0f || toReplaceOther != null && toReplaceOther.m_60800_((BlockGetter)world, pos) == -1.0f) {
            return false;
        }
        isNormalCube = state.m_60796_((BlockGetter)this.blockReader, this.currentPos);
        return predicate.shouldPlace(pos, state, tileEntity, toReplace, toReplaceOther, isNormalCube);
    }

    public ItemRequirement getCurrentRequirement() {
        if (this.printStage == PrintStage.ENTITIES) {
            return ItemRequirement.of((Entity)this.blockReader.getEntityStream().collect(Collectors.toList()).get(this.printingEntityIndex));
        }
        BlockPos target = this.getCurrentTarget();
        BlockState blockState = BlockHelper.setZeroAge(this.blockReader.m_8055_(target));
        BlockEntity tileEntity = this.blockReader.m_7702_(target);
        return ItemRequirement.of(blockState, tileEntity);
    }

    public int markAllBlockRequirements(MaterialChecklist checklist, Level world, PlacementPredicate predicate) {
        int blocksToPlace = 0;
        for (BlockPos pos : this.blockReader.getAllPositions()) {
            ItemRequirement requirement;
            BlockPos relPos = pos.m_141952_((Vec3i)this.schematicAnchor);
            BlockState required = this.blockReader.m_8055_(relPos);
            BlockEntity requiredTE = this.blockReader.m_7702_(relPos);
            if (!world.m_46749_(pos.m_141952_((Vec3i)this.schematicAnchor))) {
                checklist.warnBlockNotLoaded();
                continue;
            }
            if (!this.shouldPlaceBlock(world, predicate, relPos) || (requirement = ItemRequirement.of(required, requiredTE)).isEmpty() || requirement.isInvalid()) continue;
            checklist.require(requirement);
            ++blocksToPlace;
        }
        return blocksToPlace;
    }

    public void markAllEntityRequirements(MaterialChecklist checklist) {
        this.blockReader.getEntityStream().forEach(entity -> {
            ItemRequirement requirement = ItemRequirement.of(entity);
            if (requirement.isEmpty()) {
                return;
            }
            if (requirement.isInvalid()) {
                return;
            }
            checklist.require(requirement);
        });
    }

    public boolean advanceCurrentPos() {
        List entities = this.blockReader.getEntityStream().collect(Collectors.toList());
        do {
            if (this.printStage == PrintStage.BLOCKS) {
                while (this.tryAdvanceCurrentPos()) {
                    this.deferredBlocks.add(this.currentPos);
                }
            }
            if (this.printStage == PrintStage.DEFERRED_BLOCKS) {
                if (this.deferredBlocks.isEmpty()) {
                    this.printStage = PrintStage.ENTITIES;
                } else {
                    this.currentPos = this.deferredBlocks.remove(0);
                }
            }
            if (this.printStage != PrintStage.ENTITIES) continue;
            if (this.printingEntityIndex + 1 < entities.size()) {
                ++this.printingEntityIndex;
                this.currentPos = ((Entity)entities.get(this.printingEntityIndex)).m_142538_().m_141950_((Vec3i)this.schematicAnchor);
                continue;
            }
            return false;
        } while (!this.blockReader.getBounds().m_71051_((Vec3i)this.currentPos));
        return true;
    }

    public boolean tryAdvanceCurrentPos() {
        this.currentPos = this.currentPos.m_142300_(Direction.EAST);
        BoundingBox bounds = this.blockReader.getBounds();
        BlockPos posInBounds = this.currentPos.m_142082_(-bounds.m_162395_(), -bounds.m_162396_(), -bounds.m_162398_());
        if (posInBounds.m_123341_() > bounds.m_71056_()) {
            this.currentPos = new BlockPos(bounds.m_162395_(), this.currentPos.m_123342_(), this.currentPos.m_123343_() + 1).m_142125_();
        }
        if (posInBounds.m_123343_() > bounds.m_71058_()) {
            this.currentPos = new BlockPos(this.currentPos.m_123341_(), this.currentPos.m_123342_() + 1, bounds.m_162398_()).m_142125_();
        }
        if (this.currentPos.m_123342_() > bounds.m_71057_()) {
            this.printStage = PrintStage.DEFERRED_BLOCKS;
            return false;
        }
        return SchematicPrinter.shouldDeferBlock(this.blockReader.m_8055_(this.getCurrentTarget()));
    }

    public static boolean shouldDeferBlock(BlockState state) {
        return AllBlocks.GANTRY_CARRIAGE.has(state) || AllBlocks.MECHANICAL_ARM.has(state) || BlockMovementChecks.isBrittle(state);
    }

    public static enum PrintStage {
        BLOCKS,
        DEFERRED_BLOCKS,
        ENTITIES;

    }

    @FunctionalInterface
    public static interface EntityTargetHandler {
        public void handle(BlockPos var1, Entity var2);
    }

    @FunctionalInterface
    public static interface BlockTargetHandler {
        public void handle(BlockPos var1, BlockState var2, BlockEntity var3);
    }

    @FunctionalInterface
    public static interface PlacementPredicate {
        public boolean shouldPlace(BlockPos var1, BlockState var2, BlockEntity var3, BlockState var4, BlockState var5, boolean var6);
    }
}

