/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.DynamicDataProvider;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.worldgen.AllLayerPatterns;
import com.simibubi.create.foundation.worldgen.OreFeatureConfigEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

public class AllOreFeatureConfigEntries {
    private static final Predicate<BiomeLoadingEvent> OVERWORLD_BIOMES = event -> {
        Biome.BiomeCategory category = event.getCategory();
        return category != Biome.BiomeCategory.NETHER && category != Biome.BiomeCategory.THEEND && category != Biome.BiomeCategory.NONE;
    };
    private static final Predicate<BiomeLoadingEvent> NETHER_BIOMES = event -> {
        Biome.BiomeCategory category = event.getCategory();
        return category == Biome.BiomeCategory.NETHER;
    };
    public static final OreFeatureConfigEntry ZINC_ORE = AllOreFeatureConfigEntries.create("zinc_ore", 12, 8.0f, -63, 70).biomeExt().predicate(OVERWORLD_BIOMES).parent().standardDatagenExt().withBlocks(Couple.create(AllBlocks.ZINC_ORE, AllBlocks.DEEPSLATE_ZINC_ORE)).parent();
    public static final OreFeatureConfigEntry STRIATED_ORES_OVERWORLD = AllOreFeatureConfigEntries.create("striated_ores_overworld", 32, 0.083333336f, -30, 70).biomeExt().predicate(OVERWORLD_BIOMES).parent().layeredDatagenExt().withLayerPattern(AllLayerPatterns.SCORIA).withLayerPattern(AllLayerPatterns.CINNABAR).withLayerPattern(AllLayerPatterns.MAGNETITE).withLayerPattern(AllLayerPatterns.MALACHITE).withLayerPattern(AllLayerPatterns.LIMESTONE).withLayerPattern(AllLayerPatterns.OCHRESTONE).parent();
    public static final OreFeatureConfigEntry STRIATED_ORES_NETHER = AllOreFeatureConfigEntries.create("striated_ores_nether", 32, 0.083333336f, 40, 90).biomeExt().predicate(NETHER_BIOMES).parent().layeredDatagenExt().withLayerPattern(AllLayerPatterns.SCORIA_NETHER).withLayerPattern(AllLayerPatterns.SCORCHIA_NETHER).parent();

    private static OreFeatureConfigEntry create(String name, int clusterSize, float frequency, int minHeight, int maxHeight) {
        ResourceLocation id = Create.asResource(name);
        OreFeatureConfigEntry configDrivenFeatureEntry = new OreFeatureConfigEntry(id, clusterSize, frequency, minHeight, maxHeight);
        return configDrivenFeatureEntry;
    }

    public static void fillConfig(ForgeConfigSpec.Builder builder, String namespace) {
        OreFeatureConfigEntry.ALL.forEach((id, entry) -> {
            if (id.m_135827_().equals(namespace)) {
                builder.push(entry.getName());
                entry.addToConfig(builder);
                builder.pop();
            }
        });
    }

    public static void init() {
    }

    public static void modifyBiomes(BiomeLoadingEvent event) {
        for (OreFeatureConfigEntry entry : OreFeatureConfigEntry.ALL.values()) {
            entry.biomeExt().modifyBiomes(event, (Registry<PlacedFeature>)BuiltinRegistries.f_194653_);
        }
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        RegistryAccess registryAccess = (RegistryAccess)RegistryAccess.f_123049_.get();
        HashMap configuredFeatures = new HashMap();
        for (Map.Entry<ResourceLocation, OreFeatureConfigEntry> entry : OreFeatureConfigEntry.ALL.entrySet()) {
            OreFeatureConfigEntry.DatagenExtension datagenExt = entry.getValue().datagenExt();
            if (datagenExt == null) continue;
            configuredFeatures.put(entry.getKey(), datagenExt.createConfiguredFeature(registryAccess));
        }
        DynamicDataProvider configuredFeatureProvider = DynamicDataProvider.create(generator, "Create's Configured Features", registryAccess, Registry.f_122881_, configuredFeatures);
        if (configuredFeatureProvider != null) {
            generator.m_123914_(configuredFeatureProvider);
        }
        HashMap<ResourceLocation, PlacedFeature> placedFeatures = new HashMap<ResourceLocation, PlacedFeature>();
        for (Map.Entry entry : OreFeatureConfigEntry.ALL.entrySet()) {
            OreFeatureConfigEntry.DatagenExtension datagenExt = ((OreFeatureConfigEntry)entry.getValue()).datagenExt();
            if (datagenExt == null) continue;
            placedFeatures.put((ResourceLocation)entry.getKey(), datagenExt.createPlacedFeature(registryAccess));
        }
        DynamicDataProvider placedFeatureProvider = DynamicDataProvider.create(generator, "Create's Placed Features", registryAccess, Registry.f_194567_, placedFeatures);
        if (placedFeatureProvider != null) {
            generator.m_123914_(placedFeatureProvider);
        }
    }
}

