/*
 * Decompiled with CFR 0.152.
 */
package dynamicfps;

import dynamicfps.DynamicFPSConfig;
import dynamicfps.FlawlessFrames;
import dynamicfps.HudInfoRenderer;
import dynamicfps.util.KeyBindingHandler;
import dynamicfps.util.Localization;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.Nullable;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_156;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;

public class DynamicFPSMod
implements ModInitializer {
    public static final String MOD_ID = "dynamicfps";
    public static DynamicFPSConfig config = null;
    private static boolean isDisabled = false;
    private static boolean isForcingLowFPS = false;
    private static final KeyBindingHandler toggleForcedKeyBinding = new KeyBindingHandler(Localization.translationKey("key", "toggle_forced"), "key.categories.misc", () -> {
        isForcingLowFPS = !isForcingLowFPS;
    });
    private static final KeyBindingHandler toggleDisabledKeyBinding = new KeyBindingHandler(Localization.translationKey("key", "toggle_disabled"), "key.categories.misc", () -> {
        isDisabled = !isDisabled;
    });
    private static long lastRender;
    private static boolean hasTriggeredGC;
    private static boolean hasRenderedLastFrame;

    public static boolean isDisabled() {
        return isDisabled;
    }

    public static boolean isForcingLowFPS() {
        return isForcingLowFPS;
    }

    public void onInitialize() {
        config = DynamicFPSConfig.load();
        toggleForcedKeyBinding.register();
        toggleDisabledKeyBinding.register();
        HudRenderCallback.EVENT.register((Object)new HudInfoRenderer());
        FlawlessFrames.onClientInitialization();
    }

    public static boolean checkForRender() {
        if (isDisabled || FlawlessFrames.isActive()) {
            return true;
        }
        DynamicFPSMod.checkForGC();
        long currentTime = class_156.method_658();
        long timeSinceLastRender = currentTime - lastRender;
        if (!DynamicFPSMod.checkForRender(timeSinceLastRender)) {
            return false;
        }
        lastRender = currentTime;
        return true;
    }

    private static void checkForGC() {
        if (!DynamicFPSMod.config.runGCOnUnfocus) {
            return;
        }
        if (class_310.method_1551().method_1569()) {
            hasTriggeredGC = false;
        } else if (!hasTriggeredGC && hasRenderedLastFrame) {
            hasTriggeredGC = true;
            System.gc();
        }
    }

    private static boolean checkForRender(long timeSinceLastRender) {
        boolean shouldSkipRender;
        Integer fpsOverride = DynamicFPSMod.fpsOverride();
        if (fpsOverride == null) {
            hasRenderedLastFrame = false;
            return true;
        }
        if (!hasRenderedLastFrame) {
            hasRenderedLastFrame = true;
            return true;
        }
        if (fpsOverride == 0) {
            DynamicFPSMod.idle(1000L);
            return false;
        }
        long frameTime = 1000 / fpsOverride;
        boolean bl = shouldSkipRender = timeSinceLastRender < frameTime;
        if (!shouldSkipRender) {
            return true;
        }
        DynamicFPSMod.idle(frameTime);
        return false;
    }

    private static void idle(long waitMillis) {
        waitMillis = Math.min(waitMillis, 30L);
        LockSupport.parkNanos("waiting to render", waitMillis * 1000000L);
    }

    @Nullable
    private static Integer fpsOverride() {
        boolean isVisible;
        class_310 client = class_310.method_1551();
        class_1041 window = ((WindowHolder)client).getWindow();
        boolean bl = isVisible = GLFW.glfwGetWindowAttrib((long)window.method_4490(), (int)131076) != 0;
        if (!isVisible) {
            return 0;
        }
        if (isForcingLowFPS) {
            return DynamicFPSMod.config.unfocusedFPS;
        }
        if (DynamicFPSMod.config.restoreFPSWhenHovered) {
            boolean isHovered;
            boolean bl2 = isHovered = GLFW.glfwGetWindowAttrib((long)window.method_4490(), (int)131083) != 0;
            if (isHovered) {
                return null;
            }
        }
        if (DynamicFPSMod.config.reduceFPSWhenUnfocused && !client.method_1569()) {
            return DynamicFPSMod.config.unfocusedFPS;
        }
        return null;
    }

    static {
        hasTriggeredGC = false;
        hasRenderedLastFrame = false;
    }

    public static interface WindowHolder {
        public class_1041 getWindow();
    }

    public static interface SplashScreenAccessor {
        public boolean isReloadComplete();
    }
}

