/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.block_growth;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.block_growth.BlockGrowthConfiguration;
import com.ordana.immersive_weathering.block_growth.IBlockGrowth;
import com.ordana.immersive_weathering.block_growth.IConditionalGrowingBlock;
import com.ordana.immersive_weathering.block_growth.hardcoded.HardcodedGrowths;
import com.ordana.immersive_weathering.configs.ServerConfigs;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockGrowthHandler
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static ImmutableSet<Block> TICKING_BLOCKS = ImmutableSet.of();
    private static final Map<Block, Set<IBlockGrowth>> GROWTH_FOR_BLOCK = new HashMap<Block, Set<IBlockGrowth>>();
    private static final List<IBlockGrowth> GROWTHS = new ArrayList<IBlockGrowth>();
    public RegistryAccess registryAccess;
    private boolean needsRefresh;

    public BlockGrowthHandler() {
        super(GSON, "block_growths");
    }

    public static Optional<Set<IBlockGrowth>> getBlockGrowth(Block block) {
        return Optional.ofNullable(GROWTH_FOR_BLOCK.get(block));
    }

    public static void tickBlock(BlockState state, ServerLevel level, BlockPos pos) {
        if (!((Boolean)ServerConfigs.BLOCK_GROWTH.get()).booleanValue()) {
            return;
        }
        if (!TICKING_BLOCKS.contains((Object)state.m_60734_())) {
            return;
        }
        Optional<Set<IBlockGrowth>> growth = BlockGrowthHandler.getBlockGrowth(state.m_60734_());
        if (growth.isPresent()) {
            IConditionalGrowingBlock cb;
            Block block = state.m_60734_();
            if (block instanceof IConditionalGrowingBlock && !(cb = (IConditionalGrowingBlock)block).canGrow(state)) {
                return;
            }
            Holder biome = level.m_204166_(pos);
            for (IBlockGrowth config : growth.get()) {
                config.tryGrowing(pos, state, level, (Holder<Biome>)biome);
            }
        }
    }

    public void writeToFile(BlockGrowthConfiguration obj, FileWriter writer) {
        DataResult r = BlockGrowthConfiguration.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)obj);
        r.result().ifPresent(a -> GSON.toJson((JsonElement)this.sortJson(a.getAsJsonObject()), (Appendable)writer));
    }

    private JsonObject sortJson(JsonObject jsonObject) {
        try {
            TreeMap<String, JsonElement> joToMap = new TreeMap<String, JsonElement>();
            jsonObject.entrySet().forEach(e -> {
                JsonElement j = (JsonElement)e.getValue();
                if (j instanceof JsonObject) {
                    JsonObject jo = (JsonObject)j;
                    j = this.sortJson(jo);
                }
                joToMap.put((String)e.getKey(), j);
            });
            JsonObject sortedJSON = new JsonObject();
            joToMap.forEach((arg_0, arg_1) -> ((JsonObject)sortedJSON).add(arg_0, arg_1));
            return sortedJSON;
        }
        catch (Exception exception) {
            return jsonObject;
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller profile) {
        if (this.registryAccess == null) {
            return;
        }
        this.needsRefresh = true;
        GROWTHS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> e : jsons.entrySet()) {
            DataResult result = BlockGrowthConfiguration.CODEC.parse((DynamicOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)this.registryAccess), (Object)e.getValue());
            Optional o = result.resultOrPartial(error -> ImmersiveWeathering.LOGGER.error("Failed to read block growth JSON object for {} : {}", e.getKey(), error));
            o.ifPresent(GROWTHS::add);
        }
        ImmersiveWeathering.LOGGER.info("Loaded {} block growths configurations", (Object)GROWTHS.size());
    }

    public void rebuild() {
        if (this.needsRefresh) {
            GROWTH_FOR_BLOCK.clear();
            GROWTHS.addAll(HardcodedGrowths.getHardcoded());
            for (IBlockGrowth config : GROWTHS) {
                config.getOwners().forEach(b -> GROWTH_FOR_BLOCK.computeIfAbsent((Block)b, k -> new HashSet()).add(config));
            }
            ImmutableSet.Builder b2 = ImmutableSet.builder();
            TICKING_BLOCKS = b2.addAll(GROWTH_FOR_BLOCK.keySet()).build();
            GROWTHS.clear();
            this.needsRefresh = false;
        }
    }
}

