/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.block_growth;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockPair
extends Pair<BlockState, BlockState> {
    private static final Codec<Block> BLOCK_CODEC = ResourceLocation.f_135803_.flatXmap(resourceLocation -> Registry.f_122824_.m_6612_(resourceLocation).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown registry key in " + Registry.f_122824_.m_123023_() + ": " + resourceLocation))), block -> Registry.f_122824_.m_7854_(block).map(ResourceKey::m_135782_).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown registry element in " + Registry.f_122824_.m_123023_() + ":" + block))));
    private static final Codec<BlockState> BLOCK_STATE_CODEC = BlockStateAccessor.getCodec(BLOCK_CODEC, Block::m_49966_).stable();
    public static final Codec<BlockPair> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BLOCK_STATE_CODEC.fieldOf("block").forGetter(Pair::getFirst), (App)BLOCK_STATE_CODEC.optionalFieldOf("above_block").forGetter(p -> Optional.ofNullable((BlockState)p.getSecond()))).apply((Applicative)instance, (f, s) -> new BlockPair((BlockState)f, s.orElse(null))));

    public BlockPair(@Nonnull BlockState first, @Nullable BlockState second) {
        super((Object)first, (Object)second);
    }

    public static BlockPair of(@Nonnull BlockState first, @Nullable BlockState second) {
        return new BlockPair(first, second);
    }

    public static BlockPair of(@Nonnull BlockState first) {
        return BlockPair.of(first, null);
    }

    public static BlockPair of(@Nonnull Block first) {
        return BlockPair.of(first.m_49966_(), null);
    }

    public boolean isDouble() {
        return this.getSecond() != null;
    }

    public static class BlockStateAccessor
    extends BlockState {
        public BlockStateAccessor(Block block, ImmutableMap<Property<?>, Comparable<?>> map, MapCodec<BlockState> mapCodec) {
            super(block, map, mapCodec);
        }

        public static Codec<BlockState> getCodec(Codec<Block> oCodec, Function<Block, BlockState> osFunction) {
            return BlockStateAccessor.m_61127_(oCodec, osFunction);
        }
    }
}

