/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.common;

import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.common.ModBlocks;
import com.ordana.immersive_weathering.common.features.IcicleClusterFeature;
import com.ordana.immersive_weathering.common.features.IcicleClusterFeatureConfig;
import com.ordana.immersive_weathering.configs.ServerConfigs;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockPileConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"immersive_weathering");
    public static final RegistryObject<Feature<IcicleClusterFeatureConfig>> ICICLE_CLUSTER = FEATURES.register("icicle_cluster", () -> new IcicleClusterFeature(IcicleClusterFeatureConfig.CODEC));
    private static Holder<PlacedFeature> ICICLES;
    private static Holder<PlacedFeature> CAVE_ICICLES;

    private static void registerLeafPile(String name) {
        String n = "immersive_weathering:" + name + "_leaf_pile";
        Holder PILE = FeatureUtils.m_206488_((String)n, (Feature)Feature.f_65764_, (FeatureConfiguration)new BlockPileConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(n))))));
        PlacementUtils.m_206513_((String)("immersive_weathering:" + name + "_leaf_pile"), (Holder)PILE, (PlacementModifier[])new PlacementModifier[]{PlacementUtils.f_195353_, NoiseBasedCountPlacement.m_191731_((int)2, (double)50.0, (double)0.7), NoiseThresholdCountPlacement.m_191756_((double)0.3, (int)1, (int)5), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()});
    }

    private static void registerHumusPatches(String name) {
        Holder PATCH = FeatureUtils.m_206488_((String)("immersive_weathering:" + name), (Feature)Feature.f_159734_, (FeatureConfiguration)new VegetationPatchConfiguration(BlockTags.f_144274_, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.HUMUS.get())), PlacementUtils.m_206506_((Holder)FeatureUtils.m_206485_((String)"immersive_weathering:no_op", (Feature)Feature.f_65759_), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.m_146483_((int)1), 0.0f, 5, 0.8f, (IntProvider)UniformInt.m_146622_((int)2, (int)6), 0.5f));
        PlacementUtils.m_206513_((String)("immersive_weathering:" + name), (Holder)PATCH, (PlacementModifier[])new PlacementModifier[]{PlacementUtils.f_195353_, NoiseBasedCountPlacement.m_191731_((int)15, (double)50.0, (double)-0.1), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()});
    }

    public static void init() {
        ModFeatures.registerLeafPile("oak");
        ModFeatures.registerLeafPile("dark_oak");
        ModFeatures.registerLeafPile("birch");
        ModFeatures.registerLeafPile("spruce");
        ModFeatures.registerHumusPatches("humus_patches");
        Holder icicles = FeatureUtils.m_206488_((String)"immersive_weathering:icicles", (Feature)((Feature)ICICLE_CLUSTER.get()), (FeatureConfiguration)new IcicleClusterFeatureConfig(12, (IntProvider)UniformInt.m_146622_((int)3, (int)6), (IntProvider)UniformInt.m_146622_((int)2, (int)8), 1, 3, (IntProvider)UniformInt.m_146622_((int)2, (int)4), (FloatProvider)UniformFloat.m_146605_((float)0.3f, (float)0.7f), (FloatProvider)ClampedNormalFloat.m_146423_((float)0.1f, (float)0.3f, (float)0.1f, (float)0.9f), 0.1f, 3, 8));
        ICICLES = PlacementUtils.m_206513_((String)"immersive_weathering:icicles", (Holder)icicles, (PlacementModifier[])new PlacementModifier[]{NoiseBasedCountPlacement.m_191731_((int)10, (double)50.0, (double)0.1), NoiseThresholdCountPlacement.m_191756_((double)0.3, (int)1, (int)10), CountOnEveryLayerPlacement.m_191604_((int)3), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)92), (VerticalAnchor)VerticalAnchor.m_158935_((int)1)), BiomeFilter.m_191561_()});
        CAVE_ICICLES = PlacementUtils.m_206513_((String)"immersive_weathering:icicles_ice_caves", (Holder)icicles, (PlacementModifier[])new PlacementModifier[]{NoiseBasedCountPlacement.m_191731_((int)10, (double)50.0, (double)0.1), NoiseThresholdCountPlacement.m_191756_((double)0.3, (int)1, (int)10), CountOnEveryLayerPlacement.m_191604_((int)3), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)1), (VerticalAnchor)VerticalAnchor.m_158935_((int)1)), BiomeFilter.m_191561_()});
    }

    private static void addFeature(BiomeLoadingEvent event, String name, GenerationStep.Decoration step) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)ImmersiveWeathering.res(name));
        Holder feature = BuiltinRegistries.f_194653_.m_206081_(key);
        ModFeatures.addFeature(event, (Holder<PlacedFeature>)feature, step);
    }

    private static void addFeature(BiomeLoadingEvent event, Holder<PlacedFeature> feature, GenerationStep.Decoration step) {
        event.getGeneration().m_204201_(step, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
        Biome.BiomeCategory category = event.getCategory();
        if (((Boolean)ServerConfigs.ICICLES_PATCHES.get()).booleanValue() && (BiomeDictionary.hasType((ResourceKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || category == Biome.BiomeCategory.ICY)) {
            ModFeatures.addFeature(event, ICICLES, GenerationStep.Decoration.TOP_LAYER_MODIFICATION);
            if (category == Biome.BiomeCategory.UNDERGROUND) {
                ModFeatures.addFeature(event, CAVE_ICICLES, GenerationStep.Decoration.UNDERGROUND_DECORATION);
            }
        }
        if (((Boolean)ServerConfigs.HUMUS_PATCHES.get()).booleanValue() && key == Biomes.f_48151_) {
            ModFeatures.addFeature(event, "humus_patches", GenerationStep.Decoration.LOCAL_MODIFICATIONS);
        }
    }
}

