/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.common;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.common.ModBlocks;
import com.ordana.immersive_weathering.common.blocks.IcicleBlock;
import com.ordana.immersive_weathering.common.blocks.LeafPilesRegistry;
import com.ordana.immersive_weathering.configs.ServerConfigs;
import com.ordana.immersive_weathering.integration.IntegrationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class WeatheringHelper {
    public static final Supplier<BiMap<Block, Block>> FLOWERY_BLOCKS = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_152542_, (Object)Blocks.f_152541_).put((Object)Blocks.f_152471_, (Object)Blocks.f_152470_).put((Object)((Block)ModBlocks.FLOWERING_AZALEA_LEAF_PILE.get()), (Object)((Block)ModBlocks.AZALEA_LEAF_PILE.get()));
        if (IntegrationHandler.quark) {
            Block a = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:flowering_azalea_hedge"));
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:azalea_hedge"));
            if (a != null && b != null) {
                builder.put((Object)a, (Object)b);
            }
            Block c = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:flowering_azalea_leaf_carpet"));
            Block d = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:azalea_leaf_carpet"));
            if (c != null && d != null) {
                builder.put((Object)c, (Object)d);
            }
        }
        return builder.build();
    });

    public static Optional<BlockState> getAzaleaGrowth(BlockState state) {
        return Optional.ofNullable((Block)FLOWERY_BLOCKS.get().inverse().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static Optional<BlockState> getAzaleaSheared(BlockState state) {
        return Optional.ofNullable((Block)FLOWERY_BLOCKS.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static Optional<Pair<Item, Block>> getBarkForStrippedLog(BlockState log) {
        ResourceLocation res;
        String s;
        Optional<Pair<Item, Block>> pair = Optional.ofNullable(LeafPilesRegistry.STRIPPED_TO_BARK.get().get(log.m_60734_()));
        if (pair.isPresent() && !(s = (String)ServerConfigs.GENERIC_BARK.get()).isEmpty() && ForgeRegistries.ITEMS.containsKey(res = new ResourceLocation(s))) {
            return Optional.of(Pair.of((Object)((Item)ForgeRegistries.ITEMS.getValue(res)), (Object)((Block)pair.get().getSecond())));
        }
        return pair;
    }

    public static List<BlockPos> grabBlocksAroundRandomly(BlockPos centerPos, int radiusX, int radiusY, int radiusZ) {
        List<BlockPos> list = BlockPos.m_121985_((BlockPos)centerPos, (int)radiusX, (int)radiusY, (int)radiusZ).map(BlockPos::new).collect(Collectors.toList());
        Collections.shuffle(list, new Random(Mth.m_14057_((Vec3i)centerPos)));
        return list;
    }

    public static boolean hasEnoughBlocksAround(BlockPos centerPos, int radiusX, int radiusY, int radiusZ, Level level, Predicate<BlockState> blockPredicate, int requiredAmount) {
        List<BlockPos> lis = WeatheringHelper.grabBlocksAroundRandomly(centerPos, radiusX, radiusY, radiusZ);
        int count = 0;
        for (BlockPos pos : lis) {
            if (blockPredicate.test(level.m_8055_(pos))) {
                ++count;
            }
            if (count < requiredAmount) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEnoughBlocksAround(BlockPos centerPos, int radius, Level level, Predicate<BlockState> blockPredicate, int requiredAmount) {
        return WeatheringHelper.hasEnoughBlocksAround(centerPos, radius, radius, radius, level, blockPredicate, requiredAmount);
    }

    public static boolean hasEnoughBlocksFacingMe(BlockPos centerPos, Level level, Predicate<BlockState> blockPredicate, int requiredAmount) {
        int count = 0;
        ArrayList<Direction> list = new ArrayList<Direction>(List.of(Direction.values()));
        Collections.shuffle(list, new Random(Mth.m_14057_((Vec3i)centerPos)));
        for (Direction dir : list) {
            BlockPos pos = centerPos.m_142300_(dir);
            if (blockPredicate.test(level.m_8055_(pos))) {
                ++count;
            }
            if (count < requiredAmount) continue;
            return true;
        }
        return false;
    }

    public static boolean isLog(BlockState neighbor) {
        return neighbor.m_204336_(BlockTags.f_13106_) && (!neighbor.m_61138_((Property)RotatedPillarBlock.f_55923_) || neighbor.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y) && !neighbor.m_60734_().getRegistryName().m_135815_().contains("stripped");
    }

    public static boolean isIciclePos(BlockPos pos) {
        int rarity = (Integer)ServerConfigs.ICICLES_GENERATION_RARITY.get();
        if (rarity == 1001) {
            return false;
        }
        Random posRandom = new Random(Mth.m_14057_((Vec3i)pos));
        return posRandom.nextInt(rarity) == 0;
    }

    public static void tryPlacingIcicle(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.SNOW && WeatheringHelper.isIciclePos(pos)) {
            BlockPos p = pos.m_6625_(state.m_204336_(BlockTags.f_144279_) ? 2 : 1);
            BlockState placement = (BlockState)((Block)ModBlocks.ICICLE.get()).m_49966_().m_61124_((Property)IcicleBlock.f_154009_, (Comparable)Direction.DOWN);
            if (level.m_8055_(p).m_60795_() && placement.m_60710_((LevelReader)level, p) && Direction.Plane.HORIZONTAL.m_122557_().anyMatch(d -> {
                BlockPos rel = p.m_142300_(d);
                return level.m_45527_(rel) && level.m_8055_(rel).m_60795_();
            })) {
                level.m_46597_(p, placement);
            }
        }
    }

    public static void onLightningHit(BlockPos centerPos, Level level, int rec) {
        BlockPos downPos;
        if (rec == 0 && !((Boolean)ServerConfigs.VITRIFIED_LIGHTNING.get()).booleanValue()) {
            return;
        }
        BlockState vitrified = ((Block)ModBlocks.VITRIFIED_SAND.get()).m_49966_();
        level.m_46597_(centerPos, vitrified);
        if (rec >= 5) {
            return;
        }
        float decrement = 0.7f;
        double p = Math.pow(decrement, ++rec);
        if ((rec == 0 || (double)level.f_46441_.nextFloat() < 1.0 * p) && level.m_8055_(downPos = centerPos.m_7495_()).m_204336_(BlockTags.f_13029_)) {
            WeatheringHelper.onLightningHit(downPos, level, rec);
        }
        for (BlockPos target : BlockPos.m_121925_((BlockPos)centerPos, (int)1, (int)0, (int)1)) {
            if (!((double)level.f_46441_.nextFloat() < 0.3 * p) || target == centerPos || !level.m_8055_(target).m_204336_(BlockTags.f_13029_)) continue;
            WeatheringHelper.onLightningHit(target, level, rec);
        }
    }

    public float getTemp(Level level, BlockPos pos) {
        return ((Biome)level.m_204166_(pos).m_203334_()).m_47505_(pos);
    }

    public boolean isCold(Biome biome, BlockPos pos) {
        return false;
    }

    public boolean isWarm(Biome level, BlockPos pos) {
        return false;
    }
}

