/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.common.blocks;

import com.ordana.immersive_weathering.common.ModBlocks;
import com.ordana.immersive_weathering.common.WeatheringHelper;
import com.ordana.immersive_weathering.configs.ServerConfigs;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class LeafPileBlock
extends Block
implements BonemealableBlock {
    public static final IntegerProperty LAYERS = IntegerProperty.m_61631_((String)"layers", (int)0, (int)8);
    protected static final VoxelShape[] LAYERS_TO_SHAPE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final float[] COLLISIONS = new float[]{1.0f, 0.999f, 0.998f, 0.997f, 0.996f, 0.994f, 0.993f, 0.992f};
    private final boolean hasFlowers;
    private final boolean hasThorns;
    private final boolean isLeafy;
    private final List<Lazy<SimpleParticleType>> particles;

    public LeafPileBlock(BlockBehaviour.Properties settings, boolean hasFlowers, boolean hasThorns, boolean isLeafy, List<Supplier<SimpleParticleType>> particles) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
        this.hasFlowers = hasFlowers;
        this.hasThorns = hasThorns;
        this.particles = particles.stream().map(Lazy::of).collect(Collectors.toList());
        this.isLeafy = isLeafy;
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }

    protected int getLayers(BlockState state) {
        return (Integer)state.m_61143_((Property)LAYERS);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        int layers = this.getLayers(state);
        if (layers > 3 && entity instanceof LivingEntity && !(entity instanceof Fox) && !(entity instanceof Bee)) {
            Player player;
            float stuck = COLLISIONS[Math.max(0, layers - 1)];
            entity.m_7601_(state, new Vec3((double)stuck, 1.0, (double)stuck));
            if (!(layers < 6 || !this.hasThorns || level.f_46443_ || entity.f_19790_ == entity.m_20185_() && entity.f_19792_ == entity.m_20189_() || entity instanceof Player && !(player = (Player)entity).m_6844_(EquipmentSlot.LEGS).m_41619_())) {
                double d = Math.abs(entity.m_20185_() - entity.f_19790_);
                double e = Math.abs(entity.m_20189_() - entity.f_19792_);
                if (d >= (double)0.003f || e >= (double)0.003f) {
                    entity.m_6469_(DamageSource.f_19325_, 0.5f * (float)(layers - 5));
                }
            }
        }
        if (layers > 0 && level.f_46443_ && entity instanceof LivingEntity && entity.m_146900_().m_60713_((Block)this)) {
            boolean bl;
            Random random = level.m_5822_();
            boolean bl2 = bl = entity.f_19790_ != entity.m_20185_() || entity.f_19792_ != entity.m_20189_();
            if (bl && random.nextBoolean()) {
                double y = (double)pos.m_123342_() + LAYERS_TO_SHAPE[layers].m_83297_(Direction.Axis.Y) + 0.0625;
                int color = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, 0);
                for (Lazy<SimpleParticleType> p : this.particles) {
                    level.m_7106_((ParticleOptions)p.get(), entity.m_20185_() + (double)Mth.m_144924_((Random)random, (float)-0.2f, (float)0.2f), y, entity.m_20189_() + (double)Mth.m_144924_((Random)random, (float)-0.2f, (float)0.2f), (double)Mth.m_144924_((Random)random, (float)-0.75f, (float)-1.0f), (double)color, 0.0);
                }
            }
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND -> {
                if (this.getLayers(state) < 5) {
                    yield true;
                }
                yield false;
            }
            case PathComputationType.WATER -> {
                if (this.getLayers(state) == 0) {
                    yield true;
                }
                yield false;
            }
            case PathComputationType.AIR -> false;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return LAYERS_TO_SHAPE[this.getLayers(state)];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter world, BlockPos pos) {
        return LAYERS_TO_SHAPE[this.getLayers(state)];
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return LAYERS_TO_SHAPE[this.getLayers(state)];
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState below = world.m_8055_(pos.m_7495_());
        if (!below.m_60713_(Blocks.f_50375_)) {
            if (!(below.m_60713_(Blocks.f_50719_) || below.m_60713_(Blocks.f_50135_) || below.m_60819_().m_192917_((Fluid)Fluids.f_76193_) && (Integer)state.m_61143_((Property)LAYERS) == 0)) {
                return below.m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP) || below.m_60713_((Block)this) && (Integer)below.m_61143_((Property)LAYERS) == 8;
            }
            return true;
        }
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && (Integer)state.m_61143_((Property)LAYERS) <= 1) {
            state = (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(neighborState.m_60713_(Blocks.f_49990_) ? 0 : 1));
        }
        return !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        int i = (Integer)state.m_61143_((Property)LAYERS);
        if (context.m_43722_().m_150930_(this.m_5456_()) && i < 8 && i > 0) {
            if (context.m_7058_()) {
                return context.m_43719_() == Direction.UP;
            }
            return true;
        }
        return i < 3;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = ctx.m_43725_().m_8055_(ctx.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            int i = (Integer)blockState.m_61143_((Property)LAYERS);
            return (BlockState)blockState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        if (blockState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            return null;
        }
        BlockState below = ctx.m_43725_().m_8055_(ctx.m_8083_().m_7495_());
        if (below.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            if (!blockState.m_60795_()) {
                return null;
            }
            return (BlockState)this.m_49966_().m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(0));
        }
        return super.m_5573_(ctx);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYERS});
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean isClient) {
        return this.hasFlowers;
    }

    public boolean m_5491_(Level world, Random random, BlockPos pos, BlockState state) {
        return this.hasFlowers;
    }

    public void m_7719_(ServerLevel world, Random random, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.values()) {
            if (!(random.nextFloat() > 0.5f)) continue;
            BlockPos targetPos = pos.m_142300_(direction);
            BlockState targetBlock = world.m_8055_(targetPos);
            WeatheringHelper.getAzaleaGrowth(targetBlock).ifPresent(s -> world.m_46597_(targetPos, s));
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public boolean m_6724_(BlockState state) {
        int layers = this.getLayers(state);
        return layers > 1 && (this.isLeafy || this.hasThorns);
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        BlockState below;
        int layers = this.getLayers(state);
        if (layers > 1 && (double)random.nextFloat() < (Double)ServerConfigs.HUMUS_SPAWN_BELOW_LEAVES.get() && (this.isLeafy || this.hasThorns) && ((below = world.m_8055_(pos.m_7495_())).m_60713_(Blocks.f_50440_) || below.m_60713_(Blocks.f_50493_) || below.m_60713_(Blocks.f_50546_) || below.m_60713_(Blocks.f_152549_))) {
            world.m_7731_(pos.m_7495_(), (this.isLeafy ? (Block)ModBlocks.HUMUS.get() : Blocks.f_50599_).m_49966_(), 2);
        }
    }
}

