/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.common.blocks;

import com.ordana.immersive_weathering.common.ModBlocks;
import com.ordana.immersive_weathering.common.ModParticles;
import com.ordana.immersive_weathering.common.ModTags;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SootLayerBlock
extends MultifaceBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public SootLayerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{LIT});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            world.m_5594_(player, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (player.m_21120_(hand).m_41720_() instanceof FlintAndSteelItem) {
            world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemStack stack = player.m_21120_(hand);
            stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            int i = pos.m_123341_();
            int j = pos.m_123342_();
            int k = pos.m_123343_();
            double d = (double)i + random.nextDouble();
            double e = (double)j + random.nextDouble();
            double f = (double)k + random.nextDouble();
            world.m_7106_((ParticleOptions)ModParticles.EMBER.get(), d, e, f, 0.1, 3.0, 0.1);
        }
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        for (Direction direction : Direction.values()) {
            BlockPos targetPos = pos.m_142300_(direction);
            BlockState neighborState = world.m_8055_(targetPos);
            if (neighborState.m_204336_(ModTags.MAGMA_SOURCE)) {
                if (world.m_46758_(pos.m_7494_())) {
                    return;
                }
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
            }
            if (!world.m_46758_(pos.m_7494_()) && neighborState.m_60819_().m_76152_() != Fluids.f_76192_ && neighborState.m_60819_().m_76152_() != Fluids.f_76193_) continue;
            if (neighborState.m_204336_(ModTags.MAGMA_SOURCE)) {
                return;
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.m_146900_().m_60713_((Block)this)) {
            if (world.f_46443_) {
                boolean bl;
                Random random = world.m_5822_();
                boolean bl2 = bl = entity.f_19790_ != entity.m_20185_() || entity.f_19792_ != entity.m_20189_();
                if (bl && random.nextBoolean() && !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                    world.m_7106_((ParticleOptions)ModParticles.SOOT.get(), entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), (double)(Mth.m_144924_((Random)random, (float)-1.0f, (float)1.0f) * 0.001f), 0.05, (double)(Mth.m_144924_((Random)random, (float)-1.0f, (float)1.0f) * 0.001f));
                }
            }
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
                entity.m_6469_(DamageSource.f_19309_, 1.0f);
            }
        }
    }

    private static boolean canAttachTo(BlockGetter getter, Direction direction, BlockPos pos, BlockState state) {
        return Block.m_49918_((VoxelShape)state.m_60812_(getter, pos), (Direction)direction.m_122424_());
    }

    @Nullable
    public static BlockState getMaximumAttachmentState(MultifaceBlock block, BlockPos pos, Level level) {
        BlockState state = block.m_49966_();
        boolean hasFace = false;
        for (Direction dir : Direction.values()) {
            BlockPos relative = pos.m_142300_(dir);
            boolean canAttach = SootLayerBlock.canAttachTo((BlockGetter)level, dir, relative, level.m_8055_(relative));
            if (canAttach) {
                hasFace = true;
            }
            state.m_61124_((Property)SootLayerBlock.m_153933_((Direction)dir), (Comparable)Boolean.valueOf(canAttach));
        }
        if (hasFace) {
            return state;
        }
        return null;
    }

    public static boolean convertToSoot(Level level, BlockPos pos, BlockState fireState) {
        if (level.f_46441_.nextFloat() < 0.4f) {
            level.m_7731_(pos, (BlockState)((Block)ModBlocks.SOOT.get()).m_152465_(fireState).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
            return true;
        }
        return false;
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder builder) {
        if (builder.m_78982_(LootContextParams.f_81455_) != null) {
            return super.m_7381_(p_60537_, builder);
        }
        return List.of();
    }
}

