/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.common.blocks.mossable;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.common.ModBlocks;
import com.ordana.immersive_weathering.common.blocks.PatchSpreader;
import com.ordana.immersive_weathering.common.blocks.Weatherable;
import com.ordana.immersive_weathering.common.blocks.mossable.MossSpreader;
import com.ordana.immersive_weathering.integration.IntegrationHandler;
import com.ordana.immersive_weathering.integration.QuarkPlugin;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface Mossable
extends Weatherable {
    public static final Supplier<BiMap<Block, Block>> MOSS_LEVEL_INCREASES = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_50069_, (Object)((Block)ModBlocks.MOSSY_STONE.get())).put((Object)Blocks.f_50635_, (Object)((Block)ModBlocks.MOSSY_STONE_STAIRS.get())).put((Object)Blocks.f_50404_, (Object)((Block)ModBlocks.MOSSY_STONE_SLAB.get())).put((Object)Blocks.f_50652_, (Object)Blocks.f_50079_).put((Object)Blocks.f_50157_, (Object)Blocks.f_50633_).put((Object)Blocks.f_50409_, (Object)Blocks.f_50647_).put((Object)Blocks.f_50274_, (Object)Blocks.f_50275_).put((Object)Blocks.f_50222_, (Object)Blocks.f_50223_).put((Object)Blocks.f_50194_, (Object)Blocks.f_50631_).put((Object)Blocks.f_50411_, (Object)Blocks.f_50645_).put((Object)Blocks.f_50609_, (Object)Blocks.f_50607_).put((Object)Blocks.f_50076_, (Object)((Block)ModBlocks.MOSSY_BRICKS.get())).put((Object)Blocks.f_50193_, (Object)((Block)ModBlocks.MOSSY_BRICK_STAIRS.get())).put((Object)Blocks.f_50410_, (Object)((Block)ModBlocks.MOSSY_BRICK_SLAB.get())).put((Object)Blocks.f_50604_, (Object)((Block)ModBlocks.MOSSY_BRICK_WALL.get()));
        if (IntegrationHandler.quark) {
            QuarkPlugin.addAllVerticalSlabs((ImmutableBiMap.Builder<Block, Block>)builder);
        }
        return builder.build();
    });
    public static final Supplier<BiMap<Block, Block>> MOSS_LEVEL_DECREASES = Suppliers.memoize(() -> MOSS_LEVEL_INCREASES.get().inverse());

    public static BlockState getUnaffectedMossBlock(BlockState state) {
        Block block2 = state.m_60734_();
        Block block3 = (Block)MOSS_LEVEL_DECREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (Block)MOSS_LEVEL_DECREASES.get().get((Object)block2);
        }
        return block2.m_152465_(state);
    }

    public static BlockState getMossyBlock(BlockState state) {
        Block block2 = state.m_60734_();
        Block block3 = (Block)MOSS_LEVEL_INCREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (Block)MOSS_LEVEL_INCREASES.get().get((Object)block2);
        }
        return block2.m_152465_(state);
    }

    public static Optional<Block> getDecreasedMossBlock(Block block) {
        return Optional.ofNullable((Block)MOSS_LEVEL_DECREASES.get().get((Object)block));
    }

    public static Optional<Block> getIncreasedMossBlock(Block block) {
        return Optional.ofNullable((Block)MOSS_LEVEL_INCREASES.get().get((Object)block));
    }

    default public Optional<BlockState> getNextMossy(BlockState state) {
        return Mossable.getIncreasedMossBlock(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    default public Optional<BlockState> getPreviousMossy(BlockState state) {
        return Mossable.getDecreasedMossBlock(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public MossSpreader getMossSpreader();

    @Override
    default public <T extends Enum<?>> Optional<PatchSpreader<T>> getPatchSpreader(Class<T> weatheringClass) {
        if (weatheringClass == MossLevel.class) {
            return Optional.of(this.getMossSpreader());
        }
        return Optional.empty();
    }

    @Override
    default public boolean shouldWeather(BlockState state, BlockPos pos, Level level) {
        return this.getMossSpreader().getWantedWeatheringState(false, pos, level);
    }

    public MossLevel getMossLevel();

    @Override
    public boolean isWeathering(BlockState var1);

    @Override
    default public void tryWeather(BlockState state, ServerLevel serverLevel, BlockPos pos, Random random) {
        if (random.nextFloat() < this.getWeatherChanceSpeed()) {
            BlockState newState;
            Optional<BlockState> opt = Optional.empty();
            if (this.getMossSpreader().getWantedWeatheringState(true, pos, (Level)serverLevel)) {
                opt = this.getNextMossy(state);
            }
            if ((newState = opt.orElse((BlockState)state.m_61124_((Property)WEATHERABLE, (Comparable)((Object)Weatherable.WeatheringState.FALSE)))) != state) {
                serverLevel.m_7731_(pos, newState, 2);
                if (!newState.m_61138_((Property)WEATHERABLE)) {
                    serverLevel.m_186460_(pos, state.m_60734_(), 1);
                }
            }
        }
    }

    public static enum MossLevel {
        UNAFFECTED,
        MOSSY;

    }
}

