/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.common.blocks.rustable;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.common.ModBlocks;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface Rustable
extends ChangeOverTimeBlock<RustLevel> {
    public static final Supplier<BiMap<Block, Block>> RUST_LEVEL_INCREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)ModBlocks.CUT_IRON.get()), (Object)((Block)ModBlocks.EXPOSED_CUT_IRON.get())).put((Object)((Block)ModBlocks.EXPOSED_CUT_IRON.get()), (Object)((Block)ModBlocks.WEATHERED_CUT_IRON.get())).put((Object)((Block)ModBlocks.WEATHERED_CUT_IRON.get()), (Object)((Block)ModBlocks.RUSTED_CUT_IRON.get())).put((Object)((Block)ModBlocks.CUT_IRON_SLAB.get()), (Object)((Block)ModBlocks.EXPOSED_CUT_IRON_SLAB.get())).put((Object)((Block)ModBlocks.EXPOSED_CUT_IRON_SLAB.get()), (Object)((Block)ModBlocks.WEATHERED_CUT_IRON_SLAB.get())).put((Object)((Block)ModBlocks.WEATHERED_CUT_IRON_SLAB.get()), (Object)((Block)ModBlocks.RUSTED_CUT_IRON_SLAB.get())).put((Object)((Block)ModBlocks.CUT_IRON_STAIRS.get()), (Object)((Block)ModBlocks.EXPOSED_CUT_IRON_STAIRS.get())).put((Object)((Block)ModBlocks.EXPOSED_CUT_IRON_STAIRS.get()), (Object)((Block)ModBlocks.WEATHERED_CUT_IRON_STAIRS.get())).put((Object)((Block)ModBlocks.WEATHERED_CUT_IRON_STAIRS.get()), (Object)((Block)ModBlocks.RUSTED_CUT_IRON_STAIRS.get())).put((Object)((Block)ModBlocks.PLATE_IRON.get()), (Object)((Block)ModBlocks.EXPOSED_PLATE_IRON.get())).put((Object)((Block)ModBlocks.EXPOSED_PLATE_IRON.get()), (Object)((Block)ModBlocks.WEATHERED_PLATE_IRON.get())).put((Object)((Block)ModBlocks.WEATHERED_PLATE_IRON.get()), (Object)((Block)ModBlocks.RUSTED_PLATE_IRON.get())).put((Object)((Block)ModBlocks.PLATE_IRON_SLAB.get()), (Object)((Block)ModBlocks.EXPOSED_PLATE_IRON_SLAB.get())).put((Object)((Block)ModBlocks.EXPOSED_PLATE_IRON_SLAB.get()), (Object)((Block)ModBlocks.WEATHERED_PLATE_IRON_SLAB.get())).put((Object)((Block)ModBlocks.WEATHERED_PLATE_IRON_SLAB.get()), (Object)((Block)ModBlocks.RUSTED_PLATE_IRON_SLAB.get())).put((Object)((Block)ModBlocks.PLATE_IRON_STAIRS.get()), (Object)((Block)ModBlocks.EXPOSED_PLATE_IRON_STAIRS.get())).put((Object)((Block)ModBlocks.EXPOSED_PLATE_IRON_STAIRS.get()), (Object)((Block)ModBlocks.WEATHERED_PLATE_IRON_STAIRS.get())).put((Object)((Block)ModBlocks.WEATHERED_PLATE_IRON_STAIRS.get()), (Object)((Block)ModBlocks.RUSTED_PLATE_IRON_STAIRS.get())).put((Object)Blocks.f_50166_, (Object)((Block)ModBlocks.EXPOSED_IRON_DOOR.get())).put((Object)((Block)ModBlocks.EXPOSED_IRON_DOOR.get()), (Object)((Block)ModBlocks.WEATHERED_IRON_DOOR.get())).put((Object)((Block)ModBlocks.WEATHERED_IRON_DOOR.get()), (Object)((Block)ModBlocks.RUSTED_IRON_DOOR.get())).put((Object)Blocks.f_50376_, (Object)((Block)ModBlocks.EXPOSED_IRON_TRAPDOOR.get())).put((Object)((Block)ModBlocks.EXPOSED_IRON_TRAPDOOR.get()), (Object)((Block)ModBlocks.WEATHERED_IRON_TRAPDOOR.get())).put((Object)((Block)ModBlocks.WEATHERED_IRON_TRAPDOOR.get()), (Object)((Block)ModBlocks.RUSTED_IRON_TRAPDOOR.get())).put((Object)Blocks.f_50183_, (Object)((Block)ModBlocks.EXPOSED_IRON_BARS.get())).put((Object)((Block)ModBlocks.EXPOSED_IRON_BARS.get()), (Object)((Block)ModBlocks.WEATHERED_IRON_BARS.get())).put((Object)((Block)ModBlocks.WEATHERED_IRON_BARS.get()), (Object)((Block)ModBlocks.RUSTED_IRON_BARS.get())).put((Object)((Block)ModBlocks.CUT_IRON_VERTICAL_SLAB.get()), (Object)((Block)ModBlocks.EXPOSED_CUT_IRON_VERTICAL_SLAB.get())).put((Object)((Block)ModBlocks.EXPOSED_CUT_IRON_VERTICAL_SLAB.get()), (Object)((Block)ModBlocks.WEATHERED_CUT_IRON_VERTICAL_SLAB.get())).put((Object)((Block)ModBlocks.WEATHERED_CUT_IRON_VERTICAL_SLAB.get()), (Object)((Block)ModBlocks.RUSTED_CUT_IRON_VERTICAL_SLAB.get())).put((Object)((Block)ModBlocks.PLATE_IRON_VERTICAL_SLAB.get()), (Object)((Block)ModBlocks.EXPOSED_PLATE_IRON_VERTICAL_SLAB.get())).put((Object)((Block)ModBlocks.EXPOSED_PLATE_IRON_VERTICAL_SLAB.get()), (Object)((Block)ModBlocks.WEATHERED_PLATE_IRON_VERTICAL_SLAB.get())).put((Object)((Block)ModBlocks.WEATHERED_PLATE_IRON_VERTICAL_SLAB.get()), (Object)((Block)ModBlocks.RUSTED_PLATE_IRON_VERTICAL_SLAB.get())).build());
    public static final Supplier<BiMap<Block, Block>> RUST_LEVEL_DECREASES = Suppliers.memoize(() -> RUST_LEVEL_INCREASES.get().inverse());

    public static Optional<Block> getDecreasedRustBlock(Block block) {
        return Optional.ofNullable((Block)RUST_LEVEL_DECREASES.get().get((Object)block));
    }

    public static Block getUnaffectedRustBlock(Block block) {
        Block block2 = block;
        Block block3 = (Block)RUST_LEVEL_DECREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (Block)RUST_LEVEL_DECREASES.get().get((Object)block2);
        }
        return block2;
    }

    default public Optional<BlockState> getPrevious(BlockState state) {
        return Rustable.getDecreasedRustBlock(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<Block> getIncreasedRustBlock(Block block) {
        return Optional.ofNullable((Block)RUST_LEVEL_INCREASES.get().get((Object)block));
    }

    public static BlockState getUnaffectedRustState(BlockState state) {
        return Rustable.getUnaffectedRustBlock(state.m_60734_()).m_152465_(state);
    }

    default public Optional<BlockState> m_142123_(BlockState state) {
        return Rustable.getIncreasedRustBlock(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    default public float m_142377_() {
        if (this.m_142297_() == RustLevel.UNAFFECTED) {
            return 0.75f;
        }
        return 1.0f;
    }

    default public int getInfluenceRadius() {
        return 4;
    }

    default public void m_153046_(BlockState state, ServerLevel serverLevel, BlockPos pos, Random random) {
        BlockPos blockpos;
        int distance;
        int age = ((RustLevel)this.m_142297_()).ordinal();
        int j = 0;
        int k = 0;
        int affectingDistance = this.getInfluenceRadius();
        Iterator iterator = BlockPos.m_121925_((BlockPos)pos, (int)affectingDistance, (int)affectingDistance, (int)affectingDistance).iterator();
        while (iterator.hasNext() && (distance = (blockpos = (BlockPos)iterator.next()).m_123333_((Vec3i)pos)) <= affectingDistance) {
            BlockState blockstate;
            Block block;
            if (blockpos.equals((Object)pos) || !((block = (blockstate = serverLevel.m_8055_(blockpos)).m_60734_()) instanceof ChangeOverTimeBlock)) continue;
            ChangeOverTimeBlock changeOverTimeBlock = (ChangeOverTimeBlock)block;
            Enum ageEnum = changeOverTimeBlock.m_142297_();
            if (((Object)((Object)((RustLevel)this.m_142297_()))).getClass() != ageEnum.getClass()) continue;
            int neighbourAge = ageEnum.ordinal();
            if (neighbourAge < age) {
                return;
            }
            if (neighbourAge > age) {
                ++k;
                continue;
            }
            ++j;
        }
        float f = (float)(k + 1) / (float)(k + j + 1);
        float f1 = f * f * this.m_142377_();
        if (random.nextFloat() < f1) {
            this.m_142123_(state).ifPresent(p_153039_ -> serverLevel.m_46597_(pos, p_153039_));
        }
    }

    public static enum RustLevel {
        UNAFFECTED,
        EXPOSED,
        WEATHERED,
        RUSTED;

    }
}

