/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.common.blocks.rustable;

import com.ordana.immersive_weathering.common.ModParticles;
import com.ordana.immersive_weathering.common.ModTags;
import com.ordana.immersive_weathering.common.blocks.Waxables;
import com.ordana.immersive_weathering.common.blocks.rustable.Rustable;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class RustableDoorBlock
extends DoorBlock
implements Rustable {
    private final Rustable.RustLevel rustLevel;

    public RustableDoorBlock(Rustable.RustLevel rustLevel, BlockBehaviour.Properties settings) {
        super(settings);
        this.rustLevel = rustLevel;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.m_61143_((Property)f_52730_);
        if ((direction == Direction.UP && doubleBlockHalf == DoubleBlockHalf.LOWER || direction == Direction.DOWN && doubleBlockHalf == DoubleBlockHalf.UPPER) && neighborState.m_60734_() instanceof RustableDoorBlock) {
            state = neighborState.m_60734_().m_152465_(state);
        }
        if (direction.m_122434_() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return neighborState.m_60713_(state.m_60734_()) && neighborState.m_61143_((Property)f_52730_) != doubleBlockHalf ? (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_52726_, (Comparable)((Direction)neighborState.m_61143_((Property)f_52726_)))).m_61124_((Property)f_52727_, (Comparable)((Boolean)neighborState.m_61143_((Property)f_52727_)))).m_61124_((Property)f_52728_, (Comparable)((DoorHingeSide)neighborState.m_61143_((Property)f_52728_)))).m_61124_((Property)f_52729_, (Comparable)((Boolean)neighborState.m_61143_((Property)f_52729_))) : Blocks.f_50016_.m_49966_();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public void m_52759_(Level world, BlockPos pos, boolean open) {
        world.m_5898_(null, open ? 1011 : 1005, pos, 0);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        boolean hasPower;
        boolean bl = world.m_46753_(pos) || world.m_46753_(pos.m_142300_(state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (hasPower = false);
        if (hasPower != (Boolean)state.m_61143_((Property)f_52729_) && this != block) {
            switch (this.getAge()) {
                case UNAFFECTED: {
                    if (hasPower != (Boolean)state.m_61143_((Property)f_52727_)) {
                        this.m_52759_(world, pos, hasPower);
                        world.m_151555_(hasPower ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
                    }
                    world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(hasPower))).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(hasPower)), 2);
                    break;
                }
                case EXPOSED: {
                    if (hasPower) {
                        world.m_186460_(pos, (Block)this, 1);
                    } else {
                        world.m_186460_(pos, (Block)this, 10);
                    }
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(hasPower)), 2);
                    break;
                }
                case WEATHERED: {
                    if (hasPower) {
                        world.m_186460_(pos, (Block)this, 1);
                    } else {
                        world.m_186460_(pos, (Block)this, 20);
                    }
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(hasPower)), 2);
                    break;
                }
                case RUSTED: {
                    if (hasPower && !((Boolean)state.m_61143_((Property)f_52729_)).booleanValue()) {
                        state = (BlockState)state.m_61122_((Property)f_52727_);
                        this.m_52759_(world, pos, (Boolean)state.m_61143_((Property)f_52727_));
                        world.m_151555_((Boolean)state.m_61143_((Property)f_52727_) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
                    }
                    world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(hasPower))).m_61124_((Property)f_52727_, (Comparable)((Boolean)state.m_61143_((Property)f_52727_))), 2);
                }
            }
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (this.getAge() == Rustable.RustLevel.EXPOSED || this.getAge() == Rustable.RustLevel.WEATHERED) {
            state = (BlockState)state.m_61122_((Property)f_52727_);
            this.m_52759_((Level)world, pos, (Boolean)state.m_61143_((Property)f_52727_));
            world.m_151555_((Boolean)state.m_61143_((Property)f_52727_) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52727_, (Comparable)((Boolean)state.m_61143_((Property)f_52727_))), 2);
        }
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        float f;
        BlockState neighborState;
        BlockPos targetPos;
        if (world.m_8055_(pos).m_204336_(ModTags.CLEAN_IRON)) {
            for (Direction direction : Direction.values()) {
                targetPos = pos.m_142300_(direction);
                neighborState = world.m_8055_(targetPos);
                if (world.m_8055_(pos.m_142300_(direction)).m_60713_(Blocks.f_50016_) || neighborState.m_60819_().m_205070_(FluidTags.f_13131_)) {
                    this.m_153041_(state, world, pos, random);
                }
                if (!world.m_8055_(pos.m_142300_(direction)).m_60713_(Blocks.f_50628_)) continue;
                f = 0.06f;
                if (!(random.nextFloat() > 0.06f)) continue;
                this.m_153046_(state, world, pos, random);
            }
        }
        if (world.m_8055_(pos).m_204336_(ModTags.EXPOSED_IRON)) {
            for (Direction direction : Direction.values()) {
                targetPos = pos.m_142300_(direction);
                neighborState = world.m_8055_(targetPos);
                if (world.m_46758_(pos.m_7494_()) || neighborState.m_60819_().m_205070_(FluidTags.f_13131_)) {
                    this.m_153041_(state, world, pos, random);
                }
                if (world.m_8055_(pos.m_142300_(direction)).m_60713_(Blocks.f_50628_)) {
                    f = 0.06f;
                    if (random.nextFloat() > 0.06f) {
                        this.m_153046_(state, world, pos, random);
                    }
                }
                if (!world.m_46758_(pos.m_142300_(direction)) || !world.m_8055_(pos.m_7494_()).m_204336_(ModTags.WEATHERED_IRON)) continue;
                if (BlockPos.m_121985_((BlockPos)pos, (int)2, (int)2, (int)2).map(arg_0 -> ((ServerLevel)world).m_8055_(arg_0)).filter(b -> b.m_204336_(ModTags.WEATHERED_IRON)).toList().size() > 9) continue;
                f = 0.06f;
                if (!(random.nextFloat() > 0.06f)) continue;
                this.m_153046_(state, world, pos, random);
            }
        }
        if (world.m_8055_(pos).m_204336_(ModTags.WEATHERED_IRON)) {
            for (Direction direction : Direction.values()) {
                targetPos = pos.m_142300_(direction);
                neighborState = world.m_8055_(targetPos);
                if (neighborState.m_60819_().m_205070_(FluidTags.f_13131_)) {
                    this.m_153041_(state, world, pos, random);
                }
                if (!world.m_8055_(pos.m_142300_(direction)).m_60713_(Blocks.f_50628_)) continue;
                f = 0.07f;
                if (!(random.nextFloat() > 0.07f)) continue;
                this.m_153046_(state, world, pos, random);
            }
        }
    }

    public boolean m_6724_(BlockState state) {
        return Rustable.getIncreasedRustBlock(state.m_60734_()).isPresent();
    }

    public Rustable.RustLevel getAge() {
        return this.rustLevel;
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int i, int i1) {
        if (i == 1) {
            if (level.f_46443_) {
                ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)((ParticleOptions)ModParticles.SCRAPE_RUST.get()), (UniformInt)UniformInt.m_146622_((int)3, (int)5));
            }
            return true;
        }
        return super.m_8133_(state, level, pos, i, i1);
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, Level level, BlockPos pos, Player player, ItemStack stack, ToolAction toolAction) {
        Optional<BlockState> v;
        if (this.getAge() != Rustable.RustLevel.RUSTED && ToolActions.AXE_SCRAPE.equals(toolAction)) {
            return this.getPrevious(state).orElse(null);
        }
        if (ToolActions.AXE_WAX_OFF.equals(toolAction) && (v = Waxables.getUnWaxedState(state)).isPresent()) {
            return v.get();
        }
        return super.getToolModifiedState(state, level, pos, player, stack, toolAction);
    }
}

