/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.integration.dynamic_stuff;

import com.mojang.blaze3d.platform.NativeImage;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.configs.ClientConfigs;
import com.ordana.immersive_weathering.integration.dynamic_stuff.ModDynamicRegistry;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.client.asset_generators.LangBuilder;
import net.mehvahdjukaar.selene.client.asset_generators.textures.Palette;
import net.mehvahdjukaar.selene.client.asset_generators.textures.PaletteColor;
import net.mehvahdjukaar.selene.client.asset_generators.textures.Respriter;
import net.mehvahdjukaar.selene.client.asset_generators.textures.TextureImage;
import net.mehvahdjukaar.selene.resourcepack.AfterLanguageLoadEvent;
import net.mehvahdjukaar.selene.resourcepack.DynamicLanguageManager;
import net.mehvahdjukaar.selene.resourcepack.DynamicTexturePack;
import net.mehvahdjukaar.selene.resourcepack.RPAwareDynamicTextureProvider;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.mehvahdjukaar.selene.resourcepack.ResType;
import net.mehvahdjukaar.selene.resourcepack.StaticResource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.logging.log4j.Logger;

public class ClientDynamicResourcesHandler
extends RPAwareDynamicTextureProvider {
    public ClientDynamicResourcesHandler() {
        super(new DynamicTexturePack(ImmersiveWeathering.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).generateDebugResources = false;
    }

    public void register(IEventBus bus) {
        super.register(bus);
    }

    public Logger getLogger() {
        return ImmersiveWeathering.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return (Boolean)ClientConfigs.RESOURCE_PACK_SUPPORT.get();
    }

    public void generateStaticAssetsOnStartup(ResourceManager manager) {
        ((DynamicTexturePack)this.dynamicPack).generateDebugResources = (Boolean)ClientConfigs.SAVE_GENERATED_RESOURCES.get();
        StaticResource leafParticle = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.PARTICLES.getPath(ImmersiveWeathering.res("oak_leaf")));
        StaticResource lpBlockState = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(ImmersiveWeathering.res("oak_leaf_pile")));
        StaticResource lpModel1 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height1")));
        StaticResource lpModel2 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height2")));
        StaticResource lpModel4 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height4")));
        StaticResource lpModel6 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height6")));
        StaticResource lpModel8 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height8")));
        StaticResource lpModel10 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height10")));
        StaticResource lpModel12 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height12")));
        StaticResource lpModel14 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height14")));
        StaticResource lpModel16 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height16")));
        StaticResource lpItemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(ImmersiveWeathering.res("oak_leaf_pile")));
        ModDynamicRegistry.LEAF_TO_TYPE.forEach((pile, leafType) -> {
            if (leafType.isVanilla()) {
                return;
            }
            String path = leafType.getNamespace() + "/" + leafType.getTypeName();
            String id = path + "_leaf_pile";
            String particleId = path + "_leaf";
            try {
                ((DynamicTexturePack)this.dynamicPack).addSimilarJsonResource(lpBlockState, "oak_leaf_pile", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile blockstate definition for {} : {}", (Object)pile, (Object)ex);
            }
            try {
                ((DynamicTexturePack)this.dynamicPack).addSimilarJsonResource(lpItemModel, "oak_leaf_pile", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile item model for {} : {}", (Object)pile, (Object)ex);
            }
            try {
                ResourceLocation leavesTexture;
                try {
                    leavesTexture = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)leafType.leaves, s -> true);
                }
                catch (Exception exception) {
                    this.getLogger().warn("Failed to find texture for Leaf Pile {}, using oak one instead", (Object)pile);
                    leavesTexture = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)Blocks.f_50050_, s -> true);
                }
                this.addLeafPilesModel(Objects.requireNonNull(lpModel1), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel2), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel4), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel6), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel8), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel10), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel12), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel14), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel16), id, leavesTexture);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile model for {} : {}", (Object)pile, (Object)ex);
            }
            try {
                ((DynamicTexturePack)this.dynamicPack).addSimilarJsonResource(leafParticle, "oak_leaf", particleId);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Particle for {} : {}", (Object)pile, (Object)ex);
            }
        });
        StaticResource itemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(ImmersiveWeathering.res("oak_bark")));
        ModDynamicRegistry.MODDED_BARK.forEach((woodType, bark) -> {
            if (!woodType.isVanilla()) {
                String id = bark.getRegistryName().m_135815_();
                try {
                    ((DynamicTexturePack)this.dynamicPack).addSimilarJsonResource(itemModel, "oak_bark", id);
                }
                catch (Exception ex) {
                    this.getLogger().error("Failed to generate Bark item model for {} : {}", bark, (Object)ex);
                }
            }
        });
    }

    public void addLeafPilesModel(StaticResource resource, String id, ResourceLocation texturePath) {
        String string = new String(resource.data, StandardCharsets.UTF_8);
        String path = resource.location.m_135815_().replace("oak_leaf_pile", id);
        string = string.replace("immersive_weathering:block/light_oak_leaves", texturePath.toString());
        string = string.replace("immersive_weathering:block/medium_oak_leaves", texturePath.toString());
        string = string.replace("heavy_oak_leaves", id.replace("/", "/heavy_"));
        ResourceLocation newRes = ImmersiveWeathering.res(path);
        ((DynamicTexturePack)this.dynamicPack).addBytes(newRes, string.getBytes(), ResType.GENERIC);
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        TextureImage template;
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)ImmersiveWeathering.res("particle/oak_leaf_0"));
            try (TextureImage template1 = TextureImage.open((ResourceManager)manager, (ResourceLocation)ImmersiveWeathering.res("particle/oak_leaf_1"));){
                Respriter respriter = Respriter.of((TextureImage)template);
                Respriter respriter1 = Respriter.of((TextureImage)template1);
                ModDynamicRegistry.LEAF_TO_TYPE.forEach((pile, type) -> {
                    if (type.isVanilla()) {
                        return;
                    }
                    String path = type.getNamespace() + "/" + type.getTypeName();
                    try (TextureImage baseTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)type.leaves));){
                        TextureImage newImage;
                        Palette targetPalette;
                        ResourceLocation textureRes = ImmersiveWeathering.res(String.format("particle/%s_leaf_0", path));
                        if (!this.alreadyHasTextureAtLocation(manager, textureRes)) {
                            targetPalette = Palette.fromImage((TextureImage)baseTexture);
                            newImage = respriter.recolor(targetPalette);
                            ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                        }
                        if (!this.alreadyHasTextureAtLocation(manager, textureRes = ImmersiveWeathering.res(String.format("particle/%s_leaf_1", path)))) {
                            targetPalette = Palette.fromImage((TextureImage)baseTexture);
                            newImage = respriter1.recolor(targetPalette);
                            ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Fail to generate Leaf Particle texture for type {} : {}", type, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Leaf Particle texture : ", (Throwable)ex);
        }
        ModDynamicRegistry.LEAF_TO_TYPE.forEach((pile, type) -> {
            if (type.isVanilla()) {
                return;
            }
            String path = type.getNamespace() + "/heavy_" + type.getTypeName() + "_leaf_pile";
            try (TextureImage baseTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)type.leaves));){
                ResourceLocation textureRes = ImmersiveWeathering.res(String.format("block/%s", path));
                if (!this.alreadyHasTextureAtLocation(manager, textureRes)) {
                    Palette targetPalette = Palette.fromImage((TextureImage)baseTexture);
                    if (targetPalette.getDarkest().occurrence > 5) {
                        targetPalette.increaseDown();
                    }
                    PaletteColor dark = targetPalette.getDarkest();
                    baseTexture.removeAlpha(dark.value());
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, baseTexture);
                }
            }
            catch (Exception ex) {
                this.getLogger().error("Could not generate heavy leaf pile texture for type {}", type, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)ImmersiveWeathering.res("item/bark_template"));
            try {
                ModDynamicRegistry.MODDED_BARK.forEach((type, bark) -> {
                    if (type.isVanilla()) {
                        return;
                    }
                    ResourceLocation textureRes = ImmersiveWeathering.res("item/" + bark.getRegistryName().m_135815_());
                    if (!this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)type.log, s -> !s.contains("top")));){
                            Palette palette = Palette.fromImage((TextureImage)logTexture);
                            palette.increaseDown();
                            PaletteColor dark = palette.getDarkest();
                            assert (template.imageWidth() <= logTexture.imageWidth() && template.imageHeight() <= logTexture.imageHeight());
                            TextureImage newImage = template.makeCopy();
                            NativeImage logImage = logTexture.getImage();
                            newImage.forEachFrame((i, x, y) -> {
                                NativeImage image = newImage.getImage();
                                int darkBorder = image.m_84985_(x.intValue(), y.intValue());
                                if (darkBorder == -1) {
                                    image.m_84988_(x.intValue(), y.intValue(), NativeImage.m_84992_((int)0, (int)0, (int)0, (int)0));
                                } else if (NativeImage.m_84983_((int)darkBorder) == 0) {
                                    image.m_84988_(x.intValue(), y.intValue(), logImage.m_84985_(x.intValue(), y.intValue()));
                                } else {
                                    image.m_84988_(x.intValue(), y.intValue(), dark.value());
                                }
                            });
                            ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to find log texture for bark {}", type, (Object)ex);
                        }
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("Could not generate any Bark texture : ", (Throwable)e);
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        ModDynamicRegistry.MODDED_BARK.forEach((type, bark) -> LangBuilder.addDynamicEntry((DynamicLanguageManager.LanguageAccessor)lang, (String)"item.immersive_weathering.bark", (BlockType)type, (Item)bark));
        ModDynamicRegistry.LEAF_TO_TYPE.forEach((leaf, type) -> LangBuilder.addDynamicEntry((DynamicLanguageManager.LanguageAccessor)lang, (String)"block.immersive_weathering.leaf_pile", (BlockType)type, (Block)leaf));
    }
}

