/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.integration.dynamic_stuff;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.common.ModBlocks;
import com.ordana.immersive_weathering.common.ModParticles;
import com.ordana.immersive_weathering.common.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.common.items.BurnableItem;
import com.ordana.immersive_weathering.common.items.LeafPileBlockItem;
import com.ordana.immersive_weathering.common.particles.LeafParticle;
import com.ordana.immersive_weathering.integration.dynamic_stuff.ClientDynamicResourcesHandler;
import com.ordana.immersive_weathering.integration.dynamic_stuff.ServerDynamicResourcesHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.selene.block_set.BlockSetManager;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesType;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModDynamicRegistry {
    public static final Map<LeafPileBlock, LeavesType> LEAF_TO_TYPE = new LinkedHashMap<LeafPileBlock, LeavesType>();
    public static final Map<LeavesType, LeafPileBlock> TYPE_TO_LEAF = new LinkedHashMap<LeavesType, LeafPileBlock>();
    public static final Map<ParticleType, LeavesType> LEAF_PARTICLE_TO_TYPE = new LinkedHashMap<ParticleType, LeavesType>();
    public static final Map<LeavesType, ParticleType> TYPE_TO_LEAF_PARTICLE = new LinkedHashMap<LeavesType, ParticleType>();
    public static final Map<Item, LeavesType> LEAF_PILES_ITEMS = new LinkedHashMap<Item, LeavesType>();
    public static final Map<WoodType, Item> MODDED_BARK = new LinkedHashMap<WoodType, Item>();

    public static Map<Block, LeafPileBlock> getLeafToLeafPileMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        LEAF_TO_TYPE.forEach((key, value) -> builder.put((Object)value.leaves, (Object)key));
        return builder.build();
    }

    public static Map<Block, Pair<Item, Block>> getBarkMap() {
        HashMap<Block, Pair<Item, Block>> map = new HashMap<Block, Pair<Item, Block>>();
        MODDED_BARK.forEach((wood, item) -> {
            Block log = wood.log;
            if (wood.strippedLog != null) {
                map.put(wood.strippedLog, Pair.of((Object)item, (Object)log));
            }
        });
        return map;
    }

    private static void registerBarks(RegistryEvent.Register<Item> event, Collection<WoodType> woodTypes) {
        IForgeRegistry registry = event.getRegistry();
        for (WoodType type : woodTypes) {
            if (type.isVanilla()) continue;
            String name = type.getNamespace() + "/" + type.getTypeName() + "_bark";
            Item item = (Item)new BurnableItem(new Item.Properties().m_41491_(CreativeModeTab.f_40759_), 200).setRegistryName(ImmersiveWeathering.res(name));
            registry.register((IForgeRegistryEntry)item);
            MODDED_BARK.put(type, item);
        }
        LEAF_TO_TYPE.forEach((a, b) -> TYPE_TO_LEAF.put((LeavesType)b, (LeafPileBlock)((Object)a)));
    }

    private static void registerLeafPiles(RegistryEvent.Register<Block> event, Collection<LeavesType> leavesTypes) {
        LEAF_TO_TYPE.put((LeafPileBlock)((Object)ModBlocks.OAK_LEAF_PILE.get()), LeavesTypeRegistry.fromNBT((String)"oak"));
        LEAF_TO_TYPE.put((LeafPileBlock)((Object)ModBlocks.BIRCH_LEAF_PILE.get()), LeavesTypeRegistry.fromNBT((String)"birch"));
        LEAF_TO_TYPE.put((LeafPileBlock)((Object)ModBlocks.SPRUCE_LEAF_PILE.get()), LeavesTypeRegistry.fromNBT((String)"spruce"));
        LEAF_TO_TYPE.put((LeafPileBlock)((Object)ModBlocks.JUNGLE_LEAF_PILE.get()), LeavesTypeRegistry.fromNBT((String)"jungle"));
        LEAF_TO_TYPE.put((LeafPileBlock)((Object)ModBlocks.ACACIA_LEAF_PILE.get()), LeavesTypeRegistry.fromNBT((String)"acacia"));
        LEAF_TO_TYPE.put((LeafPileBlock)((Object)ModBlocks.DARK_OAK_LEAF_PILE.get()), LeavesTypeRegistry.fromNBT((String)"dark_oak"));
        LEAF_TO_TYPE.put((LeafPileBlock)((Object)ModBlocks.AZALEA_LEAF_PILE.get()), LeavesTypeRegistry.fromNBT((String)"azalea"));
        LEAF_TO_TYPE.put((LeafPileBlock)((Object)ModBlocks.FLOWERING_AZALEA_LEAF_PILE.get()), LeavesTypeRegistry.fromNBT((String)"flowering_azalea"));
        IForgeRegistry registry = event.getRegistry();
        for (LeavesType type : leavesTypes) {
            if (type.isVanilla()) continue;
            String name = type.getNamespace() + "/" + type.getTypeName() + "_leaf_pile";
            LeafPileBlock block = (LeafPileBlock)new LeafPileBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModBlocks.OAK_LEAF_PILE.get())), false, false, true, List.of(() -> (SimpleParticleType)TYPE_TO_LEAF_PARTICLE.get(type))).setRegistryName(ImmersiveWeathering.res(name));
            registry.register((IForgeRegistryEntry)block);
            LEAF_TO_TYPE.put(block, type);
        }
        LEAF_TO_TYPE.forEach((a, b) -> TYPE_TO_LEAF.put((LeavesType)b, (LeafPileBlock)((Object)a)));
    }

    private static void registerLeafPilesItems(RegistryEvent.Register<Item> event, Collection<LeavesType> leavesTypes) {
        for (LeavesType type : leavesTypes) {
            if (type.isVanilla()) continue;
            LeafPileBlockItem i = new LeafPileBlockItem(TYPE_TO_LEAF.get(type), new Item.Properties().m_41491_(CreativeModeTab.f_40750_));
            i.setRegistryName(TYPE_TO_LEAF.get(type).getRegistryName());
            event.getRegistry().register((IForgeRegistryEntry)i);
        }
    }

    private static void registerLeafPilesParticles(RegistryEvent.Register<ParticleType<?>> event) {
        LEAF_PARTICLE_TO_TYPE.put((ParticleType)ModParticles.OAK_LEAF.get(), LeavesTypeRegistry.fromNBT((String)"oak"));
        LEAF_PARTICLE_TO_TYPE.put((ParticleType)ModParticles.BIRCH_LEAF.get(), LeavesTypeRegistry.fromNBT((String)"birch"));
        LEAF_PARTICLE_TO_TYPE.put((ParticleType)ModParticles.SPRUCE_LEAF.get(), LeavesTypeRegistry.fromNBT((String)"spruce"));
        LEAF_PARTICLE_TO_TYPE.put((ParticleType)ModParticles.JUNGLE_LEAF.get(), LeavesTypeRegistry.fromNBT((String)"jungle"));
        LEAF_PARTICLE_TO_TYPE.put((ParticleType)ModParticles.ACACIA_LEAF.get(), LeavesTypeRegistry.fromNBT((String)"acacia"));
        LEAF_PARTICLE_TO_TYPE.put((ParticleType)ModParticles.DARK_OAK_LEAF.get(), LeavesTypeRegistry.fromNBT((String)"dark_oak"));
        LEAF_PARTICLE_TO_TYPE.put((ParticleType)ModParticles.AZALEA_LEAF.get(), LeavesTypeRegistry.fromNBT((String)"azalea"));
        LEAF_PARTICLE_TO_TYPE.put((ParticleType)ModParticles.AZALEA_FLOWER.get(), LeavesTypeRegistry.fromNBT((String)"flowering_azalea"));
        for (LeavesType type : LeavesTypeRegistry.LEAVES_TYPES.values()) {
            if (type.isVanilla()) continue;
            String name = type.getNamespace() + "/" + type.getTypeName() + "_leaf";
            ParticleType o = (ParticleType)new SimpleParticleType(true).setRegistryName(name);
            event.getRegistry().register((IForgeRegistryEntry)o);
            LEAF_PARTICLE_TO_TYPE.put(o, type);
        }
        LEAF_PARTICLE_TO_TYPE.forEach((a, b) -> TYPE_TO_LEAF_PARTICLE.put((LeavesType)b, (ParticleType)a));
    }

    public static void init(IEventBus bus) {
        BlockSetManager.addBlockSetRegistrationCallback(ModDynamicRegistry::registerLeafPiles, Block.class, LeavesType.class);
        BlockSetManager.addBlockSetRegistrationCallback(ModDynamicRegistry::registerLeafPilesItems, Item.class, LeavesType.class);
        BlockSetManager.addBlockSetRegistrationCallback(ModDynamicRegistry::registerBarks, Item.class, WoodType.class);
        bus.addGenericListener(ParticleType.class, ModDynamicRegistry::registerLeafPilesParticles);
        ServerDynamicResourcesHandler serverRes = new ServerDynamicResourcesHandler();
        serverRes.register(bus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientDynamicResourcesHandler clientRes = new ClientDynamicResourcesHandler();
            clientRes.register(bus);
            bus.addListener(ModDynamicRegistry::initClient);
            bus.addListener(ModDynamicRegistry::registerParticlesRenderers);
        });
    }

    public static void initClient(FMLClientSetupEvent bus) {
    }

    public static void registerParticlesRenderers(ParticleFactoryRegisterEvent event) {
        for (Map.Entry<ParticleType, LeavesType> e : LEAF_PARTICLE_TO_TYPE.entrySet()) {
            if (e.getValue().isVanilla()) continue;
            Minecraft.m_91087_().f_91061_.m_107378_(e.getKey(), LeafParticle.ColoredLeafParticle::new);
        }
    }
}

