/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.mixin;

import com.ordana.immersive_weathering.common.ModBlocks;
import com.ordana.immersive_weathering.common.blocks.AshBlock;
import com.ordana.immersive_weathering.common.blocks.SootLayerBlock;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FireBlock.class})
public abstract class FireMixin {
    @Unique
    private BlockState bs;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(BlockState state, ServerLevel level, BlockPos pos, Random random, CallbackInfo ci) {
        if (level.m_46469_().m_46207_(GameRules.f_46131_)) {
            int smokeHeight = 6;
            BlockPos sootPos = pos;
            for (int i = 0; i < smokeHeight; ++i) {
                BlockState above = level.m_8055_((sootPos = sootPos.m_7494_()).m_7494_());
                if (!Block.m_49918_((VoxelShape)above.m_60812_((BlockGetter)level, sootPos.m_7494_()), (Direction)Direction.DOWN)) continue;
                if (level.m_8055_(sootPos).m_60795_()) {
                    level.m_7731_(sootPos, (BlockState)((Block)ModBlocks.SOOT.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(true)), 2);
                }
                smokeHeight = i + 1;
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;removeBlock(Lnet/minecraft/core/BlockPos;Z)Z", ordinal=3, shift=At.Shift.AFTER)})
    private void removeBlock(BlockState state, ServerLevel serverLevel, BlockPos pos, Random random, CallbackInfo ci) {
        SootLayerBlock.convertToSoot((Level)serverLevel, pos, state);
    }

    @Inject(method={"getFireOdds"}, at={@At(value="HEAD")}, cancellable=true)
    private void canFireReplace(LevelReader reader, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        if (reader.m_8055_(pos).m_60713_((Block)ModBlocks.SOOT.get())) {
            cir.setReturnValue((Object)0);
        }
    }

    @Inject(method={"tryCatchFire"}, at={@At(value="INVOKE", target="net/minecraft/world/level/Level.removeBlock (Lnet/minecraft/core/BlockPos;Z)Z", shift=At.Shift.AFTER)})
    private void afterRemoveBlock(Level pLevel, BlockPos pPos, int pChance, Random pRandom, int pAge, Direction face, CallbackInfo ci) {
        AshBlock.tryConvertToAsh(pLevel, pPos, this.bs);
    }

    @Inject(method={"tryCatchFire"}, at={@At(value="INVOKE", target="net/minecraft/world/level/Level.removeBlock (Lnet/minecraft/core/BlockPos;Z)Z")})
    private void beforeRemoveBlock(Level pLevel, BlockPos pPos, int pChance, Random pRandom, int pAge, Direction face, CallbackInfo ci) {
        this.bs = pLevel.m_8055_(pPos);
    }
}

