/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.service.webmap.kotlin.routes;

import info.journeymap.shaded.kotlin.kotlin.Metadata;
import info.journeymap.shaded.kotlin.kotlin.io.FilesKt;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.Intrinsics;
import info.journeymap.shaded.kotlin.kotlin.math.MathKt;
import info.journeymap.shaded.kotlin.spark.kotlin.RouteHandler;
import info.journeymap.shaded.org.eclipse.jetty.io.EofException;
import info.journeymap.shaded.org.javax.servlet.ServletOutputStream;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import journeymap.client.JourneymapClient;
import journeymap.client.data.WorldData;
import journeymap.client.io.FileHandler;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.model.MapType;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"logger", "Lorg/apache/logging/log4j/Logger;", "tilesGet", "", "handler", "Linfo/journeymap/shaded/kotlin/spark/kotlin/RouteHandler;", "journeymap"})
public final class TilesKt {
    @NotNull
    private static final Logger logger;

    @NotNull
    public static final Object tilesGet(@NotNull RouteHandler handler) {
        Minecraft minecraft;
        Intrinsics.checkNotNullParameter(handler, "handler");
        String string = handler.getRequest().queryParamOrDefault("x", "0");
        Intrinsics.checkNotNullExpressionValue(string, "handler.request.queryParamOrDefault(\"x\", \"0\")");
        int x = Integer.parseInt(string);
        String string2 = handler.getRequest().queryParamOrDefault("y", "0");
        Intrinsics.checkNotNullExpressionValue(string2, "handler.request.queryParamOrDefault(\"y\", \"0\")");
        Integer y = Integer.parseInt(string2);
        String string3 = handler.getRequest().queryParamOrDefault("z", "0");
        Intrinsics.checkNotNullExpressionValue(string3, "handler.request.queryParamOrDefault(\"z\", \"0\")");
        int z = Integer.parseInt(string3);
        String string4 = handler.getRequest().queryParamOrDefault("dimension", "overworld");
        Intrinsics.checkNotNullExpressionValue(string4, "handler.request.queryPar\u2026\"dimension\", \"overworld\")");
        String dimension = string4;
        String string5 = handler.getRequest().queryParamOrDefault("mapTypeString", MapType.Name.day.name());
        Intrinsics.checkNotNullExpressionValue(string5, "handler.request.queryPar\u2026\", MapType.Name.day.name)");
        String mapTypeString = string5;
        String string6 = handler.getRequest().queryParamOrDefault("zoom", "0");
        Intrinsics.checkNotNullExpressionValue(string6, "handler.request.queryParamOrDefault(\"zoom\", \"0\")");
        int zoom = Integer.parseInt(string6);
        Minecraft minecraft2 = minecraft = Minecraft.m_91087_();
        Level level = (Level)(minecraft2 == null ? null : minecraft2.f_91073_);
        if (level == null) {
            logger.warn("Tiles requested before world loaded");
            handler.status(400);
            return "World not loaded";
        }
        if (!JourneymapClient.getInstance().isMapping().booleanValue()) {
            logger.warn("Tiles requested before JourneyMap started");
            handler.status(400);
            return "JourneyMap is still starting";
        }
        File file = FileHandler.getJMWorldDir(minecraft);
        Intrinsics.checkNotNullExpressionValue(file, "getJMWorldDir(minecraft)");
        File worldDir = file;
        try {
            if (!worldDir.exists() || !worldDir.isDirectory()) {
                logger.warn("JM world directory not found");
                handler.status(404);
                return "World not found";
            }
        }
        catch (NullPointerException e) {
            logger.warn("NPE occurred while locating JM world directory");
            handler.status(404);
            return "World not found";
        }
        MapType.Name mapTypeName = null;
        try {
            mapTypeName = MapType.Name.valueOf(mapTypeString);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Invalid map type supplied during tiles request: " + mapTypeString);
            handler.status(400);
            return "Invalid map type: " + mapTypeString;
        }
        if (mapTypeName != MapType.Name.underground) {
            y = null;
        }
        if (mapTypeName == MapType.Name.underground && WorldData.isHardcoreAndMultiplayer()) {
            logger.debug("Blank tile returned for underground view on a hardcore server");
            Object object = handler.getResponse().raw().getOutputStream();
            Intrinsics.checkNotNullExpressionValue(object, "handler.response.raw().outputStream");
            OutputStream output = (OutputStream)object;
            handler.getResponse().raw().setContentType("image/png");
            object = RegionImageHandler.getBlank512x512ImageFile();
            Intrinsics.checkNotNullExpressionValue(object, "getBlank512x512ImageFile()");
            output.write(FilesKt.readBytes((File)object));
            output.flush();
            return handler.getResponse();
        }
        int scale = MathKt.roundToInt(Math.pow(2.0, zoom));
        int distance = 32 / scale;
        int minChunkX = x * distance;
        int minChunkY = z * distance;
        int maxChunkX = minChunkX + distance - 1;
        int maxChunkY = minChunkY + distance - 1;
        ChunkPos startCoord = new ChunkPos(minChunkX, minChunkY);
        ChunkPos endCoord = new ChunkPos(maxChunkX, maxChunkY);
        Boolean bl = JourneymapClient.getInstance().getFullMapProperties().showGrid.get();
        Intrinsics.checkNotNullExpressionValue(bl, "getInstance().fullMapProperties.showGrid.get()");
        boolean showGrid = bl;
        MapType mapType = new MapType(mapTypeName, y, DimensionHelper.getWorldKeyForName(dimension));
        BufferedImage bufferedImage = RegionImageHandler.getMergedChunks(worldDir, startCoord, endCoord, mapType, true, null, 512, 512, false, showGrid);
        Intrinsics.checkNotNullExpressionValue(bufferedImage, "getMergedChunks(\n       \u2026ZE, false, showGrid\n    )");
        BufferedImage img = bufferedImage;
        ServletOutputStream servletOutputStream = handler.getResponse().raw().getOutputStream();
        Intrinsics.checkNotNullExpressionValue(servletOutputStream, "handler.response.raw().outputStream");
        OutputStream output = servletOutputStream;
        try {
            handler.getResponse().raw().setContentType("image/png");
            ImageIO.write((RenderedImage)img, "png", output);
            output.flush();
        }
        catch (EofException e) {
            logger.info("Connection closed while writing image response. Webmap probably reloaded.");
            return "";
        }
        catch (IIOException e) {
            logger.info("Connection closed while writing image response. Webmap probably reloaded.");
            return "";
        }
        return handler.getResponse();
    }

    static {
        Logger logger = Journeymap.getLogger("webmap/routes/tiles");
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(\"webmap/routes/tiles\")");
        TilesKt.logger = logger;
    }
}

