/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.montoyo.mcef.BaseProxy;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.IDisplayHandler;
import net.montoyo.mcef.api.IJSQueryHandler;
import net.montoyo.mcef.api.IScheme;
import net.montoyo.mcef.client.AppHandler;
import net.montoyo.mcef.client.DisplayHandler;
import net.montoyo.mcef.client.MessageRouter;
import net.montoyo.mcef.client.UpdateFrame;
import net.montoyo.mcef.example.ExampleMod;
import net.montoyo.mcef.remote.RemoteConfig;
import net.montoyo.mcef.utilities.Log;
import net.montoyo.mcef.utilities.Util;
import net.montoyo.mcef.virtual.VirtualBrowser;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserOsr;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefRenderer;
import org.cef.handler.CefLifeSpanHandlerAdapter;

public class ClientProxy
extends BaseProxy {
    public static String ROOT = ".";
    public static String JCEF_ROOT = ".";
    public static boolean VIRTUAL = false;
    private CefApp cefApp;
    private CefClient cefClient;
    private CefMessageRouter cefRouter;
    private final ArrayList<CefBrowserOsr> browsers = new ArrayList();
    private final ArrayList<Object> nogc = new ArrayList();
    private String updateStr;
    private final Minecraft mc = Minecraft.m_91087_();
    private final DisplayHandler displayHandler = new DisplayHandler();
    private final HashMap<String, String> mimeTypeMap = new HashMap();
    private final AppHandler appHandler = new AppHandler();
    private ExampleMod exampleMod;

    @Override
    public void onPreInit() {
        this.exampleMod = new ExampleMod();
        this.exampleMod.onPreInit();
    }

    @Override
    public void onInit() {
        super.onInit();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::onInitializeClient);
        MinecraftForge.EVENT_BUS.addListener(this::onTickStart);
        MinecraftForge.EVENT_BUS.addListener(this::onLogin);
    }

    public void onInitializeClient(FMLClientSetupEvent event) {
        Minecraft.m_91087_().m_6937_(() -> {
            File subproc;
            RenderSystem.m_187554_();
            this.appHandler.setArgs(MCEF.CEF_ARGS);
            ROOT = this.mc.f_91069_.getAbsolutePath().replaceAll("\\\\", "/");
            if (ROOT.endsWith(".")) {
                ROOT = ROOT.substring(0, ROOT.length() - 1);
            }
            if (ROOT.endsWith("/")) {
                ROOT = ROOT.substring(0, ROOT.length() - 1);
            }
            JCEF_ROOT = ROOT + "/jcef";
            File fileListing = new File(new File(ROOT), "config");
            RemoteConfig cfg = new RemoteConfig();
            System.out.println("SYSTEM HEADLESS PROPERTY: " + System.getProperty("java.awt.headless"));
            System.setProperty("java.awt.headless", "false");
            UpdateFrame ipl = new UpdateFrame();
            cfg.load();
            System.out.println("Updating MCEF file listing ");
            if (!cfg.updateFileListing(fileListing, false)) {
                Log.warning("There was a problem while establishing file list. Uninstall may not delete all files.", new Object[0]);
            }
            System.out.println("Updating MCEF missing files... ");
            if (!cfg.downloadMissing(ipl)) {
                Log.warning("Going in virtual mode; couldn't download resources.", new Object[0]);
                VIRTUAL = true;
                return;
            }
            if (!cfg.updateFileListing(fileListing, true)) {
                Log.warning("There was a problem while updating file list. Uninstall may not delete all files.", new Object[0]);
            }
            this.updateStr = cfg.getUpdateString();
            ipl.onProgressEnd();
            if (OS.isLinux() && !(subproc = new File(JCEF_ROOT, "jcef_helper")).canExecute()) {
                try {
                    int retCode = Runtime.getRuntime().exec(new String[]{"/usr/bin/chmod", "+x", subproc.getAbsolutePath()}).waitFor();
                    if (retCode != 0) {
                        throw new RuntimeException("chmod exited with code " + retCode);
                    }
                }
                catch (Throwable t) {
                    Log.errorEx("Error while giving execution rights to jcef_helper. MCEF will enter virtual mode. You can fix this by chmoding jcef_helper manually.", t, new Object[0]);
                    VIRTUAL = true;
                }
            }
            if (VIRTUAL) {
                return;
            }
            CefSettings settings = new CefSettings();
            settings.windowless_rendering_enabled = true;
            CefSettings cefSettings = settings;
            Objects.requireNonNull(cefSettings);
            settings.background_color = new CefSettings.ColorType(cefSettings, 0, 255, 255, 255);
            settings.cache_path = new File(JCEF_ROOT, "cache").getAbsolutePath();
            CefApp.startup(MCEF.CEF_ARGS);
            this.cefApp = CefApp.getInstance(settings);
            if (!OS.isLinux()) {
                CefApp.addAppHandler(this.appHandler);
            }
            this.loadMimeTypeMapping();
            this.cefClient = this.cefApp.createClient();
            Log.info(this.cefApp.getVersion().toString(), new Object[0]);
            this.cefRouter = CefMessageRouter.create(new CefMessageRouter.CefMessageRouterConfig("mcefQuery", "mcefCancel"));
            this.cefClient.addMessageRouter(this.cefRouter);
            this.cefClient.addDisplayHandler(this.displayHandler);
            this.cefClient.addLifeSpanHandler(new CefLifeSpanHandlerAdapter(){

                @Override
                public boolean doClose(CefBrowser browser) {
                    browser.close(true);
                    return false;
                }
            });
            if (MCEF.ENABLE_EXAMPLE) {
                this.exampleMod.onInit();
            }
            Log.info("MCEF loaded successfuly.", new Object[0]);
        });
    }

    public CefApp getCefApp() {
        return this.cefApp;
    }

    @Override
    public IBrowser createBrowser(String url, boolean transp) {
        if (VIRTUAL) {
            return new VirtualBrowser();
        }
        System.out.println("Creating CEF browser at url " + url);
        CefBrowserOsr ret = (CefBrowserOsr)this.cefClient.createBrowser(url, true, transp);
        ret.setCloseAllowed();
        ret.createImmediately();
        ret.loadURL("http://localhost:8181");
        this.browsers.add(ret);
        return ret;
    }

    @Override
    public void registerDisplayHandler(IDisplayHandler idh) {
        this.displayHandler.addHandler(idh);
    }

    @Override
    public boolean isVirtual() {
        return VIRTUAL;
    }

    @Override
    public void openExampleBrowser(String url) {
        if (MCEF.ENABLE_EXAMPLE) {
            this.exampleMod.showScreen(url);
        }
    }

    @Override
    public void registerJSQueryHandler(IJSQueryHandler iqh) {
        if (!VIRTUAL) {
            this.cefRouter.addHandler(new MessageRouter(iqh), false);
        }
    }

    @Override
    public void registerScheme(String name, Class<? extends IScheme> schemeClass, boolean std, boolean local, boolean displayIsolated, boolean secure, boolean corsEnabled, boolean cspBypassing, boolean fetchEnabled) {
        this.appHandler.registerScheme(name, schemeClass, std, local, displayIsolated, secure, corsEnabled, cspBypassing, fetchEnabled);
    }

    @Override
    public boolean isSchemeRegistered(String name) {
        return this.appHandler.isSchemeRegistered(name);
    }

    public void onTickStart(TickEvent.ClientTickEvent event) {
        this.mc.m_91307_().m_6180_("MCEF");
        if (this.cefApp != null) {
            this.cefApp.N_DoMessageLoopWork();
        }
        for (CefBrowserOsr b : this.browsers) {
            b.mcefUpdate();
        }
        this.displayHandler.update();
        this.mc.m_91307_().m_7238_();
    }

    public void onLogin(PlayerEvent.PlayerLoggedInEvent ev) {
        if (this.updateStr == null || !MCEF.WARN_UPDATES) {
            return;
        }
        Style cs = Style.f_131099_;
        cs.m_131140_(ChatFormatting.LIGHT_PURPLE);
        MutableComponent cct = (MutableComponent)Component.m_130674_((String)this.updateStr);
        cct.m_178405_(cs);
        ev.getPlayer().m_5661_((Component)cct, true);
    }

    public void removeBrowser(CefBrowserOsr b) {
        this.browsers.remove(b);
    }

    @Override
    public IBrowser createBrowser(String url) {
        return this.createBrowser(url, false);
    }

    private void runMessageLoopFor(long ms) {
        long start = System.currentTimeMillis();
        do {
            this.cefApp.N_DoMessageLoopWork();
        } while (System.currentTimeMillis() - start < ms);
    }

    @Override
    public void onShutdown() {
        if (VIRTUAL) {
            return;
        }
        Log.info("Shutting down JCEF...", new Object[0]);
        CefBrowserOsr.CLEANUP = false;
        for (CefBrowserOsr b : this.browsers) {
            b.close();
        }
        this.browsers.clear();
        if (MCEF.CHECK_VRAM_LEAK) {
            CefRenderer.dumpVRAMLeak();
        }
        this.runMessageLoopFor(100L);
        CefApp.forceShutdownState();
        this.cefClient.dispose();
        if (MCEF.SHUTDOWN_JCEF) {
            this.cefApp.N_Shutdown();
        }
    }

    public void loadMimeTypeMapping() {
        Pattern p = Pattern.compile("^(\\S+)\\s+(\\S+)\\s*(\\S*)\\s*(\\S*)$");
        String line = "";
        int cLine = 0;
        this.mimeTypeMap.clear();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(ClientProxy.class.getResourceAsStream("/assets/mcef/mime.types")));
            while (true) {
                Matcher m;
                ++cLine;
                line = br.readLine();
                if (line == null) break;
                if ((line = line.trim()).startsWith("#") || !(m = p.matcher(line)).matches()) continue;
                this.mimeTypeMap.put(m.group(2), m.group(1));
                if (m.groupCount() < 4 || m.group(3).isEmpty()) continue;
                this.mimeTypeMap.put(m.group(3), m.group(1));
                if (m.groupCount() < 5 || m.group(4).isEmpty()) continue;
                this.mimeTypeMap.put(m.group(4), m.group(1));
            }
            Util.close(br);
        }
        catch (Throwable e) {
            Log.error("[Mime Types] Error while parsing \"%s\" at line %d:", line, cLine);
            e.printStackTrace();
        }
        Log.info("Loaded %d mime types", this.mimeTypeMap.size());
    }

    @Override
    public String mimeTypeFromExtension(String ext) {
        String ret = this.mimeTypeMap.get(ext = ext.toLowerCase());
        if (ret != null) {
            return ret;
        }
        switch (ext) {
            case "htm": 
            case "html": {
                return "text/html";
            }
            case "css": {
                return "text/css";
            }
            case "js": {
                return "text/javascript";
            }
            case "png": {
                return "image/png";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "gif": {
                return "image/gif";
            }
            case "svg": {
                return "image/svg+xml";
            }
            case "xml": {
                return "text/xml";
            }
            case "txt": {
                return "text/plain";
            }
        }
        return null;
    }
}

