/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.example;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.api.API;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.MCEFApi;
import net.montoyo.mcef.example.ExampleMod;
import net.montoyo.mcef.example.ScreenCfg;
import org.lwjgl.glfw.GLFW;

public class BrowserScreen
extends Screen {
    IBrowser browser = null;
    private Button back = null;
    private Button fwd = null;
    private Button go = null;
    private Button min = null;
    private Button vidMode = null;
    private boolean vidModeState = false;
    private EditBox url = null;
    private String urlToLoad = null;
    private long initTime = System.currentTimeMillis();
    private static final String YT_REGEX1 = "^https?://(?:www\\.)?youtube\\.com/watch\\?v=([a-zA-Z0-9_\\-]+)$";
    private static final String YT_REGEX2 = "^https?://(?:www\\.)?youtu\\.be/([a-zA-Z0-9_\\-]+)$";
    private static final String YT_REGEX3 = "^https?://(?:www\\.)?youtube\\.com/embed/([a-zA-Z0-9_\\-]+)(\\?.+)?$";

    public BrowserScreen() {
        super((Component)new TranslatableComponent("forgecef.example.screen.title"));
        this.urlToLoad = MCEF.HOME_PAGE;
    }

    public BrowserScreen(String url) {
        super((Component)new TranslatableComponent("forgecef.example.screen.title"));
        this.urlToLoad = url == null ? MCEF.HOME_PAGE : url;
    }

    public void m_7856_() {
        super.m_7856_();
        ExampleMod.INSTANCE.hudBrowser = null;
        if (this.browser == null) {
            API api = MCEFApi.getAPI();
            if (api == null) {
                return;
            }
            this.browser = api.createBrowser(this.urlToLoad == null ? MCEF.HOME_PAGE : this.urlToLoad, false);
            this.browser.resize(this.f_96541_.m_91268_().m_85443_(), this.f_96541_.m_91268_().m_85444_() - this.scaleY(20));
            this.urlToLoad = null;
        }
        if (this.url == null) {
            this.back = new Button(0, 0, 20, 20, (Component)new TextComponent("<"), button -> this.legacyActionPerformed(0));
            this.m_142416_((GuiEventListener)this.back);
            this.fwd = new Button(20, 0, 20, 20, (Component)new TextComponent(">"), button -> this.legacyActionPerformed(1));
            this.m_142416_((GuiEventListener)this.fwd);
            this.go = new Button(this.f_96543_ - 60, 0, 20, 20, (Component)new TranslatableComponent("fabricef.example.screen.go"), button -> this.legacyActionPerformed(2));
            this.m_142416_((GuiEventListener)this.go);
            this.min = new Button(this.f_96543_ - 20, 0, 20, 20, (Component)new TextComponent("_"), button -> this.legacyActionPerformed(3));
            this.m_142416_((GuiEventListener)this.min);
            this.vidMode = new Button(this.f_96543_ - 40, 0, 20, 20, (Component)new TextComponent("YT"), button -> this.legacyActionPerformed(4));
            this.m_142416_((GuiEventListener)this.vidMode);
            this.vidModeState = false;
            this.url = new EditBox(this.f_96541_.f_91062_, 40, 0, this.f_96543_ - 100, 20, (Component)new TextComponent(""));
            this.url.m_94199_(65535);
            this.url.m_94144_(this.browser.getURL());
        } else {
            this.m_142416_((GuiEventListener)this.fwd);
            this.m_142416_((GuiEventListener)this.go);
            this.m_142416_((GuiEventListener)this.min);
            this.m_142416_((GuiEventListener)this.vidMode);
            this.vidMode.f_93620_ = this.f_96543_ - 40;
            this.go.f_93620_ = this.f_96543_ - 60;
            this.min.f_93620_ = this.f_96543_ - 20;
            String old = this.url.m_94155_();
            this.url = new EditBox(this.f_96541_.f_91062_, 40, 0, this.f_96543_ - 100, 20, (Component)new TextComponent(""));
            this.url.m_94199_(65535);
            this.url.m_94144_(old);
        }
        this.initTime = System.currentTimeMillis();
    }

    public int scaleY(int y) {
        assert (this.f_96541_ != null);
        double sy = (double)y / (double)this.f_96544_ * (double)this.f_96541_.m_91268_().m_85444_();
        return (int)sy;
    }

    public int scaleX(int x) {
        assert (this.f_96541_ != null);
        double sx = (double)x / (double)this.f_96543_ * (double)this.f_96541_.m_91268_().m_85443_();
        return (int)sx;
    }

    public void loadURL(String url) {
        if (this.browser == null) {
            this.urlToLoad = url;
        } else {
            this.browser.loadURL(url);
        }
    }

    public void preRender() {
        if (this.urlToLoad != null && this.browser != null) {
            this.browser.loadURL(this.urlToLoad);
            this.urlToLoad = null;
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.preRender();
        this.url.m_6305_(matrices, mouseX, mouseY, delta);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        if (this.browser != null) {
            GlStateManager.m_84507_();
            GlStateManager.m_84110_();
            this.browser.draw(matrices, 0.0, this.f_96544_, this.f_96543_, 20.0);
            GlStateManager.m_84513_();
        }
    }

    public void m_7379_() {
        if (!ExampleMod.INSTANCE.hasBackup() && this.browser != null) {
            this.browser.close();
        }
        super.m_7379_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.keyChanged(keyCode, scanCode, modifiers, true) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.keyChanged(keyCode, scanCode, modifiers, false) || super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.browser != null && !this.url.m_93696_()) {
            this.browser.injectKeyTyped(codePoint, modifiers);
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean keyChanged(int keyCode, int scanCode, int modifiers, boolean pressed) {
        assert (this.f_96541_ != null);
        if (keyCode == 256) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        if (keyCode == 299) {
            System.out.println("Early term F10");
            if (pressed && System.currentTimeMillis() - this.initTime > 1000L) {
                this.url.m_94178_(!this.url.m_93696_());
            }
            return true;
        }
        boolean focused = this.url.m_93696_();
        String keystr = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
        System.out.println("KEY STR " + keystr);
        if (keystr == null) {
            keystr = "\u0000";
        }
        if (keyCode == 257) {
            keystr = "\n";
        }
        if (keystr.length() == 0) {
            return false;
        }
        char key = keystr.charAt(keystr.length() - 1);
        if (this.browser != null && !focused) {
            System.out.println("Sent keystroke " + keystr);
            if (pressed) {
                this.browser.injectKeyPressedByKeyCode(keyCode, key, 0);
            } else {
                this.browser.injectKeyReleasedByKeyCode(keyCode, key, 0);
            }
            if (key == '\n') {
                this.browser.injectKeyTyped(key, 0);
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.mouseChanged(mouseX, mouseY, button, 0.0, 0.0, 0.0, true) || super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.mouseChanged(mouseX, mouseY, button, 0.0, 0.0, 0.0, false) || super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.mouseChanged(mouseX, mouseY, button, deltaX, deltaY, 0.0, true) || super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return this.mouseChanged(mouseX, mouseY, -1, 0.0, 0.0, 0.0, false) || super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean mouseChanged(double mouseX, double mouseY, int btn, double deltaX, double deltaY, double scrollAmount, boolean pressed) {
        int sx = this.scaleX((int)mouseX);
        int sy = (int)mouseY;
        int wheel = (int)scrollAmount;
        if (this.browser != null) {
            int y = this.scaleY(sy - 20);
            System.out.println("Dest coords " + sx + " " + y + " button " + btn + " " + pressed);
            if (wheel != 0) {
                this.browser.injectMouseWheel(sx, y, 0, wheel, 0);
            } else if (btn == -1) {
                this.browser.injectMouseMove(sx, y, 0, y < 0);
            } else {
                this.browser.injectMouseButton(sx, y, 0, btn + 1, pressed, 1);
            }
        }
        return !(mouseY <= 20.0);
    }

    public void onUrlChanged(IBrowser b, String nurl) {
        if (b == this.browser && this.url != null) {
            this.url.m_94144_(nurl);
            this.vidModeState = nurl.matches(YT_REGEX1) || nurl.matches(YT_REGEX2) || nurl.matches(YT_REGEX3);
        }
    }

    protected void legacyActionPerformed(int id) {
        if (this.browser == null) {
            return;
        }
        if (id == 0) {
            this.browser.goBack();
        } else if (id == 1) {
            this.browser.goForward();
        } else if (id == 2) {
            String fixedURL = ExampleMod.INSTANCE.getAPI().punycode(this.url.m_94155_());
            this.browser.loadURL(fixedURL);
        } else if (id == 3) {
            ExampleMod.INSTANCE.setBackup(this);
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_(null);
        } else if (id == 4) {
            String loc = this.browser.getURL();
            String vId = null;
            boolean redo = false;
            if (loc.matches(YT_REGEX1)) {
                vId = loc.replaceFirst(YT_REGEX1, "$1");
            } else if (loc.matches(YT_REGEX2)) {
                vId = loc.replaceFirst(YT_REGEX2, "$1");
            } else if (loc.matches(YT_REGEX3)) {
                redo = true;
            }
            if (vId != null || redo) {
                ExampleMod.INSTANCE.setBackup(this);
                this.f_96541_.m_91152_((Screen)new ScreenCfg(this.browser, vId));
            }
        }
    }
}

