/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.remote;

import java.io.File;
import net.montoyo.mcef.client.ClientProxy;
import net.montoyo.mcef.utilities.IProgressListener;
import net.montoyo.mcef.utilities.Log;
import net.montoyo.mcef.utilities.Util;

public class Resource {
    private String platform;
    private String name;
    private String sum;
    private boolean shouldExtract = false;

    public Resource(String name, String sum, String platform) {
        this.name = name;
        this.sum = sum.trim();
        this.platform = platform;
    }

    public boolean exists() {
        File f = new File(ClientProxy.JCEF_ROOT, this.name);
        return f.exists();
    }

    public boolean download(IProgressListener ipl) {
        File dst;
        File parent;
        Object end = "";
        if (this.shouldExtract) {
            end = (String)end + ".gz";
        }
        if (!(parent = (dst = new File(ClientProxy.JCEF_ROOT, this.name)).getParentFile()).exists() && !parent.mkdirs()) {
            Log.warning("Couldn't create directory %s... ignoring this error, but this might cause some issues later...", parent.getAbsolutePath());
        }
        return Util.download("1.33/" + this.platform + "/" + this.name + (String)end, dst, this.shouldExtract, ipl);
    }

    public boolean extract(IProgressListener ipl) {
        Util.secure(ipl).onTaskChanged("Extracting " + this.name);
        return Util.extract(new File(ClientProxy.JCEF_ROOT, this.name), new File(ClientProxy.JCEF_ROOT));
    }

    public void setShouldExtract() {
        this.shouldExtract = true;
        this.name = this.name.substring(0, this.name.length() - 3);
    }

    public String getFileName() {
        return this.name;
    }

    public static File getLocationOf(String resName) {
        return new File(ClientProxy.JCEF_ROOT, resName);
    }
}

