/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.setup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.montoyo.mcef.setup.SetupUtil;

public class CfgParser {
    private ArrayList<Line> lines = new ArrayList();
    private HashMap<String, HashMap<String, PropertyLine>> data = new HashMap();
    private File location;

    public CfgParser(File loc) {
        this.location = loc;
    }

    public boolean load() {
        try {
            this.unsafeRead();
            return true;
        }
        catch (Throwable t) {
            System.err.println("Could not read config file \"" + this.location.getAbsolutePath() + "\":");
            t.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unsafeRead() throws Throwable {
        String line;
        this.lines.clear();
        this.data.clear();
        BufferedReader br = new BufferedReader(new FileReader(this.location));
        String currentCategory = null;
        int lineCnt = 0;
        while ((line = br.readLine()) != null) {
            void var6_6;
            String trimmed = line.trim();
            if (trimmed.isEmpty() || trimmed.charAt(0) == '#') {
                CommentLine commentLine = new CommentLine(line);
            } else {
                Line line2 = LineType.parseLine(line);
            }
            if (var6_6 == null) {
                throw new RuntimeException("Could not parse line #" + (lineCnt + 1) + ".");
            }
            if (var6_6 instanceof BeginCategoryLine) {
                if (currentCategory != null) throw new RuntimeException("At line #" + (lineCnt + 1) + ": Forgot to close brackets.");
                currentCategory = ((BeginCategoryLine)var6_6).getCategoryName();
                this.data.put(currentCategory, new HashMap());
            } else if (var6_6 instanceof EndCategoryLine) {
                if (currentCategory == null) {
                    throw new RuntimeException("At line #" + (lineCnt + 1) + ": Closing non-opened bracket.");
                }
                currentCategory = null;
            } else if (var6_6 instanceof PropertyLine) {
                if (currentCategory == null) {
                    throw new RuntimeException("At line #" + (lineCnt + 1) + ": Setting property outside brackets.");
                }
                this.data.get(currentCategory).put(((PropertyLine)var6_6).getKey(), (PropertyLine)var6_6);
            }
            this.lines.add((Line)var6_6);
            ++lineCnt;
        }
        SetupUtil.silentClose(br);
    }

    public boolean save() {
        try {
            this.unsafeWrite();
            return true;
        }
        catch (Throwable t) {
            System.err.println("Could not write config file \"" + this.location.getAbsolutePath() + "\":");
            t.printStackTrace();
            return false;
        }
    }

    private void unsafeWrite() throws Throwable {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.location));
        for (Line l : this.lines) {
            l.write(bw);
        }
        SetupUtil.silentClose(bw);
    }

    private int findCategoryBeginning(String cat) {
        for (int i = 0; i < this.lines.size(); ++i) {
            Line l = this.lines.get(i);
            if (!(l instanceof BeginCategoryLine) || !((BeginCategoryLine)l).getCategoryName().equals(cat)) continue;
            return i;
        }
        return -1;
    }

    private PropertyLine getValue(char type, String category, String key, String def) {
        if (this.data.containsKey(category)) {
            HashMap<String, PropertyLine> subdata = this.data.get(category);
            if (subdata.containsKey(key)) {
                return subdata.get(key);
            }
            int pos = this.findCategoryBeginning(category);
            if (pos < 0) {
                throw new RuntimeException("Could not find beginning for category \"" + category + "\"! This should NOT happen!");
            }
            PropertyLine pl = new PropertyLine(type, key, def);
            this.lines.add(pos + 1, pl);
            subdata.put(key, pl);
            return pl;
        }
        BeginCategoryLine bcl = new BeginCategoryLine(category);
        PropertyLine pl = new PropertyLine(type, key, def);
        EndCategoryLine ecl = new EndCategoryLine();
        this.lines.add(bcl);
        this.lines.add(pl);
        this.lines.add(ecl);
        HashMap<String, PropertyLine> subdata = new HashMap<String, PropertyLine>();
        subdata.put(key, pl);
        this.data.put(category, subdata);
        return pl;
    }

    public String getStringValue(String category, String key, String def) {
        return this.getValue('S', category, key, def).getValue();
    }

    public boolean getBooleanValue(String category, String key, boolean def) {
        return this.getValue('B', category, key, def ? "true" : "false").getBooleanValue(def);
    }

    public void setStringValue(String category, String key, String val) {
        this.getValue('S', category, key, val).setValue(val);
    }

    public void setBooleanValue(String category, String key, boolean val) {
        String data = val ? "true" : "false";
        this.getValue('B', category, key, data).setValue(data);
    }

    private static class CommentLine
    extends Line {
        private String data;

        public CommentLine(String d) {
            this.data = d;
        }

        @Override
        public void write(BufferedWriter bw) throws IOException {
            bw.write(this.data + "\n");
        }

        @Override
        public void read(String content, Matcher m) {
            this.data = content;
        }
    }

    private static enum LineType {
        CATEGORY_BEGIN("^(\\s*)([a-z]+)(\\s+)\\{(\\s*)$", BeginCategoryLine.class),
        CATEGORY_END("^(\\s*)\\}(\\s*)$", EndCategoryLine.class),
        PROPERTY("^(\\s*)([A-Z])\\:([A-Za-z]+)=(.*)$", PropertyLine.class);

        private final Pattern pattern;
        private final Class<? extends Line> cls;

        private LineType(String regex, Class<? extends Line> cls) {
            this.pattern = Pattern.compile(regex);
            this.cls = cls;
        }

        public static Line parseLine(String l) {
            for (LineType lt : LineType.values()) {
                Matcher m = lt.pattern.matcher(l);
                if (!m.matches()) continue;
                try {
                    Line ret = lt.cls.newInstance();
                    ret.read(l, m);
                    return ret;
                }
                catch (Throwable t) {
                    System.err.println("Could not instantiate line class \"" + lt.cls.getCanonicalName() + "\":");
                    t.printStackTrace();
                    return null;
                }
            }
            return null;
        }
    }

    private static abstract class Line {
        private Line() {
        }

        public abstract void write(BufferedWriter var1) throws IOException;

        public abstract void read(String var1, Matcher var2);
    }

    private static class BeginCategoryLine
    extends Line {
        public static final String REGEX = "^(\\s*)([a-z]+)(\\s+)\\{(\\s*)$";
        private String prefix;
        private String category;
        private String inBetween;
        private String suffix;

        public BeginCategoryLine() {
        }

        public BeginCategoryLine(String name) {
            this.prefix = "";
            this.category = name;
            this.inBetween = " ";
            this.suffix = "";
        }

        @Override
        public void write(BufferedWriter bw) throws IOException {
            bw.write(this.prefix);
            bw.write(this.category);
            bw.write(this.inBetween);
            bw.write("{");
            bw.write(this.suffix + "\n");
        }

        @Override
        public void read(String content, Matcher m) {
            this.prefix = m.group(1);
            this.category = m.group(2);
            this.inBetween = m.group(3);
            this.suffix = m.group(4);
        }

        public String getCategoryName() {
            return this.category;
        }
    }

    private static class EndCategoryLine
    extends Line {
        public static final String REGEX = "^(\\s*)\\}(\\s*)$";
        private String prefix = "";
        private String suffix = "";

        @Override
        public void write(BufferedWriter bw) throws IOException {
            bw.write(this.prefix);
            bw.write("}");
            bw.write(this.suffix + "\n");
        }

        @Override
        public void read(String content, Matcher m) {
            this.prefix = m.group(1);
            this.suffix = m.group(2);
        }
    }

    private static class PropertyLine
    extends Line {
        public static final String REGEX = "^(\\s*)([A-Z])\\:([A-Za-z]+)=(.*)$";
        private String prefix;
        private char type;
        private String key;
        private String value;

        public PropertyLine() {
        }

        public PropertyLine(char t, String key, String val) {
            this.prefix = "    ";
            this.type = t;
            this.key = key;
            this.value = val;
        }

        @Override
        public void write(BufferedWriter bw) throws IOException {
            bw.write(this.prefix);
            bw.write(this.type + ":" + this.key);
            bw.write("=" + this.value + "\n");
        }

        @Override
        public void read(String content, Matcher m) {
            this.prefix = m.group(1);
            this.type = m.group(2).charAt(0);
            this.key = m.group(3);
            this.value = m.group(4);
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean getBooleanValue(boolean def) {
            String data = this.value.trim().toLowerCase();
            if (data.equals("false")) {
                return false;
            }
            if (data.equals("true")) {
                return true;
            }
            this.value = def ? "true" : "false";
            return def;
        }

        public void setValue(String v) {
            this.value = v;
        }
    }
}

