/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.setup;

import java.util.Comparator;

final class SlashComparator
implements Comparator<String> {
    private Comparator<String> fallback;

    SlashComparator(Comparator<String> fb) {
        this.fallback = fb;
    }

    @Override
    public int compare(String a, String b) {
        int i;
        int slashA = 0;
        int slashB = 0;
        for (i = 0; i < a.length(); ++i) {
            if (a.charAt(i) != '/' && a.charAt(i) != '\\') continue;
            ++slashA;
        }
        for (i = 0; i < b.length(); ++i) {
            if (b.charAt(i) != '/' && b.charAt(i) != '\\') continue;
            ++slashB;
        }
        int ret = slashB - slashA;
        if (ret == 0 && this.fallback != null) {
            return this.fallback.compare(a, b);
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof SlashComparator) {
            SlashComparator other = (SlashComparator)obj;
            if (this.fallback == null) {
                return other.fallback == null;
            }
            return other.fallback != null && this.fallback.equals(other.fallback);
        }
        return false;
    }
}

