/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.Nullable;

public abstract class BaseOptionElementWidget<T extends OptionMenuElement>
extends CommentedElementWidget<T> {
    protected static final Component SET_TO_DEFAULT = new TranslatableComponent("options.iris.setToDefault").m_130940_(ChatFormatting.GREEN);
    protected static final Component DIVIDER = new TextComponent(": ");
    protected MutableComponent unmodifiedLabel;
    protected ShaderPackScreen screen;
    protected NavigationController navigation;
    private MutableComponent label;
    protected Component trimmedLabel;
    protected Component valueLabel;
    private boolean isLabelTrimmed;
    private int maxLabelWidth;
    private int valueSectionWidth;

    public BaseOptionElementWidget(T element) {
        super(element);
    }

    @Override
    public void init(ShaderPackScreen screen, NavigationController navigation) {
        this.screen = screen;
        this.navigation = navigation;
        this.valueLabel = null;
        this.trimmedLabel = null;
    }

    protected final void setLabel(MutableComponent label) {
        this.label = label.m_6881_().m_7220_(DIVIDER);
        this.unmodifiedLabel = label;
    }

    protected final void updateRenderParams(int width, int minValueSectionWidth) {
        if (this.valueLabel == null) {
            this.valueLabel = this.createValueLabel();
        }
        Font font = Minecraft.m_91087_().f_91062_;
        this.valueSectionWidth = Math.max(minValueSectionWidth, font.m_92852_((FormattedText)this.valueLabel) + 8);
        this.maxLabelWidth = width - 8 - this.valueSectionWidth;
        if (this.trimmedLabel == null || font.m_92852_((FormattedText)this.label) > this.maxLabelWidth != this.isLabelTrimmed) {
            this.updateLabels();
        }
        this.isLabelTrimmed = font.m_92852_((FormattedText)this.label) > this.maxLabelWidth;
    }

    protected final void renderOptionWithValue(PoseStack poseStack, int x, int y, int width, int height, boolean hovered, float sliderPosition, int sliderWidth) {
        GuiUtil.bindIrisWidgetsTexture();
        GuiUtil.drawButton(poseStack, x, y, width, height, hovered, false);
        GuiUtil.drawButton(poseStack, x + width - (this.valueSectionWidth + 2), y + 2, this.valueSectionWidth, height - 4, false, true);
        if (sliderPosition >= 0.0f) {
            int sliderSpace = this.valueSectionWidth - 4 - sliderWidth;
            int sliderPos = x + width - this.valueSectionWidth + (int)(sliderPosition * (float)sliderSpace);
            GuiUtil.drawButton(poseStack, sliderPos, y + 4, sliderWidth, height - 8, false, false);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        font.m_92763_(poseStack, this.trimmedLabel, (float)(x + 6), (float)(y + 7), 0xFFFFFF);
        font.m_92763_(poseStack, this.valueLabel, (float)(x + (width - 2) - (int)((double)this.valueSectionWidth * 0.5) - (int)((double)font.m_92852_((FormattedText)this.valueLabel) * 0.5)), (float)(y + 7), 0xFFFFFF);
    }

    protected final void renderOptionWithValue(PoseStack poseStack, int x, int y, int width, int height, boolean hovered) {
        this.renderOptionWithValue(poseStack, x, y, width, height, hovered, -1.0f, 0);
    }

    protected final void tryRenderTooltip(PoseStack poseStack, int mouseX, int mouseY, boolean hovered) {
        if (Screen.m_96638_()) {
            this.renderTooltip(poseStack, SET_TO_DEFAULT, mouseX, mouseY, hovered);
        } else if (this.isLabelTrimmed && !this.screen.isDisplayingComment()) {
            this.renderTooltip(poseStack, (Component)this.unmodifiedLabel, mouseX, mouseY, hovered);
        }
    }

    protected final void renderTooltip(PoseStack poseStack, Component text, int mouseX, int mouseY, boolean hovered) {
        if (hovered) {
            ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(Minecraft.m_91087_().f_91062_, poseStack, text, mouseX + 2, mouseY - 16));
        }
    }

    protected final void updateLabels() {
        this.trimmedLabel = this.createTrimmedLabel();
        this.valueLabel = this.createValueLabel();
    }

    protected final Component createTrimmedLabel() {
        MutableComponent label = GuiUtil.shortenText(Minecraft.m_91087_().f_91062_, this.label.m_6881_(), this.maxLabelWidth);
        if (this.isValueModified()) {
            label = label.m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)16763210)));
        }
        return label;
    }

    protected abstract Component createValueLabel();

    public abstract boolean applyNextValue();

    public abstract boolean applyPreviousValue();

    public abstract boolean applyOriginalValue();

    public abstract boolean isValueModified();

    @Nullable
    public abstract String getCommentKey();

    @Override
    public Optional<Component> getCommentTitle() {
        return Optional.of(this.unmodifiedLabel);
    }

    @Override
    public Optional<Component> getCommentBody() {
        return Optional.ofNullable(this.getCommentKey()).map(key -> I18n.m_118936_((String)key) ? new TranslatableComponent(key) : null);
    }

    @Override
    public boolean mouseClicked(double mx, double my, int button) {
        if (button == 0 || button == 1) {
            boolean refresh = false;
            if (Screen.m_96638_()) {
                refresh = this.applyOriginalValue();
            }
            if (!refresh) {
                refresh = button == 0 ? this.applyNextValue() : this.applyPreviousValue();
            }
            if (refresh) {
                this.navigation.refresh();
            }
            GuiUtil.playButtonClickSound();
            return true;
        }
        return super.mouseClicked(mx, my, button);
    }
}

