/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.option;

import java.io.IOException;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.option.ShadowDistanceOption;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ProgressOption;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;

public class IrisVideoSettings {
    public static int shadowDistance = 32;
    private static final Component DISABLED_TOOLTIP = new TranslatableComponent("options.iris.shadowDistance.disabled");
    private static final Component ENABLED_TOOLTIP = new TranslatableComponent("options.iris.shadowDistance.enabled");
    public static final ProgressOption RENDER_DISTANCE = new ShadowDistanceOption("options.iris.shadowDistance", 0.0, 32.0, 1.0f, gameOptions -> IrisVideoSettings.getOverriddenShadowDistance(shadowDistance), (gameOptions, viewDistance) -> {
        double outputShadowDistance = viewDistance;
        shadowDistance = (int)outputShadowDistance;
        try {
            Iris.getIrisConfig().save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }, (gameOptions, option) -> {
        int d = (int)option.m_92221_(gameOptions);
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline != null) {
            d = pipeline.getForcedShadowRenderDistanceChunksForDisplay().orElse(d);
        }
        if ((double)d <= 0.0) {
            return new TranslatableComponent("options.generic_value", new Object[]{new TranslatableComponent("options.iris.shadowDistance"), "0 (disabled)"});
        }
        return new TranslatableComponent("options.generic_value", new Object[]{new TranslatableComponent("options.iris.shadowDistance"), new TranslatableComponent("options.chunks", new Object[]{d})});
    }, client -> {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        Component tooltip = pipeline != null ? (pipeline.getForcedShadowRenderDistanceChunksForDisplay().isPresent() ? DISABLED_TOOLTIP : ENABLED_TOOLTIP) : ENABLED_TOOLTIP;
        return Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)tooltip, 200);
    });

    public static int getOverriddenShadowDistance(int base) {
        return Iris.getPipelineManager().getPipeline().map(pipeline -> pipeline.getForcedShadowRenderDistanceChunksForDisplay().orElse(base)).orElse(base);
    }

    public static boolean isShadowDistanceSliderEnabled() {
        return Iris.getPipelineManager().getPipeline().map(pipeline -> !pipeline.getForcedShadowRenderDistanceChunksForDisplay().isPresent()).orElse(true);
    }
}

