/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.newshader.TriforcePatcher;
import net.coderbot.iris.pipeline.newshader.fallback.FallbackShader;
import net.coderbot.iris.pipeline.newshader.fallback.ShaderSynthesizer;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;

public class NewShaderTests {
    public static ExtendedShader create(String name, ProgramSource source, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, GlFramebuffer baseline, AlphaTest fallbackAlpha, VertexFormat vertexFormat, FrameUpdateNotifier updateNotifier, NewWorldRenderingPipeline parent, FogMode fogMode, boolean isFullbright) throws IOException {
        AlphaTest alpha = source.getDirectives().getAlphaTestOverride().orElse(fallbackAlpha);
        BlendModeOverride blendModeOverride = source.getDirectives().getBlendModeOverride();
        ShaderAttributeInputs inputs = new ShaderAttributeInputs(vertexFormat, isFullbright);
        String geometry = null;
        boolean hasGeometry = false;
        if (source.getGeometrySource().isPresent()) {
            hasGeometry = true;
            geometry = TriforcePatcher.patchVanilla(source.getGeometrySource().get(), ShaderType.GEOMETRY, alpha, true, inputs, true);
        }
        String vertex = TriforcePatcher.patchVanilla(source.getVertexSource().orElseThrow(RuntimeException::new), ShaderType.VERTEX, alpha, true, inputs, hasGeometry);
        String fragment = TriforcePatcher.patchVanilla(source.getFragmentSource().orElseThrow(RuntimeException::new), ShaderType.FRAGMENT, alpha, true, inputs, hasGeometry);
        StringBuilder shaderJson = new StringBuilder("{\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"" + name + "\",\n    \"fragment\": \"" + name + "\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n        \"UV0\",\n        \"UV1\",\n        \"UV2\",\n        \"Normal\"\n    ],\n    \"samplers\": [\n        { \"name\": \"gtexture\" },\n        { \"name\": \"texture\" },\n        { \"name\": \"tex\" },\n        { \"name\": \"iris_overlay\" },\n        { \"name\": \"lightmap\" },\n        { \"name\": \"normals\" },\n        { \"name\": \"specular\" },\n        { \"name\": \"shadow\" },\n        { \"name\": \"watershadow\" },\n        { \"name\": \"shadowtex0\" },\n        { \"name\": \"shadowtex1\" },\n        { \"name\": \"depthtex0\" },\n        { \"name\": \"depthtex1\" },\n        { \"name\": \"noisetex\" },\n");
        for (int buffer : PackRenderTargetDirectives.BASELINE_SUPPORTED_RENDER_TARGETS) {
            if (buffer >= 4 && buffer < PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) {
                shaderJson.append("        { \"name\": \"");
                shaderJson.append((String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(buffer));
                shaderJson.append("\" },\n");
            }
            shaderJson.append("        { \"name\": \"colortex");
            shaderJson.append(buffer);
            shaderJson.append("\" },\n");
        }
        shaderJson.append("        { \"name\": \"shadowcolor\" },\n        { \"name\": \"shadowcolor0\" },\n        { \"name\": \"shadowcolor1\" }\n    ],\n    \"uniforms\": [\n        { \"name\": \"iris_TextureMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ChunkOffset\", \"type\": \"float\", \"count\": 3, \"values\": [ 0.0, 0.0, 0.0 ] },\n        { \"name\": \"iris_ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n        { \"name\": \"iris_FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        { \"name\": \"iris_FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"iris_LineWidth\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"iris_ScreenSize\", \"type\": \"float\", \"count\": 2, \"values\": [ 1.0, 1.0 ] },\n        { \"name\": \"iris_FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] }\n    ]\n}");
        String shaderJsonString = shaderJson.toString();
        IrisProgramResourceFactory shaderResourceFactory = new IrisProgramResourceFactory(shaderJsonString, vertex, geometry, fragment);
        if (!FMLLoader.isProduction()) {
            Path debugOutDir = FMLPaths.GAMEDIR.get().resolve("patched_shaders");
            Files.write(debugOutDir.resolve(name + ".vsh"), vertex.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.write(debugOutDir.resolve(name + ".fsh"), fragment.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            if (geometry != null) {
                Files.write(debugOutDir.resolve(name + ".gsh"), geometry.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            Files.write(debugOutDir.resolve(name + ".json"), shaderJsonString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        return new ExtendedShader(shaderResourceFactory, name, vertexFormat, writingToBeforeTranslucent, writingToAfterTranslucent, baseline, blendModeOverride, alpha, uniforms -> {
            CommonUniforms.addCommonUniforms(uniforms, source.getParent().getPack().getIdMap(), source.getParent().getPackDirectives(), updateNotifier, fogMode);
            BuiltinReplacementUniforms.addBuiltinReplacementUniforms(uniforms);
        }, isFullbright, parent, inputs);
    }

    public static FallbackShader createFallback(String name, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, AlphaTest alpha, VertexFormat vertexFormat, BlendModeOverride blendModeOverride, NewWorldRenderingPipeline parent, FogMode fogMode, boolean entityLighting, boolean intensityTex, boolean isFullbright) throws IOException {
        ShaderAttributeInputs inputs = new ShaderAttributeInputs(vertexFormat, isFullbright);
        String vertex = ShaderSynthesizer.vsh(true, inputs, fogMode, entityLighting);
        String fragment = ShaderSynthesizer.fsh(inputs, fogMode, alpha, intensityTex);
        String shaderJsonString = "{\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"" + name + "\",\n    \"fragment\": \"" + name + "\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n        \"UV0\",\n        \"UV1\",\n        \"UV2\",\n        \"Normal\"\n    ],\n    \"samplers\": [\n        { \"name\": \"Sampler0\" },\n        { \"name\": \"Sampler1\" },\n        { \"name\": \"Sampler2\" }\n    ],\n    \"uniforms\": [\n        { \"name\": \"TextureMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ChunkOffset\", \"type\": \"float\", \"count\": 3, \"values\": [ 0.0, 0.0, 0.0 ] },\n        { \"name\": \"ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n        { \"name\": \"Light0_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n        { \"name\": \"Light1_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n        { \"name\": \"FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        { \"name\": \"FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"FogDensity\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"FogIsExp2\", \"type\": \"int\", \"count\": 1, \"values\": [ 0 ] },\n        { \"name\": \"AlphaTestValue\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        { \"name\": \"LineWidth\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"ScreenSize\", \"type\": \"float\", \"count\": 2, \"values\": [ 1.0, 1.0 ] },\n        { \"name\": \"FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] }\n    ]\n}";
        IrisProgramResourceFactory shaderResourceFactory = new IrisProgramResourceFactory(shaderJsonString, vertex, null, fragment);
        if (!FMLLoader.isProduction()) {
            Path debugOutDir = FMLPaths.GAMEDIR.get().resolve("patched_shaders");
            Files.write(debugOutDir.resolve(name + ".vsh"), vertex.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.write(debugOutDir.resolve(name + ".fsh"), fragment.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.write(debugOutDir.resolve(name + ".json"), shaderJsonString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        return new FallbackShader(shaderResourceFactory, name, vertexFormat, writingToBeforeTranslucent, writingToAfterTranslucent, blendModeOverride, alpha.getReference(), parent);
    }

    private static class IrisProgramResourceFactory
    implements ResourceProvider {
        private final String json;
        private final String vertex;
        private final String geometry;
        private final String fragment;

        public IrisProgramResourceFactory(String json, String vertex, String geometry, String fragment) {
            this.json = json;
            this.vertex = vertex;
            this.geometry = geometry;
            this.fragment = fragment;
        }

        public Resource m_142591_(ResourceLocation id) throws IOException {
            String path = id.m_135815_();
            if (path.endsWith("json")) {
                return new StringResource(id, this.json);
            }
            if (path.endsWith("vsh")) {
                return new StringResource(id, this.vertex);
            }
            if (path.endsWith("gsh")) {
                if (this.geometry == null) {
                    return null;
                }
                return new StringResource(id, this.geometry);
            }
            if (path.endsWith("fsh")) {
                return new StringResource(id, this.fragment);
            }
            throw new IOException("Couldn't load " + id);
        }
    }

    private static class StringResource
    implements Resource {
        private final ResourceLocation id;
        private final String content;

        private StringResource(ResourceLocation id, String content) {
            this.id = id;
            this.content = content;
        }

        public ResourceLocation m_7843_() {
            return this.id;
        }

        public InputStream m_6679_() {
            return new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8));
        }

        public boolean m_142564_() {
            return false;
        }

        @Nullable
        public <T> T m_5507_(MetadataSectionSerializer<T> metaReader) {
            return null;
        }

        public String m_7816_() {
            return "<iris shaderpack shaders>";
        }

        public void close() throws IOException {
        }
    }
}

