/*
 * Decompiled with CFR 0.152.
 */
package vice.rubidium_extras.features.TotalDarkness;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vice.rubidium_extras.config.MagnesiumExtrasConfig;

@Mod.EventBusSubscriber(modid="rubidium_extras", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class Darkness {
    public static boolean enabled = false;
    private static final float[][] LUMINANCE = new float[16][16];

    @SubscribeEvent
    public static void onConfigChange(ModConfigEvent e) {
        Darkness.bake();
    }

    public static void bake() {
        MagnesiumExtrasConfig.darkNetherFogEffective = (Boolean)MagnesiumExtrasConfig.darkNether.get() != false ? (Double)MagnesiumExtrasConfig.darkNetherFogConfigured.get() : 1.0;
        MagnesiumExtrasConfig.darkEndFogEffective = (Boolean)MagnesiumExtrasConfig.darkEnd.get() != false ? (Double)MagnesiumExtrasConfig.darkEndFogConfigured.get() : 1.0;
    }

    public static boolean blockLightOnly() {
        return (Boolean)MagnesiumExtrasConfig.blockLightOnly.get();
    }

    public static double darkNetherFog() {
        return MagnesiumExtrasConfig.darkNetherFogEffective;
    }

    public static double darkEndFog() {
        return MagnesiumExtrasConfig.darkEndFogEffective;
    }

    public static void getDarkenedFogColor(CallbackInfoReturnable<Vec3> ci, double factor) {
        if (factor != 1.0) {
            Vec3 result = (Vec3)ci.getReturnValue();
            double MIN = 0.03;
            result = new Vec3(Math.max(MIN, result.f_82479_ * factor), Math.max(MIN, result.f_82480_ * factor), Math.max(MIN, result.f_82481_ * factor));
            ci.setReturnValue((Object)result);
        }
    }

    private static boolean isDark(Level world) {
        if (!((Boolean)MagnesiumExtrasConfig.trueDarknessEnabled.get()).booleanValue()) {
            return false;
        }
        ResourceKey dimType = world.m_46472_();
        if (dimType == Level.f_46428_) {
            return (Boolean)MagnesiumExtrasConfig.darkOverworld.get();
        }
        if (dimType == Level.f_46429_) {
            return (Boolean)MagnesiumExtrasConfig.darkNether.get();
        }
        if (dimType == Level.f_46430_) {
            return (Boolean)MagnesiumExtrasConfig.darkEnd.get();
        }
        if (world.m_6042_().m_63935_()) {
            return (Boolean)MagnesiumExtrasConfig.darkDefault.get();
        }
        return (Boolean)MagnesiumExtrasConfig.darkSkyless.get();
    }

    private static float skyFactor(Level world) {
        if (!((Boolean)MagnesiumExtrasConfig.blockLightOnly.get()).booleanValue() && Darkness.isDark(world)) {
            if (world.m_6042_().m_63935_()) {
                float angle = world.m_46942_(0.0f);
                if (angle > 0.25f && angle < 0.75f) {
                    float oldWeight = Math.max(0.0f, Math.abs(angle - 0.5f) - 0.2f) * 20.0f;
                    float moon = (Boolean)MagnesiumExtrasConfig.ignoreMoonPhase.get() != false ? 0.0f : world.m_46940_();
                    float moonInterpolated = (float)Mth.m_14139_((double)moon, (double)((Double)MagnesiumExtrasConfig.minimumMoonLevel.get()), (double)((Double)MagnesiumExtrasConfig.maximumMoonLevel.get()));
                    return Mth.m_14179_((float)(oldWeight * oldWeight * oldWeight), (float)moonInterpolated, (float)1.0f);
                }
                return 1.0f;
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public static int darken(int c, int blockIndex, int skyIndex) {
        float lTarget = LUMINANCE[blockIndex][skyIndex];
        float r = (float)(c & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c >> 16 & 0xFF) / 255.0f;
        float l = Darkness.luminance(r, g, b);
        float f = l > 0.0f ? Math.min(1.0f, lTarget / l) : 0.0f;
        return f == 1.0f ? c : 0xFF000000 | Math.round(f * r * 255.0f) | Math.round(f * g * 255.0f) << 8 | Math.round(f * b * 255.0f) << 16;
    }

    public static float luminance(float r, float g, float b) {
        return r * 0.2126f + g * 0.7152f + b * 0.0722f;
    }

    public static void updateLuminance(float tickDelta, Minecraft client, GameRenderer worldRenderer, float prevFlicker) {
        ClientLevel world = client.f_91073_;
        if (world != null) {
            if (!Darkness.isDark((Level)world) || client.f_91074_.m_21023_(MobEffects.f_19611_) || client.f_91074_.m_21023_(MobEffects.f_19592_) && client.f_91074_.m_108639_() > 0.0f || world.m_104819_() > 0) {
                enabled = false;
                return;
            }
            enabled = true;
            float dimSkyFactor = Darkness.skyFactor((Level)world);
            float ambient = world.m_104805_(1.0f);
            DimensionType dim = world.m_6042_();
            boolean blockAmbient = !Darkness.isDark((Level)world);
            for (int skyIndex = 0; skyIndex < 16; ++skyIndex) {
                float v;
                float skyFactor = 1.0f - (float)skyIndex / 15.0f;
                skyFactor = 1.0f - skyFactor * skyFactor * skyFactor * skyFactor;
                float min = Math.max((skyFactor *= dimSkyFactor) * 0.05f, ((MagnesiumExtrasConfig.DarknessOption)((Object)MagnesiumExtrasConfig.darknessOption.get())).value);
                float rawAmbient = ambient * skyFactor;
                float minAmbient = rawAmbient * (1.0f - min) + min;
                float skyBase = dim.m_63902_(skyIndex) * minAmbient;
                min = Math.max(0.35f * skyFactor, ((MagnesiumExtrasConfig.DarknessOption)((Object)MagnesiumExtrasConfig.darknessOption.get())).value);
                float skyRed = v = skyBase * (rawAmbient * (1.0f - min) + min);
                float skyGreen = v;
                float skyBlue = skyBase;
                if (worldRenderer.m_109131_(tickDelta) > 0.0f) {
                    float skyDarkness = worldRenderer.m_109131_(tickDelta);
                    skyRed = skyRed * (1.0f - skyDarkness) + skyRed * 0.7f * skyDarkness;
                    skyGreen = skyGreen * (1.0f - skyDarkness) + skyGreen * 0.6f * skyDarkness;
                    skyBlue = skyBlue * (1.0f - skyDarkness) + skyBlue * 0.6f * skyDarkness;
                }
                for (int blockIndex = 0; blockIndex < 16; ++blockIndex) {
                    float blockFactor = 1.0f;
                    if (!blockAmbient) {
                        blockFactor = 1.0f - (float)blockIndex / 15.0f;
                        blockFactor = 1.0f - blockFactor * blockFactor * blockFactor * blockFactor;
                    }
                    float blockBase = blockFactor * dim.m_63902_(blockIndex) * (prevFlicker * 0.1f + 1.5f);
                    min = 0.4f * blockFactor;
                    float blockGreen = blockBase * ((blockBase * (1.0f - min) + min) * (1.0f - min) + min);
                    float blockBlue = blockBase * (blockBase * blockBase * (1.0f - min) + min);
                    float red = skyRed + blockBase;
                    float green = skyGreen + blockGreen;
                    float blue = skyBlue + blockBlue;
                    float f = Math.max(skyFactor, blockFactor);
                    min = 0.03f * f;
                    red = red * (0.99f - min) + min;
                    green = green * (0.99f - min) + min;
                    blue = blue * (0.99f - min) + min;
                    if (world.m_46472_() == Level.f_46430_) {
                        red = skyFactor * 0.22f + blockBase * 0.75f;
                        green = skyFactor * 0.28f + blockGreen * 0.75f;
                        blue = skyFactor * 0.25f + blockBlue * 0.75f;
                    }
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    float gamma = (float)client.f_91066_.f_92071_ * f;
                    float invRed = 1.0f - red;
                    float invGreen = 1.0f - green;
                    float invBlue = 1.0f - blue;
                    invRed = 1.0f - invRed * invRed * invRed * invRed;
                    invGreen = 1.0f - invGreen * invGreen * invGreen * invGreen;
                    invBlue = 1.0f - invBlue * invBlue * invBlue * invBlue;
                    red = red * (1.0f - gamma) + invRed * gamma;
                    green = green * (1.0f - gamma) + invGreen * gamma;
                    blue = blue * (1.0f - gamma) + invBlue * gamma;
                    min = Math.max(0.03f * f, ((MagnesiumExtrasConfig.DarknessOption)((Object)MagnesiumExtrasConfig.darknessOption.get())).value);
                    red = red * (0.99f - min) + min;
                    green = green * (0.99f - min) + min;
                    blue = blue * (0.99f - min) + min;
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    if (red < 0.0f) {
                        red = 0.0f;
                    }
                    if (green < 0.0f) {
                        green = 0.0f;
                    }
                    if (blue < 0.0f) {
                        blue = 0.0f;
                    }
                    Darkness.LUMINANCE[blockIndex][skyIndex] = Darkness.luminance(red, green, blue);
                }
            }
        }
    }
}

