/*
 * Decompiled with CFR 0.152.
 */
package vice.rubidium_extras.mixins.SodiumConfig;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import vice.rubidium_extras.config.MagnesiumExtrasConfig;
import vice.rubidium_extras.mixins.BorderlessFullscreen.MainWindowAccessor;

@Mixin(value={SodiumGameOptionPages.class})
public class SodiumGameOptionsMixin {
    @Shadow
    @Final
    private static SodiumOptionsStorage sodiumOpts;
    @Shadow
    @Final
    private static MinecraftOptionsStorage vanillaOpts;

    @Inject(method={"advanced"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;copyOf(Ljava/util/Collection;)Lcom/google/common/collect/ImmutableList;")}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false, cancellable=true)
    private static void Inject(CallbackInfoReturnable<OptionPage> cir, List<OptionGroup> groups) {
        OptionImpl displayFps = OptionImpl.createBuilder(MagnesiumExtrasConfig.Complexity.class, (OptionStorage)sodiumOpts).setName(Component.m_130674_((String)"Display FPS")).setTooltip(Component.m_130674_((String)"Displays the current FPS. Advanced mode also displays minimum FPS, as well as 15 second average FPS, which are more useful for judging performance.")).setControl(option -> new CyclingControl((Option)option, MagnesiumExtrasConfig.Complexity.class, new Component[]{Component.m_130674_((String)"Off"), Component.m_130674_((String)"Simple"), Component.m_130674_((String)"Advanced")})).setBinding((opts, value) -> MagnesiumExtrasConfig.fpsCounterMode.set((Object)value.toString()), opts -> MagnesiumExtrasConfig.Complexity.valueOf((String)MagnesiumExtrasConfig.fpsCounterMode.get())).setImpact(OptionImpact.LOW).build();
        OptionImpl displayFpsPos = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName(Component.m_130674_((String)"FPS Display Position")).setTooltip(Component.m_130674_((String)"Offsets the FPS display a few pixels")).setControl(option -> new SliderControl((Option)option, 4, 64, 2, ControlValueFormatter.translateVariable((String)"Pixels"))).setImpact(OptionImpact.LOW).setBinding((opts, value) -> MagnesiumExtrasConfig.fpsCounterPosition.set(value), opts -> (Integer)MagnesiumExtrasConfig.fpsCounterPosition.get()).build();
        groups.add(OptionGroup.createBuilder().add((Option)displayFps).add((Option)displayFpsPos).build());
        OptionImpl totalDarkness = OptionImpl.createBuilder(Boolean.class, (OptionStorage)sodiumOpts).setName(Component.m_130674_((String)"True Darkness")).setTooltip(Component.m_130674_((String)"Makes the rest of the world more realistically dark. Does not effect daytime or torch light.")).setControl(TickBoxControl::new).setBinding((options, value) -> MagnesiumExtrasConfig.trueDarknessEnabled.set(value), options -> (Boolean)MagnesiumExtrasConfig.trueDarknessEnabled.get()).setImpact(OptionImpact.LOW).build();
        OptionImpl totalDarknessSetting = OptionImpl.createBuilder(MagnesiumExtrasConfig.DarknessOption.class, (OptionStorage)sodiumOpts).setName(Component.m_130674_((String)"True Darkness Mode")).setTooltip(Component.m_130674_((String)"Controls how dark is considered true darkness.")).setControl(option -> new CyclingControl((Option)option, MagnesiumExtrasConfig.DarknessOption.class, new Component[]{Component.m_130674_((String)"Pitch Black"), Component.m_130674_((String)"Really Dark"), Component.m_130674_((String)"Dark"), Component.m_130674_((String)"Dim")})).setBinding((opts, value) -> MagnesiumExtrasConfig.darknessOption.set((Object)value), opts -> (MagnesiumExtrasConfig.DarknessOption)((Object)((Object)MagnesiumExtrasConfig.darknessOption.get()))).setImpact(OptionImpact.LOW).build();
        groups.add(OptionGroup.createBuilder().add((Option)totalDarkness).add((Option)totalDarknessSetting).build());
        OptionImpl fog = OptionImpl.createBuilder(Boolean.class, (OptionStorage)sodiumOpts).setName(Component.m_130674_((String)"Enable fog")).setTooltip(Component.m_130674_((String)"Toggles off all fog in the overworld.")).setControl(TickBoxControl::new).setBinding((options, value) -> MagnesiumExtrasConfig.fog.set(value), options -> (Boolean)MagnesiumExtrasConfig.fog.get()).setImpact(OptionImpact.LOW).build();
        OptionImpl hideJEI = OptionImpl.createBuilder(Boolean.class, (OptionStorage)sodiumOpts).setName(Component.m_130674_((String)"Hide JEI Until Searching")).setTooltip(Component.m_130674_((String)"Toggles off JEI items unless you search for something. Press space to search for everything.")).setControl(TickBoxControl::new).setBinding((options, value) -> MagnesiumExtrasConfig.hideJEI.set(value), options -> (Boolean)MagnesiumExtrasConfig.hideJEI.get()).setImpact(OptionImpact.LOW).build();
        OptionImpl cloudHeight = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName(Component.m_130674_((String)"Cloud Height")).setTooltip(Component.m_130674_((String)"Raises cloud height.")).setControl(option -> new SliderControl((Option)option, 64, 364, 4, ControlValueFormatter.translateVariable((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.cloudHeight.set(value), options -> (Integer)MagnesiumExtrasConfig.cloudHeight.get()).setImpact(OptionImpact.LOW).build();
        groups.add(OptionGroup.createBuilder().add((Option)fog).add((Option)cloudHeight).build());
        OptionImpl enableDistanceChecks = OptionImpl.createBuilder(Boolean.class, (OptionStorage)sodiumOpts).setName(Component.m_130674_((String)"Enable Max Entity Distance")).setTooltip(Component.m_130674_((String)"Toggles off entity culling.")).setControl(TickBoxControl::new).setBinding((options, value) -> MagnesiumExtrasConfig.enableDistanceChecks.set(value), options -> (Boolean)MagnesiumExtrasConfig.enableDistanceChecks.get()).setImpact(OptionImpact.LOW).build();
        groups.add(OptionGroup.createBuilder().add((Option)enableDistanceChecks).build());
        OptionImpl maxEntityDistance = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName(Component.m_130674_((String)"Max Entity Distance")).setTooltip(Component.m_130674_((String)"Hides and does not tick entities beyond this many blocks. Huge performance increase, especially around modded farms.")).setControl(option -> new SliderControl((Option)option, 16, 192, 8, ControlValueFormatter.translateVariable((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.maxEntityRenderDistanceSquare.set((Object)(value * value)), options -> Math.toIntExact(Math.round(Math.sqrt(((Integer)MagnesiumExtrasConfig.maxEntityRenderDistanceSquare.get()).intValue())))).setImpact(OptionImpact.HIGH).build();
        OptionImpl maxEntityDistanceVertical = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName(Component.m_130674_((String)"Vertical Entity Distance")).setTooltip(Component.m_130674_((String)"Hides and does not tick entities underneath this many blocks, improving performance above caves. This should ideally be set lower than the horizontal distance.")).setControl(option -> new SliderControl((Option)option, 16, 64, 4, ControlValueFormatter.translateVariable((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.maxEntityRenderDistanceY.set(value), options -> (Integer)MagnesiumExtrasConfig.maxEntityRenderDistanceY.get()).setImpact(OptionImpact.HIGH).build();
        groups.add(OptionGroup.createBuilder().add((Option)maxEntityDistance).add((Option)maxEntityDistanceVertical).build());
        OptionImpl maxTileEntityDistance = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName(Component.m_130674_((String)"Max Tile Distance")).setTooltip(Component.m_130674_((String)"Hides block entities beyond this many blocks. Huge performance increase, especially around lots of modded machines.")).setControl(option -> new SliderControl((Option)option, 16, 256, 8, ControlValueFormatter.translateVariable((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.maxTileEntityRenderDistanceSquare.set((Object)(value * value)), options -> Math.toIntExact(Math.round(Math.sqrt(((Integer)MagnesiumExtrasConfig.maxTileEntityRenderDistanceSquare.get()).intValue())))).setImpact(OptionImpact.HIGH).build();
        OptionImpl maxTileEntityDistanceVertical = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumOpts).setName(Component.m_130674_((String)"Vertical Tile Distance")).setTooltip(Component.m_130674_((String)"Hides block entities underneath this many blocks, improving performance above caves (if you have your machines in caves, for some reason). This should ideally be set lower than the horizontal distance.")).setControl(option -> new SliderControl((Option)option, 16, 64, 4, ControlValueFormatter.translateVariable((String)"Blocks"))).setBinding((options, value) -> MagnesiumExtrasConfig.maxTileEntityRenderDistanceY.set(value), options -> (Integer)MagnesiumExtrasConfig.maxTileEntityRenderDistanceY.get()).setImpact(OptionImpact.HIGH).build();
        groups.add(OptionGroup.createBuilder().add((Option)maxTileEntityDistance).add((Option)maxTileEntityDistanceVertical).build());
    }

    @Inject(method={"general"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;copyOf(Ljava/util/Collection;)Lcom/google/common/collect/ImmutableList;")}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false, cancellable=true)
    private static void InjectGeneral(CallbackInfoReturnable<OptionPage> cir, List<OptionGroup> groups) {
        OptionImpl fullscreenMode = OptionImpl.createBuilder(MagnesiumExtrasConfig.FullscreenMode.class, (OptionStorage)vanillaOpts).setName(Component.m_130674_((String)"Fullscreen Mode")).setTooltip(Component.m_130674_((String)"Windowed - the game will display in a small window.\nBorderless - the game will be fullscreened, and locked to your monitor's refresh rate, but allow you to tab out easily.\nFullscreen - the game will display in native fullscreen mode.")).setControl(opt -> new CyclingControl((Option)opt, MagnesiumExtrasConfig.FullscreenMode.class, new Component[]{Component.m_130674_((String)"Windowed"), Component.m_130674_((String)"Borderless"), Component.m_130674_((String)"Fullscreen")})).setBinding((opts, value) -> {
            MagnesiumExtrasConfig.fullScreenMode.set((Object)value);
            opts.f_92052_ = value != MagnesiumExtrasConfig.FullscreenMode.WINDOWED;
            Minecraft client = Minecraft.m_91087_();
            Window window = client.m_91268_();
            if (window != null && window.m_85440_() != opts.f_92052_) {
                window.m_85438_();
                opts.f_92052_ = window.m_85440_();
            }
            if (window != null && opts.f_92052_) {
                ((MainWindowAccessor)window).setDirty(true);
                window.m_85437_();
            }
        }, opts -> (MagnesiumExtrasConfig.FullscreenMode)((Object)((Object)MagnesiumExtrasConfig.fullScreenMode.get()))).build();
        SodiumGameOptionsMixin.ReplaceOption(groups, "Fullscreen", fullscreenMode);
    }

    private static void ReplaceOption(List<OptionGroup> groups, String name, Option<?> replaceOption) {
        ArrayList<OptionGroup> newList = new ArrayList<OptionGroup>();
        for (OptionGroup optionGroup : groups) {
            OptionGroup.Builder builder = OptionGroup.createBuilder();
            for (Option option : optionGroup.getOptions()) {
                builder.add(Objects.equals(option.getName().getString(), name) ? replaceOption : option);
            }
            newList.add(builder.build());
        }
        groups.clear();
        groups.addAll(newList);
    }

    @ModifyConstant(method={"advanced"}, remap=false, constant={@Constant(stringValue="sodium.options.pages.advanced")})
    private static String ChangeCategoryName(String old) {
        return "Extras";
    }
}

