/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import me.hypherionmc.shaded.moonconfig.core.file.FileWatcher;
import me.hypherionmc.simplerpc.SimpleRPCClient;
import me.hypherionmc.simplerpclib.RPCConstants;
import me.hypherionmc.simplerpclib.configuration.ConfigEngine;
import me.hypherionmc.simplerpclib.configuration.ServerConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class SimpleRPCServer {
    public static ServerConfig serverConfig;
    private static FileWatcher serverConfigWatcher;
    private static MinecraftServer server;

    public static void init() {
        serverConfig = ConfigEngine.loadServerConfig(".");
        try {
            serverConfigWatcher.addWatch(new File("./config/simple-rpc-server.toml"), () -> {
                serverConfig = ConfigEngine.loadServerConfig(".");
                if (server != null) {
                    SimpleRPCClient.sidedHandler.sendClientPacket(server, serverConfig);
                }
            });
        }
        catch (Exception e) {
            RPCConstants.logger.error("Failed to register server config for auto reloading", (Throwable)e);
        }
    }

    public static void playerJoinServer(ServerPlayer player) {
        if (serverConfig != null) {
            SimpleRPCClient.sidedHandler.sendToPlayer(server, player, serverConfig);
        }
    }

    public static void serverTick(MinecraftServer mcServer) {
        server = mcServer;
    }

    public static FriendlyByteBuf serializeConfig(FriendlyByteBuf buf, ServerConfig config) {
        try {
            buf.writeBoolean(config.enabled);
            buf.writeBoolean(config.multi_player.enabled);
            buf.m_130070_(config.multi_player.description);
            buf.m_130070_(config.multi_player.state);
            buf.m_130070_(config.multi_player.largeImageKey);
            buf.m_130070_(config.multi_player.largeImageText);
            buf.m_130070_(config.multi_player.smallImageKey);
            buf.m_130070_(config.multi_player.smallImageText);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(config.multi_player.buttonsList);
            oos.flush();
            buf.m_130087_(bos.toByteArray());
            ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
            ObjectOutputStream oos2 = new ObjectOutputStream(bos2);
            oos2.writeObject(config.dimension_overrides);
            oos2.flush();
            buf.m_130087_(bos2.toByteArray());
            return buf;
        }
        catch (Exception exception) {
            return buf;
        }
    }

    static {
        serverConfigWatcher = new FileWatcher();
    }
}

