/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.network;

import java.util.function.Supplier;
import me.hypherionmc.simplerpc.SimpleRPCClient;
import me.hypherionmc.simplerpc.SimpleRPCServer;
import me.hypherionmc.simplerpclib.configuration.ServerConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ConfigPacket {
    private ServerConfig serverConfig;

    public ConfigPacket(FriendlyByteBuf buffer) {
        try {
            this.serverConfig = SimpleRPCClient.receiveClientPacket(buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ConfigPacket(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        SimpleRPCServer.serializeConfig(buffer, this.serverConfig);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (this.serverConfig != null) {
                SimpleRPCClient.setServerConfig(this.serverConfig);
            }
        });
        return true;
    }
}

