/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.discord;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.hypherionmc.shaded.moonconfig.core.file.FileWatcher;
import me.hypherionmc.simplerpclib.RPCConstants;
import me.hypherionmc.simplerpclib.configuration.ClientConfig;
import me.hypherionmc.simplerpclib.configuration.ConfigEngine;
import me.hypherionmc.simplerpclib.configuration.ServerConfig;
import me.hypherionmc.simplerpclib.configuration.ServerEntriesConfig;
import me.hypherionmc.simplerpclib.discord.DiscordController;
import me.hypherionmc.simplerpclib.discord.RichPresenceEvents;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherAssets;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherUtils;
import me.hypherionmc.simplerpclib.util.MinecraftUtilHandler;

public class RichPresenceCore {
    public static final ScheduledExecutorService taskManager = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private final MinecraftUtilHandler utilHandler;
    private DiscordController discordController;
    private RichPresenceEvents events;
    private LauncherUtils.LauncherType launcherType;
    private LauncherAssets launcherAssets;
    private final String configPath;
    private final String langCode;
    private long lastDiscordID = 0L;
    private ClientConfig clientConfig;
    private ServerEntriesConfig serverEntriesConfig;
    private static ServerConfig serverConfig;

    public RichPresenceCore(MinecraftUtilHandler minecraftUtilHandler, String configPath, String langCode) {
        this.utilHandler = minecraftUtilHandler;
        this.configPath = configPath;
        this.langCode = langCode;
        this.clientConfig = ConfigEngine.loadConfig(this);
        this.serverEntriesConfig = ConfigEngine.loadServerEntries(this);
        if (this.clientConfig != null) {
            this.discordController = new DiscordController(this.clientConfig);
            this.events = new RichPresenceEvents(this);
            this.lastDiscordID = this.clientConfig.general.discordid;
            this.launcherType = LauncherUtils.getLauncherType(this);
            this.launcherAssets = LauncherUtils.getLauncherInfo(this.launcherType);
            try {
                FileWatcher configWatcher = new FileWatcher();
                configWatcher.addWatch(new File(this.clientConfig.configPath), () -> {
                    this.clientConfig = ConfigEngine.loadConfig(this);
                    if (this.lastDiscordID != this.clientConfig.general.discordid) {
                        this.discordController.shutdownRichPresence();
                        this.discordController = new DiscordController(this.clientConfig);
                        this.lastDiscordID = this.clientConfig.general.discordid;
                        this.events.updateRPC();
                    }
                });
                FileWatcher entriesWatcher = new FileWatcher();
                entriesWatcher.addWatch(new File(this.serverEntriesConfig.configPath), () -> {
                    this.serverEntriesConfig = ConfigEngine.loadServerEntries(this);
                    this.getEvents().updateRPC();
                });
            }
            catch (Exception e) {
                RPCConstants.logger.error("Failed to register config watchers", (Throwable)e);
            }
            taskManager.scheduleAtFixedRate(() -> {
                if (this.events != null) {
                    this.events.updateRPC();
                }
            }, 1L, 2L, TimeUnit.SECONDS);
        }
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public RichPresenceEvents getEvents() {
        return this.events;
    }

    public DiscordController getDiscordHandler() {
        return this.discordController;
    }

    public MinecraftUtilHandler getUtilHandler() {
        return this.utilHandler;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getLangCode() {
        return this.langCode;
    }

    public LauncherUtils.LauncherType getLauncherType() {
        return this.launcherType;
    }

    public LauncherAssets getLauncherAssets() {
        return this.launcherAssets;
    }

    public ServerEntriesConfig getServerEntriesConfig() {
        return this.serverEntriesConfig;
    }

    public ServerConfig getServerConfig() {
        return serverConfig;
    }

    public static void setServerConfig(ServerConfig serverConfig) {
        RichPresenceCore.serverConfig = serverConfig;
    }
}

