/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.montoyo.wd.SharedProxy;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.config.ModConfig;
import net.montoyo.wd.core.CraftComponent;
import net.montoyo.wd.core.Criterion;
import net.montoyo.wd.core.HasAdvancement;
import net.montoyo.wd.core.IWDDCapability;
import net.montoyo.wd.core.WDCreativeTab;
import net.montoyo.wd.core.WDDCapability;
import net.montoyo.wd.init.BlockInit;
import net.montoyo.wd.init.ItemInit;
import net.montoyo.wd.init.TileInit;
import net.montoyo.wd.miniserv.server.Server;
import net.montoyo.wd.net.Messages;
import net.montoyo.wd.net.client.CMessageServerInfo;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Util;

@Mod(value="webdisplays")
public class WebDisplays {
    public static final String MOD_VERSION = "1.1";
    public static WebDisplays INSTANCE;
    public static SharedProxy PROXY;
    public static WDCreativeTab CREATIVE_TAB;
    public static final ResourceLocation ADV_PAD_BREAK;
    public static final String BLACKLIST_URL = "mod://webdisplays/blacklisted.html";
    public static final Gson GSON;
    public static final ResourceLocation CAPABILITY;
    public SoundEvent soundTyping;
    public SoundEvent soundUpgradeAdd;
    public SoundEvent soundUpgradeDel;
    public SoundEvent soundScreenCfg;
    public SoundEvent soundServer;
    public SoundEvent soundIronic;
    public Criterion criterionPadBreak;
    public Criterion criterionUpgradeScreen;
    public Criterion criterionLinkPeripheral;
    public Criterion criterionKeyboardCat;
    public static final double PAD_RATIO = 1.9666666666666666;
    public String homePage;
    public double padResX;
    public double padResY;
    private int lastPadId = 0;
    public boolean doHardRecipe;
    private boolean hasOC;
    private boolean hasCC;
    private List<String> blacklist;
    public boolean disableOwnershipThief;
    public double unloadDistance2;
    public double loadDistance2;
    public int maxResX;
    public int maxResY;
    public int maxScreenX;
    public int maxScreenY;
    public int miniservPort;
    public long miniservQuota;
    public boolean enableSoundDistance;
    public float ytVolume;
    public float avDist100;
    public float avDist0;

    public WebDisplays() {
        INSTANCE = this;
        AutoConfig.register(ModConfig.class, Toml4jConfigSerializer::new);
        ConfigHolder configHolder = AutoConfig.getConfigHolder(ModConfig.class);
        ModConfig config = (ModConfig)configHolder.getConfig();
        configHolder.save();
        this.blacklist = config.main.blacklist;
        this.doHardRecipe = config.main.hardRecipes;
        this.homePage = config.main.homepage;
        this.disableOwnershipThief = config.main.disableOwnershipThief;
        this.unloadDistance2 = config.client.unloadDistance * config.client.unloadDistance;
        this.loadDistance2 = config.client.loadDistance * config.client.loadDistance;
        this.maxResX = config.main.maxResolutionX;
        this.maxResY = config.main.maxResolutionY;
        this.miniservPort = config.main.miniservPort;
        this.miniservQuota = config.main.miniservQuota * 1024L;
        this.maxScreenX = config.main.maxScreenSizeX;
        this.maxScreenY = config.main.maxScreenSizeY;
        this.enableSoundDistance = config.client.autoVolumeControl.enableAutoVolume;
        this.ytVolume = (float)config.client.autoVolumeControl.ytVolume;
        this.avDist100 = (float)config.client.autoVolumeControl.dist100;
        this.avDist0 = (float)config.client.autoVolumeControl.dist0;
        CREATIVE_TAB = new WDCreativeTab();
        this.criterionPadBreak = new Criterion("pad_break");
        this.criterionUpgradeScreen = new Criterion("upgrade_screen");
        this.criterionLinkPeripheral = new Criterion("link_peripheral");
        this.criterionKeyboardCat = new Criterion("keyboard_cat");
        WebDisplays.registerTrigger(this.criterionPadBreak, this.criterionUpgradeScreen, this.criterionLinkPeripheral, this.criterionKeyboardCat);
        this.padResY = config.main.padHeight;
        this.padResX = this.padResY * 1.9666666666666666;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(Messages::registryNetworkPackets);
        BlockInit.init(bus);
        ItemInit.init(bus);
        ItemInit.registerUpgrade();
        ItemInit.registerComponents();
        TileInit.init(bus);
        PROXY.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        PROXY.init();
        PROXY.postInit();
        this.hasOC = ModList.get().isLoaded("opencomputers");
        this.hasCC = ModList.get().isLoaded("computercraft");
    }

    @SubscribeEvent
    public static void onAttachPlayerCap(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(WDDCapability.Provider.cap).isPresent()) {
            event.addCapability(new ResourceLocation("webdisplays", "wddcapability"), (ICapabilityProvider)new WDDCapability.Provider());
        }
    }

    @SubscribeEvent
    public void onRegisterSounds(RegistryEvent.Register<SoundEvent> ev) {
        this.soundTyping = WebDisplays.registerSound(ev, "keyboardType");
        this.soundUpgradeAdd = WebDisplays.registerSound(ev, "upgradeAdd");
        this.soundUpgradeDel = WebDisplays.registerSound(ev, "upgradeDel");
        this.soundScreenCfg = WebDisplays.registerSound(ev, "screencfgOpen");
        this.soundServer = WebDisplays.registerSound(ev, "server");
        this.soundIronic = WebDisplays.registerSound(ev, "ironic");
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load ev) {
        LevelAccessor levelAccessor = ev.getWorld();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (ev.getWorld().m_5776_() || level.m_46472_() != Level.f_46428_) {
                return;
            }
            File worldDir = Objects.requireNonNull(ev.getWorld().m_142572_()).m_6237_();
            File f = new File(worldDir, "wd_next.txt");
            if (f.exists()) {
                try {
                    BufferedReader br = new BufferedReader(new FileReader(f));
                    String idx = br.readLine();
                    Util.silentClose(br);
                    if (idx == null) {
                        throw new RuntimeException("Seems like the file is empty (1)");
                    }
                    if ((idx = idx.trim()).isEmpty()) {
                        throw new RuntimeException("Seems like the file is empty (2)");
                    }
                    this.lastPadId = Integer.parseInt(idx);
                }
                catch (Throwable t) {
                    Log.warningEx("Could not read last minePad ID from %s. I'm afraid this might break all minePads.", t, f.getAbsolutePath());
                }
            }
            if (this.miniservPort != 0) {
                Server sv = Server.getInstance();
                sv.setPort(this.miniservPort);
                sv.setDirectory(new File(worldDir, "wd_filehost"));
                sv.start();
            }
        }
    }

    @SubscribeEvent
    public void onWorldLeave(WorldEvent.Unload ev) throws IOException {
        LevelAccessor levelAccessor = ev.getWorld();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (ev.getWorld().m_5776_() || level.m_46472_() != Level.f_46428_) {
                return;
            }
            Server sw = Server.getInstance();
            sw.stopServer();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save ev) {
        LevelAccessor levelAccessor = ev.getWorld();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (ev.getWorld().m_5776_() || level.m_46472_() != Level.f_46428_) {
                return;
            }
            File f = new File(Objects.requireNonNull(ev.getWorld().m_142572_()).m_6237_(), "wd_next.txt");
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                bw.write(this.lastPadId + "\n");
                Util.silentClose(bw);
            }
            catch (Throwable t) {
                Log.warningEx("Could not save last minePad ID (%d) to %s. I'm afraid this might break all minePads.", t, this.lastPadId, f.getAbsolutePath());
            }
        }
    }

    @SubscribeEvent
    public void onToss(ItemTossEvent ev) {
        ItemStack is;
        if (!ev.getEntityItem().m_183503_().f_46443_ && (is = ev.getEntityItem().m_32055_()).m_41720_() == ItemInit.itemMinePad.get()) {
            CompoundTag tag = is.m_41783_();
            if (tag == null) {
                tag = new CompoundTag();
                is.m_41751_(tag);
            }
            UUID thrower = ev.getPlayer().m_36316_().getId();
            tag.m_128356_("ThrowerMSB", thrower.getMostSignificantBits());
            tag.m_128356_("ThrowerLSB", thrower.getLeastSignificantBits());
            tag.m_128347_("ThrowHeight", ev.getPlayer().m_20186_() + (double)ev.getPlayer().m_20192_());
        }
    }

    @SubscribeEvent
    public void onPlayerCraft(PlayerEvent.ItemCraftedEvent ev) {
        if (this.doHardRecipe && ev.getCrafting().m_41720_() == ItemInit.itemCraftComp.get() && CraftComponent.EXTENSION_CARD.makeItemStack().m_150930_(ev.getCrafting().m_41720_()) && (ev.getPlayer() instanceof ServerPlayer && !this.hasPlayerAdvancement((ServerPlayer)ev.getPlayer(), ADV_PAD_BREAK) || PROXY.hasClientPlayerAdvancement(ADV_PAD_BREAK) != HasAdvancement.YES)) {
            ev.getCrafting().m_41721_(CraftComponent.BAD_EXTENSION_CARD.ordinal());
            if (!ev.getPlayer().m_183503_().f_46443_) {
                ev.getPlayer().m_183503_().m_6263_(null, ev.getPlayer().m_20185_(), ev.getPlayer().m_20186_(), ev.getPlayer().m_20189_(), SoundEvents.f_12018_, SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppingEvent ev) throws IOException {
        Server.getInstance().stopServer();
    }

    @SubscribeEvent
    public void onLogIn(PlayerEvent.PlayerLoggedInEvent ev) {
        if (!ev.getPlayer().m_183503_().f_46443_ && ev.getPlayer() instanceof ServerPlayer) {
            IWDDCapability cap = (IWDDCapability)ev.getPlayer().getCapability(WDDCapability.Provider.cap, null).orElseThrow(RuntimeException::new);
            if (cap == null) {
                Log.warning("Player %s (%s) has null IWDDCapability!", ev.getPlayer().m_7755_(), ev.getPlayer().m_36316_().getId().toString());
            } else if (cap.isFirstRun()) {
                Util.toast(ev.getPlayer(), ChatFormatting.LIGHT_PURPLE, "welcome1", new Object[0]);
                Util.toast(ev.getPlayer(), ChatFormatting.LIGHT_PURPLE, "welcome2", new Object[0]);
                Util.toast(ev.getPlayer(), ChatFormatting.LIGHT_PURPLE, "welcome3", new Object[0]);
                cap.clearFirstRun();
            }
            PacketDistributor.PacketTarget packetDistrutor = PacketDistributor.PLAYER.with(() -> (ServerPlayer)ev.getPlayer());
            CMessageServerInfo message = new CMessageServerInfo(this.miniservPort);
            Messages.INSTANCE.send(packetDistrutor, (Object)message);
        }
    }

    @SubscribeEvent
    public void onLogOut(PlayerEvent.PlayerLoggedOutEvent ev) {
        if (!ev.getPlayer().m_183503_().f_46443_) {
            Server.getInstance().getClientManager().revokeClientKey(ev.getPlayer().m_36316_().getId());
        }
    }

    @SubscribeEvent
    public void attachEntityCaps(AttachCapabilitiesEvent<Entity> ev) {
        if (ev.getObject() instanceof Player) {
            ev.addCapability(CAPABILITY, (ICapabilityProvider)new WDDCapability.Provider());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone ev) {
        IWDDCapability src = (IWDDCapability)ev.getOriginal().getCapability(WDDCapability.Provider.cap, null).orElse((Object)new WDDCapability.Factory().call());
        IWDDCapability dst = (IWDDCapability)ev.getPlayer().getCapability(WDDCapability.Provider.cap, null).orElse((Object)new WDDCapability.Factory().call());
        if (src == null) {
            Log.error("src is null", new Object[0]);
            return;
        }
        if (dst == null) {
            Log.error("dst is null", new Object[0]);
            return;
        }
        src.cloneTo(dst);
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent ev) {
        String msg = ev.getMessage().trim().replaceAll("\\s+", " ").toLowerCase();
        StringBuilder sb = new StringBuilder(msg.length());
        for (int i = 0; i < msg.length(); ++i) {
            char chr = msg.charAt(i);
            if (chr == '.' || chr == ',' || chr == ';' || chr == '!' || chr == '?' || chr == ':' || chr == '\'' || chr == '\"' || chr == '`') continue;
            sb.append(chr);
        }
        if (sb.toString().equals("ironic he could save others from death but not himself")) {
            ServerPlayer ply = ev.getPlayer();
            ply.m_183503_().m_6263_(null, ply.m_20185_(), ply.m_20186_(), ply.m_20189_(), this.soundIronic, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void onClientChat(ClientChatEvent ev) {
        if (ev.getMessage().equals("!WD render recipes")) {
            PROXY.renderRecipes();
        }
    }

    private boolean hasPlayerAdvancement(ServerPlayer ply, ResourceLocation rl) {
        MinecraftServer server = PROXY.getServer();
        if (server == null) {
            return false;
        }
        Advancement adv = server.m_129889_().m_136041_(rl);
        return adv != null && ply.m_8960_().m_135996_(adv).m_8193_();
    }

    public static int getNextAvailablePadID() {
        return new WebDisplays().lastPadId++;
    }

    private static SoundEvent registerSound(RegistryEvent.Register<SoundEvent> ev, String resName) {
        ResourceLocation resLoc = new ResourceLocation("webdisplays", resName);
        SoundEvent ret = new SoundEvent(resLoc);
        ret.setRegistryName(resLoc);
        ev.getRegistry().register((IForgeRegistryEntry)ret);
        return ret;
    }

    private static void registerTrigger(Criterion ... criteria) {
        for (Criterion c : criteria) {
            CriteriaTriggers.m_10595_((CriterionTrigger)c);
        }
    }

    public static boolean isSiteBlacklisted(String url) {
        try {
            URL url2 = new URL(Util.addProtocol(url));
            return new ModConfig.Main().blacklist.stream().anyMatch(str -> str.equalsIgnoreCase(url2.getHost()));
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static String applyBlacklist(String url) {
        return WebDisplays.isSiteBlacklisted(url) ? BLACKLIST_URL : url;
    }

    static {
        PROXY = (SharedProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> SharedProxy::new);
        ADV_PAD_BREAK = new ResourceLocation("webdisplays", "webdisplays/pad_break");
        GSON = new Gson();
        CAPABILITY = new ResourceLocation("webdisplays", "customdatacap");
    }
}

