/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.PacketDistributor;
import net.montoyo.wd.block.BlockPeripheral;
import net.montoyo.wd.block.WDBlockContainer;
import net.montoyo.wd.core.DefaultPeripheral;
import net.montoyo.wd.entity.TileEntityInterfaceBase;
import net.montoyo.wd.entity.TileEntityKeyboard;
import net.montoyo.wd.entity.TileEntityPeripheralBase;
import net.montoyo.wd.entity.TileEntityServer;
import net.montoyo.wd.item.ItemLinker;
import net.montoyo.wd.net.Messages;
import net.montoyo.wd.net.client.CMessageCloseGui;
import org.jetbrains.annotations.Nullable;

public class BlockServer
extends WDBlockContainer {
    public static final EnumProperty<DefaultPeripheral> type = BlockPeripheral.type;
    public static final DirectionProperty facing = DirectionProperty.m_61549_((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
    private static final Property<?>[] properties = new Property[]{type, facing};

    public BlockServer() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 10.0f));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(properties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityServer(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_()) {
            return InteractionResult.FAIL;
        }
        if (player.m_21120_(hand).m_41720_() instanceof ItemLinker) {
            return InteractionResult.FAIL;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityServer) {
            ((TileEntityServer)te).onPlayerRightClick(player);
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        if (placer instanceof Player) {
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof TileEntityServer) {
                ((TileEntityServer)te).setOwner((Player)placer);
            } else if (te instanceof TileEntityInterfaceBase) {
                ((TileEntityInterfaceBase)te).setOwner((Player)placer);
            }
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.IGNORE;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborType, BlockPos neighbor, boolean isMoving) {
        BlockEntity te = world.m_7702_(pos);
        if (te != null && te instanceof TileEntityPeripheralBase) {
            ((TileEntityPeripheralBase)te).onNeighborChange(neighborType, neighbor);
        }
        if (world.f_46443_) {
            return;
        }
        if (neighbor.m_123341_() == pos.m_123341_() && neighbor.m_123342_() == pos.m_123342_() - 1 && neighbor.m_123343_() == pos.m_123343_() && world.m_46859_(neighbor)) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockServer.point(world, pos)), (Object)new CMessageCloseGui(pos));
        }
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        if (!world.f_46443_) {
            Messages.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockServer.point(world, pos)), (Object)new CMessageCloseGui(pos));
        }
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        this.m_6240_(level, null, pos, level.m_8055_(pos), null, null);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockEntity te;
        double rpos;
        if (!world.f_46443_ && (rpos = (entity.m_20186_() - (double)pos.m_123342_()) * 16.0) >= 1.0 && rpos <= 2.0 && Math.random() < 0.25 && (te = world.m_7702_(pos)) != null && te instanceof TileEntityKeyboard) {
            ((TileEntityKeyboard)te).simulateCat(entity);
        }
    }

    public static PacketDistributor.TargetPoint point(Level world, BlockPos bp) {
        return new PacketDistributor.TargetPoint((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_(), 64.0, world.m_46472_());
    }
}

