/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.InputConstants;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.montoyo.mcef.api.API;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.IDisplayHandler;
import net.montoyo.mcef.api.IJSQueryCallback;
import net.montoyo.mcef.api.IJSQueryHandler;
import net.montoyo.mcef.api.MCEFApi;
import net.montoyo.wd.SharedProxy;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.client.JSQueryDispatcher;
import net.montoyo.wd.client.ResourceModelPair;
import net.montoyo.wd.client.WDScheme;
import net.montoyo.wd.client.gui.GuiMinePad;
import net.montoyo.wd.client.gui.GuiScreenConfig;
import net.montoyo.wd.client.gui.GuiSetURL2;
import net.montoyo.wd.client.gui.RenderRecipe;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.client.gui.loading.GuiLoader;
import net.montoyo.wd.client.renderers.IItemRenderer;
import net.montoyo.wd.client.renderers.LaserPointerRenderer;
import net.montoyo.wd.client.renderers.MinePadRenderer;
import net.montoyo.wd.client.renderers.ScreenModelLoader;
import net.montoyo.wd.client.renderers.ScreenRenderer;
import net.montoyo.wd.core.DefaultUpgrade;
import net.montoyo.wd.core.HasAdvancement;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.data.GuiData;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.init.BlockInit;
import net.montoyo.wd.init.ItemInit;
import net.montoyo.wd.init.TileInit;
import net.montoyo.wd.item.WDItem;
import net.montoyo.wd.miniserv.client.Client;
import net.montoyo.wd.net.Messages;
import net.montoyo.wd.net.server.SMessagePadCtrl;
import net.montoyo.wd.net.server.SMessageScreenCtrl;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Multiblock;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;

@Mod.EventBusSubscriber(modid="webdisplays", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy
extends SharedProxy
implements IDisplayHandler,
IJSQueryHandler,
ResourceManagerReloadListener {
    private Minecraft mc;
    private final ArrayList<ResourceModelPair> modelBakers = new ArrayList();
    private API mcef;
    private MinePadRenderer minePadRenderer;
    private JSQueryDispatcher jsDispatcher;
    private LaserPointerRenderer laserPointerRenderer;
    private Screen nextScreen;
    private boolean isF1Down;
    private int miniservPort;
    private boolean msClientStarted;
    private final Field advancementToProgressField = ClientProxy.findAdvancementToProgressField();
    private ClientAdvancements lastAdvMgr;
    private Map advancementToProgress;
    private TileEntityScreen pointedScreen;
    private BlockSide pointedScreenSide;
    private long lastPointPacket;
    private final ArrayList<TileEntityScreen> screenTracking = new ArrayList();
    private int lastTracked = 0;
    private final HashMap<Integer, PadData> padMap = new HashMap();
    private final ArrayList<PadData> padList = new ArrayList();
    private int minePadTickCounter = 0;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TileInit.SCREEN_BLOCK_ENTITY.get()), (BlockEntityRendererProvider)new ScreenRenderer.ScreenRendererProvider());
    }

    @SubscribeEvent
    public static void onModelRegistryEvent(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)ScreenModelLoader.SCREEN_LOADER, (IModelLoader)new ScreenModelLoader());
        ClientProxy.registerBlockRenderLayers(RenderType.m_110463_(), (Block)BlockInit.blockKeyBoard.get(), (Block)BlockInit.blockKbRight.get());
    }

    private static void registerBlockRenderLayers(RenderType layer, Block ... blocks) {
        Stream.of(blocks).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)layer));
    }

    @Override
    public void preInit() {
        this.mc = Minecraft.m_91087_();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.mcef = MCEFApi.getAPI();
        if (this.mcef != null) {
            this.mcef.registerScheme("wd", WDScheme.class, true, false, false, true, true, false, false);
        }
    }

    @Override
    public void init() {
        this.jsDispatcher = new JSQueryDispatcher(this);
        this.minePadRenderer = new MinePadRenderer();
        this.laserPointerRenderer = new LaserPointerRenderer();
        if (this.mcef == null) {
            throw new RuntimeException("MCEF is missing");
        }
        this.mcef.registerDisplayHandler((IDisplayHandler)this);
        ClientProxy.findAdvancementToProgressField();
    }

    @Override
    public void postInit() {
        ((ReloadableResourceManager)this.mc.m_91098_()).m_7217_((PreparableReloadListener)this);
    }

    @Override
    public Level getWorld(ResourceKey<Level> dim) {
        ClientLevel ret = this.mc.f_91073_;
        if (ret != null) {
            if (!ret.m_46472_().equals(dim)) {
                throw new RuntimeException("Can't get non-current dimension " + dim + " from client.");
            }
            return ret;
        }
        throw new RuntimeException("Level on client is null");
    }

    @Override
    public void enqueue(Runnable r) {
        this.mc.m_18707_(r);
    }

    @Override
    public void displayGui(GuiData data) {
        Screen gui = data.createGui(this.mc.f_91080_, (Level)this.mc.f_91073_);
        if (gui != null) {
            this.mc.m_91152_(gui);
        }
    }

    @Override
    public void trackScreen(TileEntityScreen tes, boolean track) {
        int idx = -1;
        for (int i = 0; i < this.screenTracking.size(); ++i) {
            if (this.screenTracking.get(i) != tes) continue;
            idx = i;
            break;
        }
        if (track) {
            if (idx < 0) {
                this.screenTracking.add(tes);
            }
        } else if (idx >= 0) {
            this.screenTracking.remove(idx);
        }
    }

    @Override
    public void onAutocompleteResult(NameUUIDPair[] pairs) {
        Screen screen;
        if (this.mc.f_91080_ != null && (screen = this.mc.f_91080_) instanceof WDScreen) {
            WDScreen screen2 = (WDScreen)screen;
            if (pairs.length == 0) {
                screen2.onAutocompleteFailure();
            } else {
                screen2.onAutocompleteResult(pairs);
            }
        }
    }

    @Override
    public GameProfile[] getOnlineGameProfiles() {
        return new GameProfile[]{this.mc.f_91074_.m_36316_()};
    }

    @Override
    public void screenUpdateResolutionInGui(Vector3i pos, BlockSide side, Vector2i res) {
        GuiScreenConfig gsc;
        Screen screen;
        if (this.mc.f_91080_ != null && (screen = this.mc.f_91080_) instanceof GuiScreenConfig && (gsc = (GuiScreenConfig)screen).isForBlock(pos.toBlock(), side)) {
            gsc.updateResolution(res);
        }
    }

    @Override
    public void screenUpdateRotationInGui(Vector3i pos, BlockSide side, Rotation rot) {
        GuiScreenConfig gsc;
        Screen screen;
        if (this.mc.f_91080_ != null && (screen = this.mc.f_91080_) instanceof GuiScreenConfig && (gsc = (GuiScreenConfig)screen).isForBlock(pos.toBlock(), side)) {
            gsc.updateRotation(rot);
        }
    }

    @Override
    public void screenUpdateAutoVolumeInGui(Vector3i pos, BlockSide side, boolean av) {
        GuiScreenConfig gsc;
        Screen screen;
        if (this.mc.f_91080_ != null && (screen = this.mc.f_91080_) instanceof GuiScreenConfig && (gsc = (GuiScreenConfig)screen).isForBlock(pos.toBlock(), side)) {
            gsc.updateAutoVolume(av);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displaySetPadURLGui(String padURL) {
        this.mc.m_91152_((Screen)new GuiSetURL2(padURL));
    }

    @Override
    public void openMinePadGui(int padId) {
        PadData pd = this.padMap.get(padId);
        if (pd != null && pd.view != null) {
            this.mc.m_91152_((Screen)new GuiMinePad(pd));
        }
    }

    @Override
    @Nonnull
    public HasAdvancement hasClientPlayerAdvancement(@Nonnull ResourceLocation rl) {
        if (this.advancementToProgressField != null && this.mc.f_91074_ != null && this.mc.f_91074_.f_108617_ != null) {
            ClientAdvancements cam = this.mc.f_91074_.f_108617_.m_105145_();
            Advancement adv = cam.m_104396_().m_139337_(rl);
            if (adv == null) {
                return HasAdvancement.DONT_KNOW;
            }
            if (this.lastAdvMgr != cam) {
                this.lastAdvMgr = cam;
                try {
                    this.advancementToProgress = (Map)this.advancementToProgressField.get(cam);
                }
                catch (Throwable t) {
                    Log.warningEx("Could not get ClientAdvancementManager.advancementToProgress field", t, new Object[0]);
                    this.advancementToProgress = null;
                    return HasAdvancement.DONT_KNOW;
                }
            }
            if (this.advancementToProgress == null) {
                return HasAdvancement.DONT_KNOW;
            }
            Object progress = this.advancementToProgress.get(adv);
            if (progress == null) {
                return HasAdvancement.NO;
            }
            if (!(progress instanceof AdvancementProgress)) {
                Log.warning("The ClientAdvancementManager.advancementToProgress map does not contain AdvancementProgress instances", new Object[0]);
                this.advancementToProgress = null;
                return HasAdvancement.DONT_KNOW;
            }
            return ((AdvancementProgress)progress).m_8193_() ? HasAdvancement.YES : HasAdvancement.NO;
        }
        return HasAdvancement.DONT_KNOW;
    }

    @Override
    public MinecraftServer getServer() {
        return this.mc.m_91092_();
    }

    @Override
    public void handleJSResponseSuccess(int reqId, JSServerRequest type, byte[] data) {
        JSQueryDispatcher.ServerQuery q = this.jsDispatcher.fulfillQuery(reqId);
        if (q == null) {
            Log.warning("Received success response for invalid query ID %d of type %s", reqId, type.toString());
        } else if (type == JSServerRequest.CLEAR_REDSTONE || type == JSServerRequest.SET_REDSTONE_AT) {
            q.success("{\"status\":\"success\"}");
        } else {
            Log.warning("Received success response for query ID %d, but type is invalid", reqId);
        }
    }

    @Override
    public void handleJSResponseError(int reqId, JSServerRequest type, int errCode, String err) {
        JSQueryDispatcher.ServerQuery q = this.jsDispatcher.fulfillQuery(reqId);
        if (q == null) {
            Log.warning("Received error response for invalid query ID %d of type %s", reqId, type.toString());
        } else {
            q.error(errCode, err);
        }
    }

    @Override
    public void setMiniservClientPort(int port) {
        this.miniservPort = port;
    }

    @Override
    public void startMiniservClient() {
        if (this.miniservPort <= 0) {
            Log.warning("Can't start miniserv client: miniserv is disabled", new Object[0]);
            return;
        }
        if (this.mc.f_91074_ == null) {
            Log.warning("Can't start miniserv client: player is null", new Object[0]);
            return;
        }
        SocketAddress saddr = this.mc.f_91074_.f_108617_.m_6198_().channel().remoteAddress();
        if (saddr == null || !(saddr instanceof InetSocketAddress)) {
            Log.warning("Miniserv client: remote address is not inet, assuming local address", new Object[0]);
            saddr = new InetSocketAddress("127.0.0.1", 1234);
        }
        InetSocketAddress msAddr = new InetSocketAddress(((InetSocketAddress)saddr).getAddress(), this.miniservPort);
        Client.getInstance().start(msAddr);
        this.msClientStarted = true;
    }

    @Override
    public boolean isMiniservDisabled() {
        return this.miniservPort <= 0;
    }

    @Override
    public void closeGui(BlockPos bp, BlockSide bs) {
        WDScreen scr;
        if (this.mc.f_91080_ instanceof WDScreen && (scr = (WDScreen)this.mc.f_91080_).isForBlock(bp, bs)) {
            this.mc.m_91152_(null);
        }
    }

    @Override
    public void renderRecipes() {
        this.nextScreen = new RenderRecipe();
    }

    @Override
    public boolean isShiftDown() {
        return Screen.m_96638_();
    }

    public void m_6213_(ResourceManager resourceManager) {
        Log.info("Resource manager reload: clearing GUI cache...", new Object[0]);
        GuiLoader.clearCache();
    }

    public void onAddressChange(IBrowser browser, String url) {
        if (browser != null) {
            long t = System.currentTimeMillis();
            for (PadData pd : this.padList) {
                if (pd.view != browser || t - pd.lastURLSent < 1000L) continue;
                if (WebDisplays.isSiteBlacklisted(url)) {
                    pd.view.loadURL("mod://webdisplays/blacklisted.html");
                    break;
                }
                pd.lastURLSent = t;
                Messages.INSTANCE.sendToServer((Object)new SMessagePadCtrl(pd.id, url));
                break;
            }
            for (TileEntityScreen tes : this.screenTracking) {
                tes.updateClientSideURL(browser, url);
            }
        }
    }

    public void onTitleChange(IBrowser browser, String title) {
    }

    public void onTooltip(IBrowser browser, String text) {
    }

    public void onStatusMessage(IBrowser browser, String value) {
    }

    public boolean handleQuery(IBrowser browser, long queryId, String query, boolean persistent, IJSQueryCallback cb) {
        if (browser != null && persistent && query != null && cb != null && (query = query.toLowerCase()).startsWith("webdisplays_")) {
            String args;
            int parenthesis = (query = query.substring(12)).indexOf(40);
            if (parenthesis < 0) {
                args = null;
            } else {
                if (query.indexOf(41) != query.length() - 1) {
                    cb.failure(400, "Malformed request");
                    return true;
                }
                args = query.substring(parenthesis + 1, query.length() - 1);
                query = query.substring(0, parenthesis);
            }
            if (this.jsDispatcher.canHandleQuery(query)) {
                this.jsDispatcher.enqueueQuery(browser, query, args, cb);
            } else {
                cb.failure(404, "Unknown WebDisplays query");
            }
            return true;
        }
        return false;
    }

    public void cancelQuery(IBrowser browser, long queryId) {
    }

    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent ev) {
        WebDisplays wd = WebDisplays.INSTANCE;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)290)) {
                if (!this.isF1Down) {
                    Slot slot;
                    this.isF1Down = true;
                    String wikiName = null;
                    if (this.mc.f_91080_ instanceof WDScreen) {
                        wikiName = ((WDScreen)this.mc.f_91080_).getWikiPageName();
                    } else if (this.mc.f_91080_ instanceof ContainerScreen && (slot = ((ContainerScreen)this.mc.f_91080_).getSlotUnderMouse()) != null && slot.m_6657_() && slot.m_7993_().m_41720_() instanceof WDItem) {
                        wikiName = ((WDItem)slot.m_7993_().m_41720_()).getWikiName(slot.m_7993_());
                    }
                    if (wikiName != null) {
                        this.mcef.openExampleBrowser("https://montoyo.net/wdwiki/index.php/" + wikiName);
                    }
                }
            } else if (this.isF1Down) {
                this.isF1Down = false;
            }
            if (this.nextScreen != null && this.mc.f_91080_ == null) {
                this.mc.m_91152_(this.nextScreen);
                this.nextScreen = null;
            }
            if (this.mc.f_91074_ != null && !this.screenTracking.isEmpty()) {
                int id = this.lastTracked % this.screenTracking.size();
                ++this.lastTracked;
                TileEntityScreen tes = this.screenTracking.get(id);
                double dist2 = this.mc.f_91074_.m_20275_((double)tes.m_58899_().m_123341_(), (double)tes.m_58899_().m_123342_(), (double)tes.m_58899_().m_123343_());
                if (tes.isLoaded()) {
                    if (dist2 > WebDisplays.INSTANCE.unloadDistance2) {
                        tes.unload();
                    }
                } else if (dist2 <= WebDisplays.INSTANCE.loadDistance2) {
                    tes.load();
                }
            }
            if (++this.minePadTickCounter >= 10) {
                this.minePadTickCounter = 0;
                LocalPlayer ep = this.mc.f_91074_;
                for (PadData pd : this.padList) {
                    pd.isInHotbar = false;
                }
                if (ep != null) {
                    this.updateInventory((NonNullList<ItemStack>)ep.m_150109_().f_35974_, ep.m_21120_(InteractionHand.MAIN_HAND), 9);
                    this.updateInventory((NonNullList<ItemStack>)ep.m_150109_().f_35976_, ep.m_21120_(InteractionHand.OFF_HAND), 1);
                }
                for (int i = this.padList.size() - 1; i >= 0; --i) {
                    PadData pd = this.padList.get(i);
                    if (pd.isInHotbar) continue;
                    pd.view.close();
                    pd.view = null;
                    this.padList.remove(i);
                    this.padMap.remove(pd.id);
                }
            }
            boolean raycastHit = false;
            if (this.mc.f_91074_ != null && this.mc.f_91073_ != null && ItemInit.itemLaserPointer.isPresent() && this.mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND).m_41720_().equals(ItemInit.itemLaserPointer.get()) && this.mc.f_91066_.f_92095_.m_90857_() && (this.mc.f_91077_ == null || this.mc.f_91077_.m_6662_() != HitResult.Type.BLOCK)) {
                this.laserPointerRenderer.isOn = true;
                BlockHitResult result = this.raycast(64.0);
                BlockPos bpos = result.m_82425_();
                if (result.m_6662_() == HitResult.Type.BLOCK && this.mc.f_91073_.m_8055_(bpos).m_60734_() == BlockInit.blockScreen.get()) {
                    Vector3i pos = new Vector3i(result.m_82425_());
                    BlockSide side = BlockSide.values()[result.m_82434_().ordinal()];
                    Multiblock.findOrigin((LevelAccessor)this.mc.f_91073_, pos, side, null);
                    TileEntityScreen te = (TileEntityScreen)this.mc.f_91073_.m_7702_(pos.toBlock());
                    if (te != null && te.hasUpgrade(side, DefaultUpgrade.LASER_MOUSE)) {
                        Vector2i tmp;
                        float hitZ;
                        float hitY;
                        float hitX;
                        TileEntityScreen.Screen scr = te.getScreen(side);
                        if (scr.browser != null && BlockScreen.hit2pixels(side, bpos, pos, scr, hitX = (float)result.m_82450_().f_82479_ - (float)bpos.m_123341_(), hitY = (float)result.m_82450_().f_82480_ - (float)bpos.m_123342_(), hitZ = (float)result.m_82450_().f_82481_ - (float)bpos.m_123343_(), tmp = new Vector2i())) {
                            this.laserClick(te, side, scr, tmp);
                            raycastHit = true;
                        }
                    }
                }
            } else {
                this.laserPointerRenderer.isOn = false;
            }
            if (!raycastHit) {
                this.deselectScreen();
            }
            this.jsDispatcher.handleQueries();
            if (this.msClientStarted && this.mc.f_91074_ == null) {
                this.msClientStarted = false;
                Client.getInstance().stop();
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayerHand(RenderHandEvent ev) {
        Item item = ev.getItemStack().m_41720_();
        if (ItemInit.itemMinePad.isPresent() && ItemInit.itemLaserPointer.isPresent()) {
            IItemRenderer renderer;
            if (item == ItemInit.itemMinePad.get()) {
                renderer = this.minePadRenderer;
            } else if (item == ItemInit.itemLaserPointer.get()) {
                renderer = this.laserPointerRenderer;
            } else {
                return;
            }
            HumanoidArm handSide = this.mc.f_91074_.m_5737_();
            if (ev.getHand() == InteractionHand.OFF_HAND) {
                handSide = handSide.m_20828_();
            }
            renderer.render(ev.getPoseStack(), ev.getItemStack(), handSide == HumanoidArm.RIGHT ? 1.0f : -1.0f, ev.getSwingProgress(), ev.getEquipProgress(), ev.getMultiBufferSource(), ev.getPackedLight());
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload ev) {
        Log.info("World unloaded; killing screens...", new Object[0]);
        LevelAccessor levelAccessor = ev.getWorld();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            ResourceLocation dim = level.m_46472_().m_135782_();
            for (int i = this.screenTracking.size() - 1; i >= 0; --i) {
                if (!this.screenTracking.get(i).m_58904_().m_46472_().m_135782_().equals((Object)dim)) continue;
                this.screenTracking.remove(i).unload();
            }
        }
    }

    private void laserClick(TileEntityScreen tes, BlockSide side, TileEntityScreen.Screen scr, Vector2i hit) {
        if (this.pointedScreen == tes && this.pointedScreenSide == side) {
            long t = System.currentTimeMillis();
            if (t - this.lastPointPacket >= 100L) {
                this.lastPointPacket = t;
                Messages.INSTANCE.sendToServer((Object)SMessageScreenCtrl.vec2(tes, side, 9, hit));
            }
        } else {
            this.deselectScreen();
            this.pointedScreen = tes;
            this.pointedScreenSide = side;
            Messages.INSTANCE.sendToServer((Object)SMessageScreenCtrl.vec2(tes, side, 8, hit));
        }
    }

    private void deselectScreen() {
        if (this.pointedScreen != null && this.pointedScreenSide != null) {
            Messages.INSTANCE.sendToServer((Object)SMessageScreenCtrl.laserUp(this.pointedScreen, this.pointedScreenSide));
            this.pointedScreen = null;
            this.pointedScreenSide = null;
        }
    }

    private BlockHitResult raycast(double dist) {
        Vec3 start = this.mc.f_91074_.m_20299_(1.0f);
        Vec3 lookVec = this.mc.f_91074_.m_20154_();
        Vec3 end = start.m_82520_(lookVec.f_82479_ * dist, lookVec.f_82480_ * dist, lookVec.f_82481_ * dist);
        return this.mc.f_91073_.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null));
    }

    private void updateInventory(NonNullList<ItemStack> inv, ItemStack heldStack, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            CompoundTag tag;
            ItemStack item = (ItemStack)inv.get(i);
            if (!ItemInit.itemMinePad.isPresent() || item.m_41720_() != ItemInit.itemMinePad.get() || (tag = item.m_41783_()) == null || !tag.m_128441_("PadID")) continue;
            this.updatePad(tag.m_128451_("PadID"), tag, item == heldStack);
        }
    }

    private void updatePad(int id, CompoundTag tag, boolean isSelected) {
        PadData pd = this.padMap.get(id);
        if (pd != null) {
            pd.isInHotbar = true;
        } else if (isSelected && tag.m_128441_("PadURL")) {
            pd = new PadData(tag.m_128461_("PadURL"), id);
            this.padMap.put(id, pd);
            this.padList.add(pd);
        }
    }

    public MinePadRenderer getMinePadRenderer() {
        return this.minePadRenderer;
    }

    public PadData getPadByID(int id) {
        return this.padMap.get(id);
    }

    public API getMCEF() {
        return this.mcef;
    }

    public boolean findScreenFromBrowser(IBrowser browser, ScreenSidePair pair) {
        for (TileEntityScreen tes : this.screenTracking) {
            for (int i = 0; i < tes.screenCount(); ++i) {
                TileEntityScreen.Screen scr = tes.getScreen(i);
                if (scr.browser != browser) continue;
                pair.tes = tes;
                pair.side = scr.side;
                return true;
            }
        }
        return false;
    }

    private static Field findAdvancementToProgressField() {
        Field[] fields = ClientAdvancements.class.getDeclaredFields();
        Optional<Field> result = Arrays.stream(fields).filter(f -> f.getType() == Map.class).findAny();
        if (result.isPresent()) {
            try {
                Field ret = result.get();
                ret.setAccessible(true);
                return ret;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        Log.warning("ClientAdvancementManager.advancementToProgress field could not be found", new Object[0]);
        return null;
    }

    public class PadData {
        public IBrowser view;
        private boolean isInHotbar;
        private final int id;
        private long lastURLSent;

        private PadData(String url, int id) {
            this.view = ClientProxy.this.mcef.createBrowser(WebDisplays.applyBlacklist(url));
            this.view.resize((int)WebDisplays.INSTANCE.padResX, (int)WebDisplays.INSTANCE.padResY);
            this.isInHotbar = true;
            this.id = id;
        }
    }

    public static final class ScreenSidePair {
        public TileEntityScreen tes;
        public BlockSide side;
    }
}

