/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLPaths;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.gui.GuiSubscribe;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.client.gui.controls.Button;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.controls.Label;
import net.montoyo.wd.client.gui.loading.FillControl;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.net.Messages;
import net.montoyo.wd.net.server.SMessageScreenCtrl;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.TypeData;
import net.montoyo.wd.utilities.Util;
import org.cef.browser.CefBrowserOsr;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class GuiKeyboard
extends WDScreen {
    private static final String WARNING_FNAME = "wd_keyboard_warning.txt";
    private TileEntityScreen tes;
    private BlockSide side;
    private final ArrayList<TypeData> evStack = new ArrayList();
    private BlockPos kbPos;
    private boolean showWarning = true;
    @FillControl
    private Label lblInfo;
    @FillControl
    private Button btnOk;

    public GuiKeyboard() {
        super(Component.m_130674_(null));
    }

    public GuiKeyboard(TileEntityScreen tes, BlockSide side, BlockPos kbPos) {
        this();
        this.tes = tes;
        this.side = side;
        this.kbPos = kbPos;
    }

    @Override
    protected void addLoadCustomVariables(Map<String, Double> vars) {
        vars.put("showWarning", this.showWarning ? 1.0 : 0.0);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.showWarning = this.f_96541_.m_91092_() != null && !this.f_96541_.m_91092_().m_6992_() ? false : !this.hasUserReadWarning();
        this.loadFrom(new ResourceLocation("webdisplays", "gui/kb_right.json"));
        if (this.showWarning) {
            int maxLabelW = 0;
            int totalH = 0;
            for (Control ctrl : this.controls) {
                if (ctrl == this.lblInfo || !(ctrl instanceof Label)) continue;
                if (ctrl.getWidth() > maxLabelW) {
                    maxLabelW = ctrl.getWidth();
                }
                totalH += ctrl.getHeight();
                ctrl.setPos((this.f_96543_ - ctrl.getWidth()) / 2, 0);
            }
            this.btnOk.setWidth(maxLabelW);
            this.btnOk.setPos((this.f_96543_ - maxLabelW) / 2, 0);
            int y = (this.f_96544_ - (totalH += this.btnOk.getHeight())) / 2;
            for (Control ctrl : this.controls) {
                if (ctrl == this.lblInfo) continue;
                ctrl.setPos(ctrl.getX(), y);
                y += ctrl.getHeight();
            }
        } else if (!this.f_96541_.m_91302_()) {
            this.f_96541_.m_7440_(true);
            this.f_96541_.f_91067_.m_91601_();
        }
        this.defaultBackground = this.showWarning;
        this.syncTicks = 5;
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.key(keyCode, scanCode, true, modifiers);
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.key(keyCode, scanCode, false, modifiers);
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void key(int keyCode, int scanCode, boolean pressed, int mod) {
        if (pressed) {
            if (this.quitOnEscape && keyCode == 256) {
                Minecraft.m_91087_().m_91152_(null);
            }
            int chr = this.getChar(keyCode, scanCode);
            this.evStack.add(new TypeData(TypeData.Action.PRESS, chr, mod));
            this.evStack.add(new TypeData(TypeData.Action.RELEASE, chr, mod));
            if (keyCode != 0) {
                this.evStack.add(new TypeData(TypeData.Action.TYPE, chr, mod));
            }
            if (!this.evStack.isEmpty() && !this.syncRequested()) {
                this.requestSync();
            }
        }
    }

    public int getChar(int keyCode, int scanCode) {
        String keystr = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
        if (keystr == null) {
            keystr = "\u0000";
        }
        if (keyCode == 257) {
            return 13;
        }
        if (keyCode == 32) {
            return 32;
        }
        if (keystr.length() == 0) {
            return -1;
        }
        if (GuiKeyboard.m_96638_()) {
            keystr = keystr.toUpperCase(Locale.ROOT);
            return CefBrowserOsr.remapKeycode((int)keyCode, (char)keystr.charAt(keystr.length() - 1));
        }
        return CefBrowserOsr.remapKeycode((int)keyCode, (char)keystr.charAt(keystr.length() - 1));
    }

    @Override
    protected void sync() {
        if (!this.evStack.isEmpty()) {
            Messages.INSTANCE.sendToServer((Object)SMessageScreenCtrl.type(this.tes, this.side, WebDisplays.GSON.toJson(this.evStack), this.kbPos));
            this.evStack.clear();
        }
    }

    @GuiSubscribe
    public void onClick(Button.ClickEvent ev) {
        if (this.showWarning && ev.getSource() == this.btnOk) {
            this.writeUserAcknowledge();
            for (Control ctrl : this.controls) {
                Label lbl;
                if (!(ctrl instanceof Label)) continue;
                lbl.setVisible(!(lbl = (Label)ctrl).isVisible());
            }
            this.btnOk.setDisabled(true);
            this.btnOk.setVisible(false);
            this.showWarning = false;
            this.defaultBackground = false;
            this.f_96541_.m_7440_(true);
            this.f_96541_.f_91067_.m_91601_();
        }
    }

    private boolean hasUserReadWarning() {
        try {
            File f = new File(FMLPaths.GAMEDIR.name(), WARNING_FNAME);
            if (f.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(f));
                String str = br.readLine();
                Util.silentClose(br);
                return str != null && str.trim().equalsIgnoreCase("read");
            }
        }
        catch (Throwable t) {
            Log.warningEx("Can't know if user has already read the warning", t, new Object[0]);
        }
        return false;
    }

    private void writeUserAcknowledge() {
        try {
            File f = new File(FMLPaths.GAMEDIR.name(), WARNING_FNAME);
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write("read\n");
            Util.silentClose(bw);
        }
        catch (Throwable t) {
            Log.warningEx("Can't write that the user read the warning", t, new Object[0]);
        }
    }

    @Override
    public boolean isForBlock(BlockPos bp, BlockSide side) {
        return bp.equals((Object)this.kbPos) || bp.equals((Object)this.tes.m_58899_()) && side == this.side;
    }
}

