/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.client.gui.GuiSubscribe;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.client.gui.controls.Button;
import net.montoyo.wd.client.gui.controls.TextField;
import net.montoyo.wd.client.gui.loading.FillControl;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.init.ItemInit;
import net.montoyo.wd.net.Messages;
import net.montoyo.wd.net.server.SMessagePadCtrl;
import net.montoyo.wd.net.server.SMessageScreenCtrl;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector3i;

public class GuiSetURL2
extends WDScreen {
    private TileEntityScreen tileEntity;
    private BlockSide screenSide;
    private Vector3i remoteLocation;
    private final boolean isPad;
    private final String screenURL;
    @FillControl
    private TextField tfURL;
    @FillControl
    private Button btnShutDown;
    @FillControl
    private Button btnCancel;
    @FillControl
    private Button btnOk;

    public GuiSetURL2(TileEntityScreen tes, BlockSide side, String url, Vector3i rl) {
        super(Component.m_130674_(null));
        this.tileEntity = tes;
        this.screenSide = side;
        this.remoteLocation = rl;
        this.isPad = false;
        this.screenURL = url;
    }

    public GuiSetURL2(String url) {
        super(Component.m_130674_(null));
        this.isPad = true;
        this.screenURL = url;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.loadFrom(new ResourceLocation("webdisplays", "gui/seturl.json"));
        this.tfURL.setText(this.screenURL);
    }

    @Override
    protected void addLoadCustomVariables(Map<String, Double> vars) {
        vars.put("isPad", this.isPad ? 1.0 : 0.0);
    }

    @GuiSubscribe
    public void onButtonClicked(Button.ClickEvent ev) {
        if (ev.getSource() == this.btnCancel) {
            this.f_96541_.m_91152_(null);
        } else if (ev.getSource() == this.btnOk) {
            this.validate(this.tfURL.getText());
        } else if (ev.getSource() == this.btnShutDown) {
            if (this.isPad) {
                Messages.INSTANCE.sendToServer((Object)new SMessagePadCtrl(""));
            }
            this.f_96541_.m_91152_(null);
        }
    }

    @GuiSubscribe
    public void onEnterPressed(TextField.EnterPressedEvent ev) {
        this.validate(ev.getText());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void validate(String url) {
        if (!url.isEmpty()) {
            url = Util.addProtocol(url);
            url = ((ClientProxy)WebDisplays.PROXY).getMCEF().punycode(url);
            if (this.isPad) {
                ClientProxy.PadData pd;
                Messages.INSTANCE.sendToServer((Object)new SMessagePadCtrl(url));
                ItemStack held = this.f_96541_.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
                if (held.m_41720_().equals(ItemInit.itemMinePad.get()) && held.m_41783_() != null && held.m_41783_().m_128441_("PadID") && (pd = ((ClientProxy)WebDisplays.PROXY).getPadByID(held.m_41783_().m_128451_("PadID"))) != null && pd.view != null) {
                    pd.view.loadURL(WebDisplays.applyBlacklist(url));
                }
            } else {
                Messages.INSTANCE.sendToServer((Object)SMessageScreenCtrl.setURL(this.tileEntity, this.screenSide, url, this.remoteLocation));
            }
        }
        this.f_96541_.m_91152_(null);
    }

    @Override
    public boolean isForBlock(BlockPos bp, BlockSide side) {
        return this.remoteLocation != null && this.remoteLocation.equalsBlockPos(bp) || bp.equals((Object)this.tileEntity.m_58899_()) && side == this.screenSide;
    }
}

