/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;
import net.montoyo.wd.utilities.Bounds;
import org.lwjgl.opengl.GL11;

public abstract class Control {
    public static final int COLOR_BLACK = -16777216;
    public static final int COLOR_WHITE = -1;
    public static final int COLOR_RED = -65536;
    public static final int COLOR_GREEN = -16711936;
    public static final int COLOR_BLUE = -16776961;
    public static final int COLOR_CYAN = -16711681;
    public static final int COLOR_MANGENTA = -65281;
    public static final int COLOR_YELLOW = -256;
    protected final Minecraft mc = Minecraft.m_91087_();
    protected final Font font;
    protected final Tesselator tessellator;
    protected final BufferBuilder vBuffer;
    protected static WDScreen parent;
    protected String name;
    protected Object userdata;

    public Control() {
        this.font = this.mc.f_91062_;
        this.tessellator = Tesselator.m_85913_();
        this.vBuffer = this.tessellator.m_85915_();
        parent = WDScreen.CURRENT_SCREEN;
    }

    public Object getUserdata() {
        return this.userdata;
    }

    public void setUserdata(Object userdata) {
        this.userdata = userdata;
    }

    public boolean keyTyped(int keyCode, int modifier) {
        return false;
    }

    public boolean keyUp(int key) {
        return false;
    }

    public boolean keyDown(int key) {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        return false;
    }

    public boolean mouseClickMove(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    public boolean mouseMove(double mouseX, double mouseY) {
        return false;
    }

    public boolean mouseScroll(double mouseX, double mouseY, double amount) {
        return false;
    }

    public void draw(PoseStack poseStack, int mouseX, int mouseY, float ptt) {
    }

    public void postDraw(PoseStack poseStack, int mouseX, int mouseY, float ptt) {
    }

    public void destroy() {
    }

    public WDScreen getParent() {
        return parent;
    }

    public abstract int getX();

    public abstract int getY();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract void setPos(int var1, int var2);

    public void fillRect(int x, double y, int w, int h, int color) {
        double x1 = x;
        double y1 = y;
        double x2 = x + w;
        double y2 = y + (double)h;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.m_157429_((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.vBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        this.vBuffer.m_5483_(x1, y2, 0.0).m_5752_();
        this.vBuffer.m_5483_(x2, y2, 0.0).m_5752_();
        this.vBuffer.m_5483_(x2, y1, 0.0).m_5752_();
        this.vBuffer.m_5483_(x1, y1, 0.0).m_5752_();
        this.tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        GL11.glEnable((int)3553);
    }

    public void fillTexturedRect(PoseStack poseStack, int x, int y, int w, int h, double u1, double v1, double u2, double v2) {
        double x1 = x;
        double y1 = y;
        double x2 = x + w;
        double y2 = y + h;
        this.vBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        this.vBuffer.m_5483_(x1, y2, 0.0).m_7421_((float)u1, (float)v2).m_6122_(255, 255, 255, 255).m_5752_();
        this.vBuffer.m_5483_(x2, y2, 0.0).m_7421_((float)u2, (float)v2).m_6122_(255, 255, 255, 255).m_5752_();
        this.vBuffer.m_5483_(x2, y1, 0.0).m_7421_((float)u2, (float)v1).m_6122_(255, 255, 255, 255).m_5752_();
        this.vBuffer.m_5483_(x1, y1, 0.0).m_7421_((float)u1, (float)v1).m_6122_(255, 255, 255, 255).m_5752_();
        this.tessellator.m_85914_();
    }

    public static void blend(boolean enable) {
        if (enable) {
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
        } else {
            RenderSystem.m_69461_();
        }
    }

    public void bindTexture(ResourceLocation resLoc) {
        if (resLoc == null) {
            RenderSystem.m_157453_((int)0, (int)0);
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)resLoc);
        }
    }

    public void drawBorder(PoseStack poseStack, int x, int y, int w, int h, int color) {
        this.drawBorder(poseStack, x, y, w, h, color, 1.0);
    }

    public void drawBorder(PoseStack poseStack, int x, int y, int w, int h, int color, double sz) {
        double x1 = x;
        double y1 = y;
        double x2 = x + w;
        double y2 = y + h;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.m_157429_((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
        RenderSystem.m_69493_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.vBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        this.vBuffer.m_5483_(x1, y1 + sz, 0.0).m_5752_();
        this.vBuffer.m_5483_(x2, y1 + sz, 0.0).m_5752_();
        this.vBuffer.m_5483_(x2, y1, 0.0).m_5752_();
        this.vBuffer.m_5483_(x1, y1, 0.0).m_5752_();
        this.vBuffer.m_5483_(x1, y2, 0.0).m_5752_();
        this.vBuffer.m_5483_(x2, y2, 0.0).m_5752_();
        this.vBuffer.m_5483_(x2, y2 - sz, 0.0).m_5752_();
        this.vBuffer.m_5483_(x1, y2 - sz, 0.0).m_5752_();
        this.vBuffer.m_5483_(x1, y2, 0.0).m_5752_();
        this.vBuffer.m_5483_(x1 + sz, y2, 0.0).m_5752_();
        this.vBuffer.m_5483_(x1 + sz, y1, 0.0).m_5752_();
        this.vBuffer.m_5483_(x1, y1, 0.0).m_5752_();
        this.vBuffer.m_5483_(x2 - sz, y2, 0.0).m_5752_();
        this.vBuffer.m_5483_(x2, y2, 0.0).m_5752_();
        this.vBuffer.m_5483_(x2, y1, 0.0).m_5752_();
        this.vBuffer.m_5483_(x2 - sz, y1, 0.0).m_5752_();
        this.tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public PoseStack beginFramebuffer(RenderTarget fbo, float vpW, float vpH) {
        fbo.m_83947_(true);
        RenderSystem.m_157183_();
        RenderSystem.m_157425_((Matrix4f)Matrix4f.m_162203_((float)0.0f, (float)vpW, (float)vpH, (float)0.0f, (float)-1.0f, (float)1.0f));
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_166856_();
        RenderSystem.m_157182_();
        if (!fbo.f_83919_) {
            RenderSystem.m_69465_();
        }
        return poseStack;
    }

    public void endFramebuffer(PoseStack poseStack, RenderTarget fbo) {
        if (!fbo.f_83919_) {
            RenderSystem.m_69482_();
        }
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_157424_();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
        fbo.m_83970_();
        this.mc.m_91385_().m_83947_(true);
    }

    public static String tr(String text) {
        if (text.length() >= 2 && text.charAt(0) == '$') {
            if (text.charAt(1) == '$') {
                return text.substring(1);
            }
            return I18n.m_118938_((String)text.substring(1), (Object[])new Object[0]);
        }
        return text;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void load(JsonOWrapper json) {
        this.name = json.getString("name", "");
    }

    public static Bounds findBounds(List<Control> controlList) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (Control ctrl : controlList) {
            int x = ctrl.getX();
            int y = ctrl.getY();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            y += ctrl.getHeight();
            if ((x += ctrl.getWidth()) > maxX) {
                maxX = x;
            }
            if (y < maxY) continue;
            maxY = y;
        }
        return new Bounds(minX, minY, maxX, maxY);
    }
}

