/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.montoyo.wd.client.gui.controls.BasicControl;
import net.montoyo.wd.client.gui.controls.Event;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;

public class UpgradeGroup
extends BasicControl {
    private int width;
    private int height;
    private ArrayList<ItemStack> upgrades;
    private ItemStack overStack;
    private ItemStack clickStack;
    private final ItemRenderer renderItem = Minecraft.m_91087_().m_91291_();

    public UpgradeGroup() {
        parent.requirePostDraw(this);
    }

    @Override
    public void draw(PoseStack poseStack, int mouseX, int mouseY, float ptt) {
        if (this.upgrades != null) {
            int x = this.x;
            for (ItemStack is : this.upgrades) {
                if (is == this.overStack && !this.disabled) {
                    this.fillRect(x, this.y, 16, 16, -2130771968);
                }
                this.renderItem.m_174229_((LivingEntity)this.mc.f_91074_, is, x, this.y, 0);
                Objects.requireNonNull(this.font);
                this.renderItem.m_174253_(is, 9, x, this.y);
                x += 18;
            }
        }
    }

    @Override
    public void postDraw(PoseStack poseStack, int mouseX, int mouseY, float ptt) {
        if (this.overStack != null) {
            parent.drawItemStackTooltip(poseStack, this.overStack, mouseX, mouseY);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void setUpgrades(ArrayList<ItemStack> upgrades) {
        this.upgrades = upgrades;
    }

    public ArrayList<ItemStack> getUpgrades() {
        return this.upgrades;
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        this.width = json.getInt("width", 0);
        this.height = json.getInt("height", 16);
    }

    @Override
    public boolean mouseMove(double mouseX, double mouseY) {
        if (this.upgrades != null) {
            this.overStack = null;
            if (mouseY >= (double)this.y && mouseY <= (double)(this.y + 16) && mouseX >= (double)this.x) {
                int sel = (int)((mouseX -= (double)this.x) / 18.0);
                if (sel < this.upgrades.size() && mouseX % 18.0 <= 16.0) {
                    this.overStack = this.upgrades.get(sel);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.clickStack = this.overStack;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        if (state == 0 && this.clickStack != null) {
            if (this.clickStack == this.overStack && !this.disabled && this.upgrades.contains(this.clickStack)) {
                parent.actionPerformed(new ClickEvent(this));
            }
            this.clickStack = null;
            return true;
        }
        return false;
    }

    public ItemStack getMouseOverUpgrade() {
        return this.overStack;
    }

    public static class ClickEvent
    extends Event<UpgradeGroup> {
        private final ItemStack clickStack;

        public ClickEvent(UpgradeGroup src) {
            this.source = src;
            this.clickStack = src.clickStack;
        }

        public ItemStack getMouseOverStack() {
            return this.clickStack;
        }
    }
}

