/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.renderers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import net.montoyo.wd.client.renderers.IModelBaker;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Vector3f;
import net.montoyo.wd.utilities.Vector3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenBaker
implements IModelBaker {
    private static final List<BakedQuad> noQuads = ImmutableList.of();
    private final TextureAtlasSprite[] texs = new TextureAtlasSprite[16];
    private final BlockSide[] blockSides = BlockSide.values();
    private final Direction[] blockFacings = Direction.values();
    private final ModelState modelState;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ItemOverrides overrides;
    private final ItemTransforms itemTransforms;

    public ScreenBaker(ModelState modelState, Function<Material, TextureAtlasSprite> spriteGetter, ItemOverrides overrides, ItemTransforms itemTransforms) {
        this.modelState = modelState;
        this.spriteGetter = spriteGetter;
        this.overrides = overrides;
        this.itemTransforms = itemTransforms;
    }

    @Override
    public void loadTextures(TextureAtlas texMap) {
        for (int i = 0; i < this.texs.length; ++i) {
            this.texs[i] = texMap.m_118316_(new ResourceLocation("webdisplays", "blocks/screen" + i));
        }
    }

    private void putVertex(int[] buf, int pos, Vector3f vpos, TextureAtlasSprite tex, Vector3f uv, Vector3i normal) {
        buf[pos * 7 + 0] = Float.floatToRawIntBits(vpos.x);
        buf[pos * 7 + 1] = Float.floatToRawIntBits(vpos.y);
        buf[pos * 7 + 2] = Float.floatToRawIntBits(vpos.z);
        buf[pos * 7 + 3] = -1;
        buf[pos * 7 + 4] = Float.floatToRawIntBits(tex.m_118367_((double)uv.x));
        buf[pos * 7 + 5] = Float.floatToRawIntBits(tex.m_118393_((double)uv.y));
        int nx = normal.x * 127 & 0xFF;
        int ny = normal.y * 127 & 0xFF;
        int nz = normal.z * 127 & 0xFF;
        buf[pos * 7 + 6] = nx | ny << 8 | nz << 16;
    }

    private Vector3f rotateVec(Vector3f vec, BlockSide side) {
        switch (side) {
            case BOTTOM: {
                return new Vector3f(vec.x, 1.0f, 1.0f - vec.z);
            }
            case TOP: {
                return new Vector3f(vec.x, 0.0f, vec.z);
            }
            case NORTH: {
                return new Vector3f(vec.x, vec.z, 1.0f);
            }
            case SOUTH: {
                return new Vector3f(vec.x, 1.0f - vec.z, 0.0f);
            }
            case WEST: {
                return new Vector3f(1.0f, vec.x, vec.z);
            }
            case EAST: {
                return new Vector3f(0.0f, 1.0f - vec.x, vec.z);
            }
        }
        throw new RuntimeException("Unknown block side " + side);
    }

    private Vector3f rotateTex(BlockSide side, float u, float v) {
        switch (side) {
            case BOTTOM: {
                return new Vector3f(u, 16.0f - v, 0.0f);
            }
            case TOP: {
                return new Vector3f(u, v, 0.0f);
            }
            case NORTH: {
                return new Vector3f(16.0f - u, 16.0f - v, 0.0f);
            }
            case SOUTH: {
                return new Vector3f(u, v, 0.0f);
            }
            case WEST: {
                return new Vector3f(v, 16.0f - u, 0.0f);
            }
            case EAST: {
                return new Vector3f(16.0f - v, u, 0.0f);
            }
        }
        throw new RuntimeException("Unknown block side " + side);
    }

    private BakedQuad bakeSide(BlockSide side, TextureAtlasSprite tex) {
        int[] data = new int[28];
        this.putVertex(data, 3, this.rotateVec(new Vector3f(0.0f, 0.0f, 0.0f), side), tex, this.rotateTex(side, 0.0f, 0.0f), side.backward);
        this.putVertex(data, 2, this.rotateVec(new Vector3f(0.0f, 0.0f, 1.0f), side), tex, this.rotateTex(side, 0.0f, 16.0f), side.backward);
        this.putVertex(data, 1, this.rotateVec(new Vector3f(1.0f, 0.0f, 1.0f), side), tex, this.rotateTex(side, 16.0f, 16.0f), side.backward);
        this.putVertex(data, 0, this.rotateVec(new Vector3f(1.0f, 0.0f, 0.0f), side), tex, this.rotateTex(side, 16.0f, 0.0f), side.backward);
        return new BakedQuad(data, -1, this.blockFacings[side.ordinal()], tex, true);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random random, @NotNull IModelData iModelData) {
        if (side == null) {
            return noQuads;
        }
        BlockState bs = state;
        ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
        int sid = BlockSide.reverse(side.ordinal());
        BlockSide s = this.blockSides[sid];
        TextureAtlasSprite tex = this.texs[15];
        if (bs != null) {
            IntegerProperty[] sideFlags = new IntegerProperty[6];
            for (int i = 0; i < sideFlags.length; ++i) {
                sideFlags[i] = IntegerProperty.m_61631_((String)("neighbor" + i), (int)0, (int)15);
            }
            tex = this.texs[(Integer)bs.m_61143_((Property)sideFlags[sid])];
        }
        ret.add(this.bakeSide(s, tex));
        return ret;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.texs[15];
    }

    @Nonnull
    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

