/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.montoyo.wd.core.IPeripheral;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Vector3i;

public abstract class TileEntityPeripheralBase
extends BlockEntity
implements IPeripheral {
    protected Vector3i screenPos;
    protected BlockSide screenSide;

    public TileEntityPeripheralBase(BlockEntityType<?> arg, BlockPos arg2, BlockState arg3) {
        super(arg, arg2, arg3);
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        if (tag.m_128425_("WDScreen", 10)) {
            CompoundTag scr = tag.m_128469_("WDScreen");
            this.screenPos = new Vector3i(scr.m_128451_("X"), scr.m_128451_("Y"), scr.m_128451_("Z"));
            this.screenSide = BlockSide.values()[scr.m_128445_("Side")];
        } else {
            this.screenPos = null;
            this.screenSide = null;
        }
    }

    @Nonnull
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.serializeNBT();
        if (this.screenPos != null && this.screenSide != null) {
            CompoundTag scr = new CompoundTag();
            scr.m_128405_("X", this.screenPos.x);
            scr.m_128405_("Y", this.screenPos.y);
            scr.m_128405_("Z", this.screenPos.z);
            scr.m_128344_("Side", (byte)this.screenSide.ordinal());
            tag.m_128365_("WDScreen", (Tag)scr);
        }
        return tag;
    }

    @Override
    public boolean connect(Level world_, BlockPos blockPos, BlockState blockState, Vector3i pos, BlockSide side) {
        BlockEntity te = world_.m_7702_(pos.toBlock());
        if (te == null || !(te instanceof TileEntityScreen)) {
            Log.error("TileEntityPeripheralBase.connect(): Tile entity at %s is not a screen!", pos.toString());
            return false;
        }
        if (((TileEntityScreen)te).getScreen(side) == null) {
            Log.error("TileEntityPeripheralBase.connect(): There is no screen at %s on side %s!", pos.toString(), side.toString());
            return false;
        }
        this.screenPos = pos;
        this.screenSide = side;
        this.m_6596_();
        return true;
    }

    public boolean isLinked() {
        return this.screenPos != null && this.screenSide != null;
    }

    public boolean isScreenChunkLoaded() {
        if (this.screenPos == null || this.screenSide == null) {
            return true;
        }
        LevelChunk chunk = Objects.requireNonNull(this.m_58904_()).m_7726_().m_62227_(this.screenPos.x >> 4, this.screenPos.z >> 4, true);
        return chunk != null && !chunk.m_6430_();
    }

    @Nullable
    public TileEntityScreen getConnectedScreen() {
        if (this.screenPos == null || this.screenSide == null) {
            return null;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.screenPos.toBlock());
        if (te == null || !(te instanceof TileEntityScreen) || ((TileEntityScreen)te).getScreen(this.screenSide) == null) {
            this.screenPos = null;
            this.screenSide = null;
            this.m_6596_();
            return null;
        }
        return (TileEntityScreen)te;
    }

    @Nullable
    public TileEntityScreen getConnectedScreenEx() {
        if (this.screenPos == null || this.screenSide == null) {
            return null;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.screenPos.toBlock());
        if (te == null || !(te instanceof TileEntityScreen) || ((TileEntityScreen)te).getScreen(this.screenSide) == null) {
            return null;
        }
        return (TileEntityScreen)te;
    }

    @Nullable
    public Vector3i getScreenPos() {
        return this.screenPos;
    }

    @Nullable
    public BlockSide getScreenSide() {
        return this.screenSide;
    }

    public void onNeighborChange(Block neighborType, BlockPos neighborPos) {
    }

    public InteractionResult onRightClick(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }
}

