/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.server;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.net.Messages;
import net.montoyo.wd.net.client.CMessageACResult;
import net.montoyo.wd.utilities.NameUUIDPair;

public class SMessageACQuery
implements Runnable {
    private ServerPlayer player;
    private String beginning;
    private boolean matchExact;

    public SMessageACQuery(String beg, boolean exact) {
        this.beginning = beg;
        this.matchExact = exact;
    }

    public static SMessageACQuery decode(FriendlyByteBuf buf) {
        return new SMessageACQuery(buf.m_130277_(), buf.readBoolean());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.beginning);
        buf.writeBoolean(this.matchExact);
    }

    @Override
    public void run() {
        NameUUIDPair[] result;
        GameProfile[] profiles = WebDisplays.PROXY.getOnlineGameProfiles();
        if (this.matchExact) {
            result = (NameUUIDPair[])Arrays.stream(profiles).filter(gp -> gp.getName().equalsIgnoreCase(this.beginning)).map(NameUUIDPair::new).toArray(NameUUIDPair[]::new);
        } else {
            String lBeg = this.beginning.toLowerCase();
            result = (NameUUIDPair[])Arrays.stream(profiles).filter(gp -> gp.getName().toLowerCase().startsWith(lBeg)).map(NameUUIDPair::new).toArray(NameUUIDPair[]::new);
        }
        Messages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> this.player), (Object)new CMessageACResult(result));
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        this.player = contextSupplier.get().getSender();
        contextSupplier.get().enqueueWork((Runnable)this);
        contextSupplier.get().setPacketHandled(true);
    }
}

