/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.server;

import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.init.ItemInit;

public class SMessagePadCtrl
implements Runnable {
    private int id;
    private String url;
    private ServerPlayer player;

    public SMessagePadCtrl() {
    }

    public SMessagePadCtrl(String url) {
        this.id = -1;
        this.url = url;
    }

    public SMessagePadCtrl(int id, String url) {
        this.id = id;
        this.url = url;
    }

    private boolean matchesMinePadID(ItemStack is) {
        return is.m_41720_() == ItemInit.itemMinePad.get() && is.m_41783_() != null && is.m_41783_().m_128441_("PadID") && is.m_41783_().m_128451_("PadID") == this.id;
    }

    @Override
    public void run() {
        if (this.id < 0) {
            ItemStack is = this.player.m_21120_(InteractionHand.MAIN_HAND);
            if (is.m_41720_() == ItemInit.itemMinePad.get()) {
                if (this.url.isEmpty()) {
                    is.m_41751_(null);
                } else {
                    if (is.m_41783_() == null) {
                        is.m_41751_(new CompoundTag());
                    }
                    if (!is.m_41783_().m_128441_("PadID")) {
                        is.m_41783_().m_128405_("PadID", WebDisplays.getNextAvailablePadID());
                    }
                    is.m_41783_().m_128359_("PadURL", WebDisplays.applyBlacklist(this.url));
                }
            }
        } else {
            NonNullList inv = this.player.m_150109_().f_35974_;
            ItemStack target = null;
            for (int i = 0; i < 9; ++i) {
                if (!this.matchesMinePadID((ItemStack)inv.get(i))) continue;
                target = (ItemStack)inv.get(i);
                break;
            }
            if (target == null && this.matchesMinePadID((ItemStack)this.player.m_150109_().f_35976_.get(0))) {
                target = (ItemStack)this.player.m_150109_().f_35976_.get(0);
            }
            if (target != null) {
                target.m_41783_().m_128359_("PadURL", WebDisplays.applyBlacklist(this.url));
            }
        }
    }

    public static SMessagePadCtrl decode(FriendlyByteBuf buf) {
        SMessagePadCtrl message = new SMessagePadCtrl();
        message.id = buf.readInt();
        message.url = buf.m_130277_();
        return message;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.m_130070_(this.url);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        this.player = contextSupplier.get().getSender();
        contextSupplier.get().enqueueWork((Runnable)this);
        contextSupplier.get().setPacketHandled(true);
    }
}

