/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.server;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.entity.TileEntityRedCtrl;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector3i;

public class SMessageRedstoneCtrl
implements Runnable {
    private Player player;
    private ResourceLocation dimension;
    private Vector3i pos;
    private String risingEdgeURL;
    private String fallingEdgeURL;

    public SMessageRedstoneCtrl() {
    }

    public SMessageRedstoneCtrl(ResourceLocation d, Vector3i p, String r, String f) {
        this.dimension = d;
        this.pos = p;
        this.risingEdgeURL = r;
        this.fallingEdgeURL = f;
    }

    @Override
    public void run() {
        Level world = this.player.f_19853_;
        BlockPos blockPos = this.pos.toBlock();
        double maxRange = this.player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        if (!world.m_46472_().m_135782_().equals((Object)this.dimension) || this.player.m_20275_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()) > maxRange * maxRange) {
            return;
        }
        BlockEntity te = world.m_7702_(blockPos);
        if (te == null || !(te instanceof TileEntityRedCtrl)) {
            return;
        }
        TileEntityRedCtrl redCtrl = (TileEntityRedCtrl)te;
        if (!redCtrl.isScreenChunkLoaded()) {
            Util.toast(this.player, "chunkUnloaded", new Object[0]);
            return;
        }
        TileEntityScreen tes = redCtrl.getConnectedScreen();
        if (tes == null) {
            return;
        }
        if ((tes.getScreen(redCtrl.getScreenSide()).rightsFor(this.player) & 1) == 0) {
            return;
        }
        redCtrl.setURLs(this.risingEdgeURL, this.fallingEdgeURL);
    }

    public static SMessageRedstoneCtrl decode(FriendlyByteBuf buf) {
        return new SMessageRedstoneCtrl(buf.m_130281_(), new Vector3i((ByteBuf)buf), buf.m_130277_(), buf.m_130277_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension);
        this.pos.writeTo((ByteBuf)buf);
        buf.m_130070_(this.risingEdgeURL);
        buf.m_130070_(this.fallingEdgeURL);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        this.player = contextSupplier.get().getSender();
        contextSupplier.get().enqueueWork((Runnable)this);
        contextSupplier.get().setPacketHandled(true);
    }
}

