/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.client.MailBoxEntry;
import com.mrcrayfish.furniture.client.gui.widget.button.IconButton;
import com.mrcrayfish.furniture.inventory.container.PostBoxMenu;
import com.mrcrayfish.furniture.network.PacketHandler;
import com.mrcrayfish.furniture.network.message.C2SMessageSendMail;
import com.mrcrayfish.furniture.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PostBoxScreen
extends AbstractContainerScreen<PostBoxMenu> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("cfm", "textures/gui/container/post_box.png");
    private static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("cfm", "textures/gui/icons.png");
    private static final int LIST_WIDTH = 116;
    private static final int LIST_HEIGHT = 57;
    private static final int SCROLL_BAR_WIDTH = 12;
    private static final int SCROLL_BAR_HEIGHT = 15;
    private static final int ITEM_WIDTH = 116;
    private static final int ITEM_HEIGHT = 24;
    private static final int MAX_VISIBLE_ITEMS = (int)Math.ceil(2.375) + 1;
    private EditBox searchField;
    private int scroll;
    private int pressedMouseY = -1;
    private MailBoxEntry selected;
    private Button btnSend;
    private final List<MailBoxEntry> mailBoxList;
    private List<MailBoxEntry> filteredMailBoxList = new ArrayList<MailBoxEntry>();

    public PostBoxScreen(PostBoxMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.f_97727_ = 187;
        this.mailBoxList = container.getMailBoxes();
        this.filteredMailBoxList.addAll(this.mailBoxList);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchField = new EditBox(this.f_96547_, this.f_97735_ + 22, this.f_97736_ + 19, 101, 9, (Component)Component.m_237115_((String)"gui.cfm.post_box.search"));
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(32);
        this.searchField.m_94202_(0xFFFFFF);
        this.m_7787_((GuiEventListener)this.searchField);
        this.btnSend = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 147, this.f_97736_ + 53, (Component)Component.m_237115_((String)"gui.button.cfm.send_mail"), this::sendMail, ICONS_TEXTURE, 32, 0));
        this.btnSend.f_93623_ = false;
    }

    private void sendMail(Button button) {
        if (this.selected != null && !((PostBoxMenu)this.f_97732_).getMail().m_41619_()) {
            PacketHandler.getPlayChannel().sendToServer((Object)new C2SMessageSendMail(this.selected.getOwnerId(), this.selected.getMailBoxId()));
        }
    }

    public void m_181908_() {
        this.searchField.m_94120_();
        this.btnSend.f_93623_ = this.selected != null && !((PostBoxMenu)this.f_97732_).getMail().m_41619_();
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, startX, startY, 0, 0, this.f_97726_, this.f_97727_);
        if (((PostBoxMenu)this.f_97732_).getMail().m_41619_()) {
            this.m_93228_(poseStack, startX + 149, startY + 33, 116, 202, 16, 16);
        }
        this.searchField.m_86412_(poseStack, mouseX, mouseY, partialTicks);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        int startIndex;
        this.f_96547_.m_92883_(poseStack, this.f_96539_.getString(), 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92889_(poseStack, this.f_169604_, 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int scrollBarY = this.getScrollBarY(mouseY);
        int scrollBarUOffset = this.getMaxScroll() <= 0 ? 12 : 0;
        this.m_93228_(poseStack, 128, 32 + scrollBarY, 116 + scrollBarUOffset, 187, 12, 15);
        RenderUtil.scissor(this.f_97735_ + 8, this.f_97736_ + 32, 116, 57);
        int scroll = this.scroll;
        if (this.pressedMouseY != -1) {
            scroll = (int)((double)this.getMaxScroll() * ((double)scrollBarY / 42.0) + 0.5);
        }
        for (int i = startIndex = scroll / 24; i < Math.min(startIndex + MAX_VISIBLE_ITEMS, this.filteredMailBoxList.size()); ++i) {
            poseStack.m_85836_();
            poseStack.m_252880_(8.0f, 32.0f, 0.0f);
            poseStack.m_252880_(0.0f, (float)(-scroll), 0.0f);
            poseStack.m_252880_(0.0f, (float)(i * 24), 0.0f);
            MailBoxEntry entry = this.filteredMailBoxList.get(i);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean isSelected = entry == this.selected;
            this.m_93228_(poseStack, 0, 0, 0, 211 - (isSelected ? 24 : 0), 116, 24);
            if (isSelected) {
                this.m_93228_(poseStack, 96, 5, 140, 187, 14, 12);
                this.f_96547_.m_92883_(poseStack, ChatFormatting.BOLD + entry.getName(), 3.0f, 3.0f, 0xFFFF55);
                this.f_96547_.m_92883_(poseStack, entry.getOwnerName(), 3.0f, 13.0f, 0xFFFFFF);
            } else {
                this.f_96547_.m_92883_(poseStack, entry.getName(), 3.0f, 3.0f, 0xFFFFFF);
                this.f_96547_.m_92883_(poseStack, entry.getOwnerName(), 3.0f, 13.0f, 0x777777);
            }
            poseStack.m_85849_();
        }
        RenderUtil.endScissor();
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int clickedIndex;
        if (RenderUtil.isMouseInArea((int)mouseX, (int)mouseY, this.f_97735_ + 8, this.f_97736_ + 32, 116, 57) && (clickedIndex = (int)((mouseY - (double)this.f_97736_ - 32.0 + (double)this.scroll) / 24.0)) >= 0 && clickedIndex < this.filteredMailBoxList.size()) {
            MailBoxEntry entry = this.filteredMailBoxList.get(clickedIndex);
            this.selected = this.selected == entry ? null : entry;
            return true;
        }
        int scrollBarY = (int)(42.0 * ((double)this.scroll / (double)this.getMaxScroll()));
        if (this.getMaxScroll() > 0 && RenderUtil.isMouseInArea((int)mouseX, (int)mouseY, this.f_97735_ + 128, this.f_97736_ + 32 + scrollBarY, 12, 15)) {
            this.pressedMouseY = (int)mouseY;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.pressedMouseY != -1 && button == 0) {
            this.scroll = (int)((double)this.getMaxScroll() * ((double)this.getScrollBarY((int)mouseY) / 42.0) + 0.5);
            this.pressedMouseY = -1;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double speed) {
        if (RenderUtil.isMouseInArea((int)mouseX, (int)mouseY, this.f_97735_ + 8, this.f_97736_ + 32, 116, 57)) {
            this.scroll = (int)Math.max(0.0, Math.min((double)this.getMaxScroll(), (double)this.scroll - speed * 10.0));
            return true;
        }
        return false;
    }

    public boolean m_5534_(char c, int code) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_5534_(c, code)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateMailBoxList();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int key, int scanCode, int mods) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_7933_(key, scanCode, mods)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateMailBoxList();
            }
            return true;
        }
        return this.searchField.m_93696_() && this.searchField.m_94213_() && key != 256 || super.m_7933_(key, scanCode, mods);
    }

    private void updateMailBoxList() {
        if (this.searchField.m_94155_().isEmpty()) {
            this.filteredMailBoxList = this.mailBoxList;
        } else {
            Stream<MailBoxEntry> stream = this.mailBoxList.stream().filter(entry -> {
                String searchText = this.searchField.m_94155_().toLowerCase(Locale.ENGLISH).trim();
                if (entry.getName().toLowerCase().contains(searchText)) {
                    return true;
                }
                return entry.getOwnerName().toLowerCase().contains(searchText);
            });
            this.filteredMailBoxList = stream.collect(Collectors.toList());
        }
    }

    private int getScrollBarY(int mouseY) {
        int scrollOffset = 0;
        if (this.pressedMouseY != -1) {
            scrollOffset = mouseY - this.pressedMouseY;
        }
        int scrollBarY = (int)(42.0 * ((double)this.scroll / (double)this.getMaxScroll()));
        return Mth.m_14045_((int)(scrollBarY + scrollOffset), (int)0, (int)42);
    }

    private int getMaxScroll() {
        return Math.max(0, 24 * this.filteredMailBoxList.size() - 57);
    }
}

