/*
 * Decompiled with CFR 0.152.
 */
package mtr;

import java.util.function.Supplier;
import mtr.Blocks;
import mtr.Items;
import mtr.Keys;
import mtr.Registry;
import mtr.mappings.Utilities;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public interface CreativeModeTabs {
    public static final Wrapper CORE = Keys.LIFTS_ONLY ? new Wrapper() : new Wrapper(new ResourceLocation("mtr", "core"), () -> new ItemStack((ItemLike)Items.RAILWAY_DASHBOARD.get()));
    public static final Wrapper RAILWAY_FACILITIES = Keys.LIFTS_ONLY ? new Wrapper() : new Wrapper(new ResourceLocation("mtr", "railway_facilities"), () -> new ItemStack((ItemLike)Blocks.TICKET_PROCESSOR.get()));
    public static final Wrapper STATION_BUILDING_BLOCKS = Keys.LIFTS_ONLY ? new Wrapper() : new Wrapper(new ResourceLocation("mtr", "station_building_blocks"), () -> new ItemStack((ItemLike)Blocks.LOGO.get()));
    public static final Wrapper ESCALATORS_LIFTS = new Wrapper(new ResourceLocation("mtr", "escalators_lifts"), () -> new ItemStack((ItemLike)Items.ESCALATOR.get()));

    public static class Wrapper {
        public final ResourceLocation resourceLocation;
        private final Supplier<CreativeModeTab> creativeModeTabSupplier;
        private CreativeModeTab creativeModeTab;

        public Wrapper(ResourceLocation resourceLocation, Supplier<ItemStack> itemSupplier) {
            this.resourceLocation = resourceLocation;
            this.creativeModeTabSupplier = Registry.getCreativeModeTab(resourceLocation, itemSupplier);
        }

        public CreativeModeTab get() {
            if (this.creativeModeTab == null) {
                this.creativeModeTab = this.creativeModeTabSupplier.get();
            }
            return this.creativeModeTab;
        }

        public Wrapper() {
            this.resourceLocation = new ResourceLocation("");
            this.creativeModeTabSupplier = Utilities::getDefaultTab;
        }
    }
}

