/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockEscalatorBase;
import mtr.block.BlockEscalatorSide;
import mtr.block.IBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockEscalatorStep
extends BlockEscalatorBase {
    public static final BooleanProperty DIRECTION = BooleanProperty.m_61465_((String)"direction");

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        if (direction == Direction.UP && !(world.m_8055_(pos.m_7494_()).m_60734_() instanceof BlockEscalatorSide)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, newState, world, pos, posFrom);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT) {
            IBlock.onBreakCreative(world, player, pos.m_121945_(IBlock.getSideDirection(state)));
        }
        super.m_5707_(world, pos, state, player);
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEscalatorBase.EnumEscalatorOrientation orientation = (BlockEscalatorBase.EnumEscalatorOrientation)((Object)IBlock.getStatePropertySafe(state, ORIENTATION));
        if (orientation == BlockEscalatorBase.EnumEscalatorOrientation.FLAT || orientation == BlockEscalatorBase.EnumEscalatorOrientation.TRANSITION_BOTTOM) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
        }
        return Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)super.m_5939_(state, world, pos, context), (BooleanOp)BooleanOp.f_82689_);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        boolean direction = (Boolean)IBlock.getStatePropertySafe(state, DIRECTION);
        float speed = 0.1f;
        switch (facing) {
            case NORTH: {
                entity.m_5997_(0.0, 0.0, direction ? (double)-0.1f : (double)0.1f);
                break;
            }
            case EAST: {
                entity.m_5997_(direction ? (double)0.1f : (double)-0.1f, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                entity.m_5997_(0.0, 0.0, direction ? (double)0.1f : (double)-0.1f);
                break;
            }
            case WEST: {
                entity.m_5997_(direction ? (double)-0.1f : (double)0.1f, 0.0, 0.0);
                break;
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            boolean direction = (Boolean)IBlock.getStatePropertySafe(state, DIRECTION) == false;
            Direction blockFacing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
            this.update(world, pos, blockFacing, direction);
            this.update(world, pos, blockFacing.m_122424_(), direction);
            BlockPos sidePos = pos.m_121945_(IBlock.getSideDirection(state));
            if (this.isStep(world, sidePos)) {
                BlockEscalatorStep block = (BlockEscalatorStep)world.m_8055_(sidePos).m_60734_();
                block.update(world, sidePos, blockFacing, direction);
                block.update(world, sidePos, blockFacing.m_122424_(), direction);
            }
        });
    }

    @Override
    public boolean softenLanding() {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, DIRECTION, ORIENTATION, SIDE});
    }

    private void update(Level world, BlockPos pos, Direction offset, boolean direction) {
        world.m_46597_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)DIRECTION, (Comparable)Boolean.valueOf(direction)));
        BlockPos offsetPos = pos.m_121945_(offset);
        if (this.isStep(world, offsetPos)) {
            this.update(world, offsetPos, offset, direction);
        }
        if (this.isStep(world, offsetPos.m_7494_())) {
            this.update(world, offsetPos.m_7494_(), offset, direction);
        }
        if (this.isStep(world, offsetPos.m_7495_())) {
            this.update(world, offsetPos.m_7495_(), offset, direction);
        }
    }

    private boolean isStep(Level world, BlockPos pos) {
        Block block = world.m_8055_(pos).m_60734_();
        return block instanceof BlockEscalatorStep;
    }
}

