/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.List;
import mtr.block.BlockDirectionalDoubleBlockBase;
import mtr.block.IBlock;
import mtr.mappings.Text;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockGlassFence
extends BlockDirectionalDoubleBlockBase {
    public static final IntegerProperty NUMBER = IntegerProperty.m_61631_((String)"number", (int)1, (int)7);

    public BlockGlassFence() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f).m_60955_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        if (IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER) {
            return IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 3.0, 3.0, facing);
        }
        return IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 16.0, 3.0, facing);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        return Shapes.m_83110_((VoxelShape)this.m_5940_(state, world, pos, context), (VoxelShape)IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 8.0, 3.0, facing));
    }

    public VoxelShape m_5909_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83040_();
    }

    public void m_5871_(ItemStack stack, BlockGetter blockGetter, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Text.translatable("tooltip." + stack.m_41720_().m_5524_(), new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, HALF, NUMBER});
    }

    @Override
    protected BlockState getAdditionalState(BlockPos pos, Direction facing) {
        return (BlockState)this.m_49966_().m_61124_((Property)NUMBER, (Comparable)Integer.valueOf(BlockGlassFence.getNumber(pos, facing)));
    }

    private static int getNumber(BlockPos pos, Direction facing) {
        int x = (pos.m_123341_() % 7 + 7) % 7;
        int z = (pos.m_123343_() % 7 + 7) % 7;
        if (facing == Direction.NORTH || facing == Direction.EAST) {
            return (x + z) % 7 + 1;
        }
        return (-x - z) % 7 + 7;
    }
}

