/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.List;
import mtr.BlockEntityTypes;
import mtr.block.IBlock;
import mtr.data.RailAngle;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockNode
extends BlockDirectionalMapper {
    public final TransportMode transportMode;
    public static final BooleanProperty FACING = BooleanProperty.m_61465_((String)"facing");
    public static final BooleanProperty IS_22_5 = BooleanProperty.m_61465_((String)"is_22_5");
    public static final BooleanProperty IS_45 = BooleanProperty.m_61465_((String)"is_45");
    public static final BooleanProperty IS_CONNECTED = BooleanProperty.m_61465_((String)"is_connected");

    public BlockNode(TransportMode transportMode) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60978_(2.0f).m_60955_());
        this.transportMode = transportMode;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_22_5, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_45, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        int quadrant = RailAngle.getQuadrant(ctx.m_7074_(), true);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Boolean.valueOf(quadrant % 8 >= 4))).m_61124_((Property)IS_45, (Comparable)Boolean.valueOf(quadrant % 4 >= 2))).m_61124_((Property)IS_22_5, (Comparable)Boolean.valueOf(quadrant % 2 >= 1))).m_61124_((Property)IS_CONNECTED, (Comparable)Boolean.valueOf(false));
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        RailwayData railwayData;
        if (!world.f_46443_ && (railwayData = RailwayData.getInstance(world)) != null) {
            railwayData.removeNode(player, pos, this.transportMode);
            PacketTrainDataGuiServer.removeNodeS2C(world, pos);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return (Boolean)IBlock.getStatePropertySafe(state, IS_CONNECTED) != false ? Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0) : Shapes.m_83144_();
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83040_();
    }

    public PushReaction m_5537_(BlockState blockState) {
        return PushReaction.BLOCK;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, IS_22_5, IS_45, IS_CONNECTED});
    }

    public static void resetRailNode(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof BlockNode) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)IS_CONNECTED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static float getAngle(BlockState state) {
        return (float)((Boolean)IBlock.getStatePropertySafe(state, FACING) != false ? 0 : 90) + ((Boolean)IBlock.getStatePropertySafe(state, IS_22_5) != false ? 22.5f : 0.0f) + (float)((Boolean)IBlock.getStatePropertySafe(state, IS_45) != false ? 45 : 0);
    }

    public static class BlockContinuousMovementNode
    extends BlockNode {
        public final boolean upper;
        public final boolean isStation;

        public BlockContinuousMovementNode(boolean upper, boolean isStation) {
            super(TransportMode.CABLE_CAR);
            this.upper = upper;
            this.isStation = isStation;
        }

        @Override
        public BlockState m_5573_(BlockPlaceContext ctx) {
            int quadrant = RailAngle.getQuadrant(ctx.m_7074_(), false);
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Boolean.valueOf(quadrant % 4 >= 2))).m_61124_((Property)IS_45, (Comparable)Boolean.valueOf(quadrant % 2 >= 1))).m_61124_((Property)IS_22_5, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_CONNECTED, (Comparable)Boolean.valueOf(false));
        }

        @Override
        public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
            return Block.m_49796_((double)0.0, (double)(this.upper ? 8.0 : 0.0), (double)0.0, (double)16.0, (double)(this.upper ? 16.0 : 8.0), (double)16.0);
        }

        public void m_5871_(ItemStack itemStack, BlockGetter blockGetter, List<Component> tooltip, TooltipFlag tooltipFlag) {
            String[] strings;
            for (String string : strings = Text.translatable("tooltip.mtr.cable_car_node" + (this.isStation ? "_station" : ""), new Object[0]).getString().split("\n")) {
                tooltip.add((Component)Text.literal(string).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
            }
        }
    }

    public static class TileEntityBoatNode
    extends BlockEntityMapper {
        public TileEntityBoatNode(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.BOAT_NODE_TILE_ENTITY.get(), pos, state);
        }
    }

    public static class BlockBoatNode
    extends BlockNode
    implements EntityBlockMapper {
        public BlockBoatNode() {
            super(TransportMode.BOAT);
        }

        public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
            if (state.m_60710_((LevelReader)world, pos)) {
                return state;
            }
            return Blocks.f_50016_.m_49966_();
        }

        public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
            BlockPos posBelow = pos.m_7495_();
            return (world.m_6425_(posBelow).m_76152_() != Fluids.f_76191_ || world.m_8055_(posBelow).m_60767_() == Material.f_76276_) && world.m_6425_(pos).m_76152_() == Fluids.f_76191_;
        }

        @Override
        public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
            return new TileEntityBoatNode(pos, state);
        }
    }
}

