/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.client.ClientData;
import mtr.client.CustomResources;
import mtr.client.DoorAnimationType;
import mtr.client.IDrawing;
import mtr.client.IResourcePackCreatorProperties;
import mtr.client.ResourcePackCreatorProperties;
import mtr.client.ScrollingText;
import mtr.data.EnumHelper;
import mtr.data.IGui;
import mtr.data.Route;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.mappings.ModelDataWrapper;
import mtr.mappings.ModelMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelTrainBase;
import mtr.screen.ResourcePackCreatorScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;

public class DynamicTrainModel
extends ModelTrainBase
implements IResourcePackCreatorProperties {
    private float doorLeftX;
    private float doorRightX;
    private float doorLeftZ;
    private float doorRightZ;
    private boolean head1IsFront;
    public final Map<String, ModelMapper> parts = new HashMap<String, ModelMapper>();
    public final Map<String, Set<PartInfo>> partsInfo = new HashMap<String, Set<PartInfo>>();
    public final JsonObject properties;
    public final int doorMax;
    private final Map<String, Boolean> whitelistBlacklistCache = new HashMap<String, Boolean>();

    public DynamicTrainModel(JsonObject model, JsonObject properties, DoorAnimationType doorAnimationType) {
        super(doorAnimationType, false);
        try {
            JsonObject resolution = model.getAsJsonObject("resolution");
            int textureWidth = resolution.get("width").getAsInt();
            int textureHeight = resolution.get("height").getAsInt();
            ModelDataWrapper modelDataWrapper = new ModelDataWrapper((Model)this, textureWidth, textureHeight);
            HashMap elementsByKey = new HashMap();
            model.getAsJsonArray("elements").forEach(element -> elementsByKey.put(element.getAsJsonObject().get("uuid").getAsString(), new ModelMapper(modelDataWrapper)));
            HashMap uuidToParentString = new HashMap();
            model.getAsJsonArray("outliner").forEach(element -> {
                JsonObject elementObject = element.getAsJsonObject();
                this.parts.put(elementObject.get("name").getAsString(), this.addChildren(elementObject, elementsByKey, uuidToParentString, modelDataWrapper));
            });
            model.getAsJsonArray("elements").forEach(element -> {
                JsonObject elementObject = element.getAsJsonObject();
                String uuid = elementObject.get("uuid").getAsString();
                ModelMapper child = (ModelMapper)elementsByKey.get(uuid);
                Double[] origin = new Double[]{0.0, 0.0, 0.0};
                DynamicTrainModel.getArrayFromValue(origin, elementObject, "origin", JsonElement::getAsDouble);
                child.setPos(-origin[0].floatValue(), -origin[1].floatValue(), origin[2].floatValue());
                Double[] rotation = new Double[]{0.0, 0.0, 0.0};
                DynamicTrainModel.getArrayFromValue(rotation, elementObject, "rotation", JsonElement::getAsDouble);
                DynamicTrainModel.setRotationAngle(child, -((float)Math.toRadians(rotation[0])), -((float)Math.toRadians(rotation[1])), (float)Math.toRadians(rotation[2]));
                Integer[] uvOffset = new Integer[]{0, 0};
                DynamicTrainModel.getArrayFromValue(uvOffset, elementObject, "uv_offset", JsonElement::getAsInt);
                Double[] posFrom = new Double[]{0.0, 0.0, 0.0};
                DynamicTrainModel.getArrayFromValue(posFrom, elementObject, "from", JsonElement::getAsDouble);
                Double[] posTo = new Double[]{0.0, 0.0, 0.0};
                DynamicTrainModel.getArrayFromValue(posTo, elementObject, "to", JsonElement::getAsDouble);
                double inflate = elementObject.has("inflate") ? elementObject.get("inflate").getAsDouble() : 0.0;
                boolean mirror = elementObject.has("shade") && !elementObject.get("shade").getAsBoolean();
                child.texOffs(uvOffset[0], uvOffset[1]).addBox(origin[0].floatValue() - posTo[0].floatValue(), origin[1].floatValue() - posTo[1].floatValue(), posFrom[2].floatValue() - origin[2].floatValue(), Math.round(posTo[0].floatValue() - posFrom[0].floatValue()), Math.round(posTo[1].floatValue() - posFrom[1].floatValue()), Math.round(posTo[2].floatValue() - posFrom[2].floatValue()), (float)inflate, mirror);
                float width = (float)Math.abs(posTo[0] - posFrom[0]) / 16.0f;
                float height = (float)Math.abs(posTo[1] - posFrom[1]) / 16.0f;
                if (width > 0.0f && height > 0.0f) {
                    String parentName = (String)uuidToParentString.get(uuid);
                    if (!this.partsInfo.containsKey(parentName)) {
                        this.partsInfo.put(parentName, new HashSet());
                    }
                    this.partsInfo.get(parentName).add(new PartInfo(origin[0] / 16.0, origin[1] / 16.0, origin[2] / 16.0, ((posFrom[0] + posTo[0]) / 2.0 - origin[0]) / 16.0, ((posFrom[1] + posTo[1]) / 2.0 - origin[1]) / 16.0, (posFrom[2] - origin[2]) / 16.0, -rotation[0].floatValue(), -rotation[1].floatValue(), rotation[2].floatValue(), width, height));
                }
            });
            modelDataWrapper.setModelPart(textureWidth, textureHeight);
            this.parts.values().forEach(part -> {
                part.setPos(0.0f, 0.0f, 0.0f);
                part.texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0, 0, 0, 0.0f, false);
                part.setModelPart();
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IResourcePackCreatorProperties.checkSchema(properties);
        this.properties = properties;
        this.doorMax = properties.get("door_max").getAsInt();
    }

    @Override
    protected void render(PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, int currentCar, int trainCars, boolean head1IsFront, boolean renderDetails) {
        this.doorLeftX = doorLeftX;
        this.doorRightX = doorRightX;
        this.doorLeftZ = doorLeftZ;
        this.doorRightZ = doorRightZ;
        this.head1IsFront = head1IsFront;
        this.iterateParts(currentCar, trainCars, partObject -> {
            if (!renderDetails && partObject.get("skip_rendering_if_too_far").getAsBoolean() || !renderStage.toString().equals(partObject.get("stage").getAsString().toUpperCase(Locale.ENGLISH)) || this.shouldSkipRender((JsonObject)partObject)) {
                return;
            }
            ModelMapper part = this.parts.get(partObject.get("name").getAsString());
            if (part != null) {
                float xOffset = this.getOffsetX((JsonObject)partObject);
                float zOffset = this.getOffsetZ((JsonObject)partObject);
                boolean mirror = partObject.get("mirror").getAsBoolean();
                partObject.getAsJsonArray("positions").forEach(positionElement -> {
                    float x = positionElement.getAsJsonArray().get(0).getAsFloat();
                    float z = positionElement.getAsJsonArray().get(1).getAsFloat();
                    if (mirror) {
                        DynamicTrainModel.renderOnceFlipped(part, matrices, vertices, light, x - xOffset, z - zOffset);
                    } else {
                        DynamicTrainModel.renderOnce(part, matrices, vertices, light, x + xOffset, z + zOffset);
                    }
                });
            }
        });
    }

    @Override
    protected void renderTextDisplays(PoseStack matrices, MultiBufferSource vertexConsumers, Font font, MultiBufferSource.BufferSource immediate, Route thisRoute, Route nextRoute, Station thisStation, Station nextStation, Station lastStation, String customDestination, int car, int totalCars, boolean atPlatform, List<ScrollingText> scrollingTexts) {
        int[] scrollIndex = new int[]{0};
        this.iterateParts(car, totalCars, partObject -> {
            if (this.shouldSkipRender((JsonObject)partObject)) {
                return;
            }
            String partName = partObject.get("name").getAsString();
            if (!this.partsInfo.containsKey(partName) || !partObject.has("display")) {
                return;
            }
            boolean mirror = partObject.get("mirror").getAsBoolean();
            partObject.getAsJsonArray("positions").forEach(positionElement -> {
                String tempText1;
                float x = positionElement.getAsJsonArray().get(0).getAsFloat() + this.getOffsetX((JsonObject)partObject);
                float z = positionElement.getAsJsonArray().get(1).getAsFloat() + this.getOffsetZ((JsonObject)partObject);
                String destinationString = this.getDestinationString(lastStation, customDestination, ModelTrainBase.TextSpacingType.NORMAL, false);
                JsonObject displayObject = partObject.getAsJsonObject("display");
                int colorCjk = CustomResources.colorStringToInt(displayObject.get("color_cjk").getAsString()) | 0xFF000000;
                int color = CustomResources.colorStringToInt(displayObject.get("color").getAsString()) | 0xFF000000;
                float cjkSizeRatio = displayObject.get("cjk_size_ratio").getAsFloat();
                boolean shouldScroll = displayObject.get("should_scroll").getAsBoolean();
                ResourcePackCreatorProperties.DisplayType displayType = EnumHelper.valueOf(ResourcePackCreatorProperties.DisplayType.DESTINATION, displayObject.get("type").getAsString());
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof ResourcePackCreatorScreen) {
                    String testText = ((ResourcePackCreatorScreen)screen).getTestText();
                    Station testStation = new Station();
                    Route testRoute = new Route(TransportMode.TRAIN);
                    testStation.name = testText;
                    testRoute.name = testText;
                    switch (displayType) {
                        case DESTINATION: 
                        case ROUTE_NUMBER: 
                        case NEXT_STATION_PLAIN: {
                            tempText1 = testText;
                            break;
                        }
                        case NEXT_STATION_KCR: {
                            tempText1 = DynamicTrainModel.getHongKongNextStationString(testStation, testStation, atPlatform, true);
                            break;
                        }
                        case NEXT_STATION_MTR: {
                            tempText1 = DynamicTrainModel.getHongKongNextStationString(testStation, testStation, atPlatform, false);
                            break;
                        }
                        case NEXT_STATION_UK: {
                            tempText1 = DynamicTrainModel.getLondonNextStationString(testRoute, testRoute, testStation, testStation, testStation, testText, atPlatform);
                            break;
                        }
                        default: {
                            tempText1 = "";
                            break;
                        }
                    }
                } else {
                    switch (displayType) {
                        case DESTINATION: {
                            tempText1 = destinationString;
                            break;
                        }
                        case ROUTE_NUMBER: {
                            tempText1 = thisRoute == null ? "" : thisRoute.lightRailRouteNumber;
                            break;
                        }
                        case NEXT_STATION_PLAIN: {
                            Station station = atPlatform ? thisStation : nextStation;
                            tempText1 = station == null ? Text.translatable("gui.mtr.untitled", new Object[0]).getString() : station.name;
                            break;
                        }
                        case NEXT_STATION_KCR: {
                            tempText1 = DynamicTrainModel.getHongKongNextStationString(thisStation, nextStation, atPlatform, true);
                            break;
                        }
                        case NEXT_STATION_MTR: {
                            tempText1 = DynamicTrainModel.getHongKongNextStationString(thisStation, nextStation, atPlatform, false);
                            break;
                        }
                        case NEXT_STATION_UK: {
                            tempText1 = DynamicTrainModel.getLondonNextStationString(thisRoute, nextRoute, thisStation, nextStation, lastStation, destinationString, atPlatform);
                            break;
                        }
                        default: {
                            tempText1 = "";
                        }
                    }
                }
                String tempText2 = displayObject.get("force_upper_case").getAsBoolean() ? tempText1.toUpperCase(Locale.ENGLISH) : tempText1;
                String text = displayObject.get("force_single_line").getAsBoolean() ? IGui.formatStationName(tempText2) : tempText2;
                this.partsInfo.get(partName).forEach(partInfo -> {
                    float width = partInfo.width - displayObject.get("x_padding").getAsFloat();
                    float height = partInfo.height - displayObject.get("y_padding").getAsFloat();
                    while (shouldScroll && scrollingTexts.size() <= scrollIndex[0]) {
                        scrollingTexts.add(new ScrollingText(width, height, 4, (double)height < 0.2));
                    }
                    matrices.m_85836_();
                    matrices.m_252880_(x / 16.0f, 0.0f, z / 16.0f);
                    UtilitiesClient.rotateYDegrees(matrices, mirror ? 180.0f : 0.0f);
                    matrices.m_85837_(-partInfo.originX, -partInfo.originY, partInfo.originZ);
                    UtilitiesClient.rotateZDegrees(matrices, partInfo.rotationZ);
                    UtilitiesClient.rotateYDegrees(matrices, partInfo.rotationY);
                    UtilitiesClient.rotateXDegrees(matrices, partInfo.rotationX);
                    matrices.m_85837_(-partInfo.offsetX, -partInfo.offsetY, partInfo.offsetZ - (double)0.003125f);
                    if (shouldScroll) {
                        matrices.m_252880_(-width / 2.0f, -height / 2.0f, 0.0f);
                        ((ScrollingText)scrollingTexts.get(scrollIndex[0])).changeImage(text.isEmpty() ? null : ClientData.DATA_CACHE.getPixelatedText(text, color, Integer.MAX_VALUE, cjkSizeRatio, (double)height < 0.2));
                        ((ScrollingText)scrollingTexts.get(scrollIndex[0])).setVertexConsumer(vertexConsumers);
                        ((ScrollingText)scrollingTexts.get(scrollIndex[0])).scrollText(matrices);
                        scrollIndex[0] = scrollIndex[0] + 1;
                    } else {
                        IDrawing.drawStringWithFont(matrices, Minecraft.m_91087_().f_91062_, immediate, text, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, IGui.HorizontalAlignment.CENTER, 0.0f, 0.0f, width, height, 1.0f, colorCjk, color, cjkSizeRatio < 0.0f ? 1.0f / (1.0f - cjkSizeRatio) : 1.0f + cjkSizeRatio, false, 0xF000F0, null);
                    }
                    matrices.m_85849_();
                });
            });
        });
    }

    @Override
    public int getDoorMax() {
        return this.doorMax;
    }

    private ModelMapper addChildren(JsonObject jsonObject, Map<String, ModelMapper> children, Map<String, String> uuidToParentString, ModelDataWrapper modelDataWrapper) {
        ModelMapper part = new ModelMapper(modelDataWrapper);
        jsonObject.getAsJsonArray("children").forEach(child -> {
            boolean hasMoreChildren = child.isJsonObject();
            if (hasMoreChildren) {
                part.addChild(this.addChildren(child.getAsJsonObject(), children, uuidToParentString, modelDataWrapper));
            } else {
                part.addChild((ModelMapper)children.get(child.getAsString()));
                uuidToParentString.put(child.getAsString(), jsonObject.get("name").getAsString());
            }
        });
        return part;
    }

    private int matchesFilter(String[] filters, int currentCar, int trainCars) {
        int strength = filters.length == 0 ? 1 : 0;
        for (String filter : filters) {
            if (filter.isEmpty()) continue;
            if (filter.contains("%")) {
                try {
                    int additional;
                    String[] filterSplit = filter.split("\\+");
                    int multiple = Integer.parseInt(filterSplit[0].replace("%", ""));
                    int n = additional = filterSplit.length == 1 ? 0 : Integer.parseInt(filterSplit[1]);
                    if ((currentCar + 1 + additional) % multiple != 0) continue;
                    strength = 2;
                }
                catch (Exception filterSplit) {}
                continue;
            }
            try {
                int car = Integer.parseInt(filter);
                if (car != currentCar + 1 && car != currentCar - trainCars) continue;
                return 3;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return strength;
    }

    private static <T> void getArrayFromValue(T[] array, JsonObject jsonObject, String key, Function<JsonElement, T> function) {
        if (jsonObject.has(key)) {
            JsonArray jsonArray = jsonObject.getAsJsonArray(key);
            for (int i = 0; i < array.length; ++i) {
                array[i] = function.apply(jsonArray.get(i));
            }
        }
    }

    private void iterateParts(int currentCar, int trainCars, Consumer<JsonObject> callback) {
        this.properties.getAsJsonArray("parts").forEach(partElement -> {
            boolean skip;
            JsonObject partObject = partElement.getAsJsonObject();
            String whitelistedCars = partObject.get("whitelisted_cars").getAsString();
            String blacklistedCars = partObject.get("blacklisted_cars").getAsString();
            String key = String.format("%s|%s|%s|%s", trainCars, currentCar, whitelistedCars, blacklistedCars);
            if (this.whitelistBlacklistCache.containsKey(key)) {
                skip = this.whitelistBlacklistCache.get(key);
            } else {
                String[] whitelistedCarsFilters = whitelistedCars.split(",");
                String[] blacklistedCarsFilters = blacklistedCars.split(",");
                skip = this.matchesFilter(blacklistedCarsFilters, currentCar, trainCars) > this.matchesFilter(whitelistedCarsFilters, currentCar, trainCars);
                this.whitelistBlacklistCache.put(key, skip);
            }
            if (skip) {
                return;
            }
            callback.accept(partObject);
        });
    }

    private boolean shouldSkipRender(JsonObject partObject) {
        switch (EnumHelper.valueOf(ResourcePackCreatorProperties.RenderCondition.ALL, partObject.get("render_condition").getAsString())) {
            case DOORS_OPEN: {
                return this.doorLeftZ == 0.0f && this.doorRightZ == 0.0f;
            }
            case DOORS_CLOSED: {
                return this.doorLeftZ > 0.0f || this.doorRightZ > 0.0f;
            }
            case DOOR_LEFT_OPEN: {
                return this.doorLeftZ == 0.0f;
            }
            case DOOR_RIGHT_OPEN: {
                return this.doorRightZ == 0.0f;
            }
            case DOOR_LEFT_CLOSED: {
                return this.doorLeftZ > 0.0f;
            }
            case DOOR_RIGHT_CLOSED: {
                return this.doorRightZ > 0.0f;
            }
            case MOVING_FORWARDS: {
                return !this.head1IsFront;
            }
            case MOVING_BACKWARDS: {
                return this.head1IsFront;
            }
        }
        return false;
    }

    private float getOffsetX(JsonObject partObject) {
        switch (EnumHelper.valueOf(ResourcePackCreatorProperties.DoorOffset.NONE, partObject.get("door_offset").getAsString())) {
            case LEFT_POSITIVE: 
            case LEFT_NEGATIVE: {
                return -this.doorLeftX;
            }
            case RIGHT_POSITIVE: 
            case RIGHT_NEGATIVE: {
                return this.doorRightX;
            }
        }
        return 0.0f;
    }

    private float getOffsetZ(JsonObject partObject) {
        switch (EnumHelper.valueOf(ResourcePackCreatorProperties.DoorOffset.NONE, partObject.get("door_offset").getAsString())) {
            case LEFT_POSITIVE: {
                return this.doorLeftZ;
            }
            case RIGHT_POSITIVE: {
                return this.doorRightZ;
            }
            case LEFT_NEGATIVE: {
                return -this.doorLeftZ;
            }
            case RIGHT_NEGATIVE: {
                return -this.doorRightZ;
            }
        }
        return 0.0f;
    }

    private static class PartInfo {
        private final double originX;
        private final double originY;
        private final double originZ;
        private final double offsetX;
        private final double offsetY;
        private final double offsetZ;
        private final float rotationX;
        private final float rotationY;
        private final float rotationZ;
        private final float width;
        private final float height;

        private PartInfo(double originX, double originY, double originZ, double offsetX, double offsetY, double offsetZ, float rotationX, float rotationY, float rotationZ, float width, float height) {
            this.originX = originX;
            this.originY = originY;
            this.originZ = originZ;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.rotationX = rotationX;
            this.rotationY = rotationY;
            this.rotationZ = rotationZ;
            this.width = width;
            this.height = height;
        }
    }
}

