/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import mtr.client.DoorAnimationType;
import mtr.client.IResourcePackCreatorProperties;
import mtr.client.ResourcePackCreatorProperties;
import mtr.mappings.ModelDataWrapper;
import mtr.mappings.ModelMapper;
import mtr.model.ModelDoorOverlay;
import mtr.model.ModelDoorOverlayTopBase;
import mtr.model.ModelSimpleTrainBase;
import mtr.model.ModelTrainBase;
import net.minecraft.client.model.Model;

public class DynamicTrainModelLegacy
extends ModelSimpleTrainBase<DynamicTrainModelLegacy>
implements IResourcePackCreatorProperties {
    private final Map<String, ModelMapper> parts = new HashMap<String, ModelMapper>();
    private final JsonObject properties;
    private final int doorMax;

    public DynamicTrainModelLegacy(JsonObject model, JsonObject properties, DoorAnimationType doorAnimationType) {
        super(doorAnimationType, false);
        try {
            JsonObject resolution = model.getAsJsonObject("resolution");
            int textureWidth = resolution.get("width").getAsInt();
            int textureHeight = resolution.get("height").getAsInt();
            ModelDataWrapper modelDataWrapper = new ModelDataWrapper((Model)this, textureWidth, textureHeight);
            HashMap elementsByKey = new HashMap();
            model.getAsJsonArray("elements").forEach(element -> elementsByKey.put(element.getAsJsonObject().get("uuid").getAsString(), new ModelMapper(modelDataWrapper)));
            model.getAsJsonArray("outliner").forEach(element -> {
                JsonObject elementObject = element.getAsJsonObject();
                this.parts.put(elementObject.get("name").getAsString(), this.addChildren(elementObject, elementsByKey, modelDataWrapper));
            });
            model.getAsJsonArray("elements").forEach(element -> {
                JsonObject elementObject = element.getAsJsonObject();
                ModelMapper child = (ModelMapper)elementsByKey.get(elementObject.get("uuid").getAsString());
                Double[] origin = new Double[]{0.0, 0.0, 0.0};
                DynamicTrainModelLegacy.getArrayFromValue(origin, elementObject, "origin", JsonElement::getAsDouble);
                child.setPos(-origin[0].floatValue(), -origin[1].floatValue(), origin[2].floatValue());
                Double[] rotation = new Double[]{0.0, 0.0, 0.0};
                DynamicTrainModelLegacy.getArrayFromValue(rotation, elementObject, "rotation", JsonElement::getAsDouble);
                DynamicTrainModelLegacy.setRotationAngle(child, -((float)Math.toRadians(rotation[0])), -((float)Math.toRadians(rotation[1])), (float)Math.toRadians(rotation[2]));
                Integer[] uvOffset = new Integer[]{0, 0};
                DynamicTrainModelLegacy.getArrayFromValue(uvOffset, elementObject, "uv_offset", JsonElement::getAsInt);
                Double[] posFrom = new Double[]{0.0, 0.0, 0.0};
                DynamicTrainModelLegacy.getArrayFromValue(posFrom, elementObject, "from", JsonElement::getAsDouble);
                Double[] posTo = new Double[]{0.0, 0.0, 0.0};
                DynamicTrainModelLegacy.getArrayFromValue(posTo, elementObject, "to", JsonElement::getAsDouble);
                double inflate = elementObject.has("inflate") ? elementObject.get("inflate").getAsDouble() : 0.0;
                boolean mirror = elementObject.has("shade") && !elementObject.get("shade").getAsBoolean();
                child.texOffs(uvOffset[0], uvOffset[1]).addBox(origin[0].floatValue() - posTo[0].floatValue(), origin[1].floatValue() - posTo[1].floatValue(), posFrom[2].floatValue() - origin[2].floatValue(), Math.round(posTo[0].floatValue() - posFrom[0].floatValue()), Math.round(posTo[1].floatValue() - posFrom[1].floatValue()), Math.round(posTo[2].floatValue() - posFrom[2].floatValue()), (float)inflate, mirror);
            });
            modelDataWrapper.setModelPart(textureWidth, textureHeight);
            this.parts.values().forEach(part -> {
                part.setPos(0.0f, 0.0f, 0.0f);
                part.texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0, 0, 0, 0.0f, false);
                part.setModelPart();
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.properties = properties;
        this.doorMax = DynamicTrainModelLegacy.getOrDefault(properties, "door_max", 14, JsonElement::getAsInt);
    }

    @Override
    public DynamicTrainModelLegacy createNew(DoorAnimationType doorAnimationType, boolean renderDoorOverlay) {
        return this;
    }

    @Override
    protected void renderWindowPositions(PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, int position, boolean renderDetails, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, boolean isEnd1Head, boolean isEnd2Head) {
    }

    @Override
    protected void renderDoorPositions(PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, int position, boolean renderDetails, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, boolean isEnd1Head, boolean isEnd2Head) {
        this.renderParts("parts_normal", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        if (doorLeftZ > 0.0f || doorRightZ > 0.0f) {
            this.renderParts("parts_door_opened", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        } else {
            this.renderParts("parts_door_closed", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        }
    }

    @Override
    protected void renderHeadPosition1(PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, int position, boolean renderDetails, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, boolean useHeadlights) {
        this.renderParts("parts_head_1", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        if (useHeadlights) {
            this.renderParts("parts_head_1_headlights", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        } else {
            this.renderParts("parts_head_1_tail_lights", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        }
    }

    @Override
    protected void renderHeadPosition2(PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, int position, boolean renderDetails, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, boolean useHeadlights) {
        this.renderParts("parts_head_2", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        if (useHeadlights) {
            this.renderParts("parts_head_2_headlights", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        } else {
            this.renderParts("parts_head_2_tail_lights", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
        }
    }

    @Override
    protected void renderEndPosition1(PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, int position, boolean renderDetails, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ) {
        this.renderParts("parts_end_1", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
    }

    @Override
    protected void renderEndPosition2(PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, int position, boolean renderDetails, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ) {
        this.renderParts("parts_end_2", matrices, vertices, renderStage, light, renderDetails, doorLeftZ, doorRightZ);
    }

    @Override
    protected ModelDoorOverlay getModelDoorOverlay() {
        return null;
    }

    @Override
    protected ModelDoorOverlayTopBase getModelDoorOverlayTop() {
        return null;
    }

    @Override
    protected int[] getWindowPositions() {
        return new int[]{0};
    }

    @Override
    protected int[] getDoorPositions() {
        return new int[]{0};
    }

    @Override
    protected int[] getEndPositions() {
        return new int[]{0, 0};
    }

    @Override
    public int getDoorMax() {
        return this.doorMax;
    }

    private ModelMapper addChildren(JsonObject jsonObject, Map<String, ModelMapper> children, ModelDataWrapper modelDataWrapper) {
        ModelMapper part = new ModelMapper(modelDataWrapper);
        jsonObject.getAsJsonArray("children").forEach(child -> part.addChild(child.isJsonObject() ? this.addChildren(child.getAsJsonObject(), children, modelDataWrapper) : (ModelMapper)children.get(child.getAsString())));
        return part;
    }

    private void renderParts(String category, PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, boolean renderDetails, float doorLeftZ, float doorRightZ) {
        if (!this.properties.has(category)) {
            return;
        }
        this.properties.getAsJsonArray(category).forEach(partElement -> {
            ModelMapper part;
            boolean shouldRender;
            JsonObject partObject = partElement.getAsJsonObject();
            boolean bl = shouldRender = renderDetails || !partObject.has("skip_rendering_if_too_far") || !partObject.get("skip_rendering_if_too_far").getAsBoolean();
            if (shouldRender && renderStage.toString().equals(partObject.get("stage").getAsString().toUpperCase(Locale.ENGLISH)) && (part = this.parts.get(partObject.get("part_name").getAsString())) != null) {
                float zOffset;
                if (partObject.has("door_offset_z")) {
                    switch (partObject.get("door_offset_z").getAsString()) {
                        case "left": {
                            zOffset = doorLeftZ;
                            break;
                        }
                        case "right": {
                            zOffset = doorRightZ;
                            break;
                        }
                        case "left_negative": {
                            zOffset = -doorLeftZ;
                            break;
                        }
                        case "right_negative": {
                            zOffset = -doorRightZ;
                            break;
                        }
                        default: {
                            zOffset = 0.0f;
                            break;
                        }
                    }
                } else {
                    zOffset = 0.0f;
                }
                if (partObject.has("positions")) {
                    partObject.getAsJsonArray("positions").forEach(positionElement -> {
                        float x = positionElement.getAsJsonArray().get(0).getAsFloat();
                        float z = positionElement.getAsJsonArray().get(1).getAsFloat();
                        DynamicTrainModelLegacy.renderOnce(part, matrices, vertices, light, x, z + zOffset);
                    });
                }
                if (partObject.has("positions_flipped")) {
                    partObject.getAsJsonArray("positions_flipped").forEach(positionElement -> {
                        float x = positionElement.getAsJsonArray().get(0).getAsFloat();
                        float z = positionElement.getAsJsonArray().get(1).getAsFloat();
                        DynamicTrainModelLegacy.renderOnceFlipped(part, matrices, vertices, light, x, z - zOffset);
                    });
                }
            }
        });
    }

    private static <T> void getArrayFromValue(T[] array, JsonObject jsonObject, String key, Function<JsonElement, T> function) {
        if (jsonObject.has(key)) {
            JsonArray jsonArray = jsonObject.getAsJsonArray(key);
            for (int i = 0; i < array.length; ++i) {
                array[i] = function.apply(jsonArray.get(i));
            }
        }
    }

    public static void migrateOldSchema(JsonObject jsonObject) {
        try {
            JsonArray partsArray = jsonObject.has("parts") ? jsonObject.getAsJsonArray("parts") : new JsonArray();
            DynamicTrainModelLegacy.addParts(jsonObject, partsArray, "parts_normal", ResourcePackCreatorProperties.RenderCondition.ALL, "", "");
            DynamicTrainModelLegacy.addParts(jsonObject, partsArray, "parts_head_1", ResourcePackCreatorProperties.RenderCondition.ALL, "1", "%1");
            DynamicTrainModelLegacy.addParts(jsonObject, partsArray, "parts_head_2", ResourcePackCreatorProperties.RenderCondition.ALL, "-1", "%1");
            DynamicTrainModelLegacy.addParts(jsonObject, partsArray, "parts_head_1_headlights", ResourcePackCreatorProperties.RenderCondition.MOVING_FORWARDS, "1", "%1");
            DynamicTrainModelLegacy.addParts(jsonObject, partsArray, "parts_head_1_tail_lights", ResourcePackCreatorProperties.RenderCondition.MOVING_BACKWARDS, "1", "%1");
            DynamicTrainModelLegacy.addParts(jsonObject, partsArray, "parts_head_2_headlights", ResourcePackCreatorProperties.RenderCondition.MOVING_BACKWARDS, "-1", "%1");
            DynamicTrainModelLegacy.addParts(jsonObject, partsArray, "parts_head_2_tail_lights", ResourcePackCreatorProperties.RenderCondition.MOVING_FORWARDS, "-1", "%1");
            DynamicTrainModelLegacy.addParts(jsonObject, partsArray, "parts_end_1", ResourcePackCreatorProperties.RenderCondition.ALL, "%1", "1");
            DynamicTrainModelLegacy.addParts(jsonObject, partsArray, "parts_end_2", ResourcePackCreatorProperties.RenderCondition.ALL, "%1", "-1");
            DynamicTrainModelLegacy.addParts(jsonObject, partsArray, "parts_door_opened", ResourcePackCreatorProperties.RenderCondition.DOORS_OPEN, "", "");
            DynamicTrainModelLegacy.addParts(jsonObject, partsArray, "parts_door_closed", ResourcePackCreatorProperties.RenderCondition.DOORS_CLOSED, "", "");
            jsonObject.add("parts", (JsonElement)partsArray);
            jsonObject.remove("parts_normal");
            jsonObject.remove("parts_head_1");
            jsonObject.remove("parts_head_2");
            jsonObject.remove("parts_head_1_headlights");
            jsonObject.remove("parts_head_1_tail_lights");
            jsonObject.remove("parts_head_2_headlights");
            jsonObject.remove("parts_head_2_tail_lights");
            jsonObject.remove("parts_end_1");
            jsonObject.remove("parts_end_2");
            jsonObject.remove("parts_door_opened");
            jsonObject.remove("parts_door_closed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addParts(JsonObject jsonObject, JsonArray partsArray, String key, ResourcePackCreatorProperties.RenderCondition renderCondition, String whitelistedCars, String blacklistedCars) {
        if (!jsonObject.has(key)) {
            return;
        }
        jsonObject.getAsJsonArray(key).forEach(partElement -> {
            JsonObject partObject = partElement.getAsJsonObject();
            for (int i = 0; i < 2; ++i) {
                String checkKey;
                JsonObject newPartObject = new JsonObject();
                String string = checkKey = i == 0 ? "positions" : "positions_flipped";
                if (!partObject.has("part_name") || !partObject.has(checkKey) || !partObject.get(checkKey).isJsonArray()) continue;
                newPartObject.addProperty("name", partObject.get("part_name").getAsString());
                newPartObject.add("positions", (JsonElement)partObject.getAsJsonArray(checkKey));
                newPartObject.addProperty("mirror", Boolean.valueOf(i == 1));
                newPartObject.addProperty("stage", DynamicTrainModelLegacy.getOrDefault(partObject, "stage", "", JsonElement::getAsString).toUpperCase(Locale.ENGLISH));
                newPartObject.addProperty("skip_rendering_if_too_far", DynamicTrainModelLegacy.getOrDefault(partObject, "skip_rendering_if_too_far", false, JsonElement::getAsBoolean));
                newPartObject.addProperty("door_offset", switch (DynamicTrainModelLegacy.getOrDefault(partObject, "door_offset_z", "", JsonElement::getAsString)) {
                    case "left" -> "LEFT_POSITIVE";
                    case "left_negative" -> "LEFT_NEGATIVE";
                    case "right" -> "RIGHT_POSITIVE";
                    case "right_negative" -> "RIGHT_NEGATIVE";
                    default -> "NONE";
                });
                newPartObject.addProperty("render_condition", renderCondition.toString());
                newPartObject.addProperty("whitelisted_cars", whitelistedCars);
                newPartObject.addProperty("blacklisted_cars", blacklistedCars);
                partsArray.add((JsonElement)newPartObject);
            }
        });
    }

    private static <T> T getOrDefault(JsonObject jsonObject, String key, T defaultValue, Function<JsonElement, T> function) {
        if (jsonObject.has(key)) {
            return function.apply(jsonObject.get(key));
        }
        return defaultValue;
    }
}

