/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.text2speech.Narrator;
import java.util.ArrayList;
import mtr.client.Config;
import mtr.data.IGui;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public interface IDrawing {
    public static void drawStringWithFont(PoseStack matrices, Font textRenderer, MultiBufferSource.BufferSource immediate, String text, float x, float y, int light) {
        IDrawing.drawStringWithFont(matrices, textRenderer, immediate, text, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, x, y, -1.0f, -1.0f, 1.0f, -1, true, light, null);
    }

    public static void drawStringWithFont(PoseStack matrices, Font textRenderer, MultiBufferSource.BufferSource immediate, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColor, boolean shadow, int light, DrawingCallback drawingCallback) {
        IDrawing.drawStringWithFont(matrices, textRenderer, immediate, text, horizontalAlignment, verticalAlignment, horizontalAlignment, x, y, maxWidth, maxHeight, scale, textColor, shadow, light, drawingCallback);
    }

    public static void drawStringWithFont(PoseStack matrices, Font textRenderer, MultiBufferSource.BufferSource immediate, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, IGui.HorizontalAlignment xAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColor, boolean shadow, int light, DrawingCallback drawingCallback) {
        IDrawing.drawStringWithFont(matrices, textRenderer, immediate, text, horizontalAlignment, verticalAlignment, xAlignment, x, y, maxWidth, maxHeight, scale, textColor, textColor, 2.0f, shadow, light, drawingCallback);
    }

    public static void drawStringWithFont(PoseStack matrices, Font textRenderer, MultiBufferSource.BufferSource immediate, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, IGui.HorizontalAlignment xAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColorCjk, int textColor, float fontSizeRatio, boolean shadow, int light, DrawingCallback drawingCallback) {
        float scaleX;
        float totalWidthScaled;
        boolean isCJK;
        Style style;
        Style style2 = style = Config.useMTRFont() ? Style.f_131099_.m_131150_(new ResourceLocation("mtr", "mtr")) : Style.f_131099_;
        while (text.contains("||")) {
            text = text.replace("||", "|");
        }
        String[] stringSplit = text.split("\\|");
        ArrayList<Boolean> isCJKList = new ArrayList<Boolean>();
        ArrayList<FormattedCharSequence> orderedTexts = new ArrayList<FormattedCharSequence>();
        int totalHeight = 0;
        int totalWidth = 0;
        for (String stringSplitPart : stringSplit) {
            isCJK = IGui.isCjk(stringSplitPart);
            isCJKList.add(isCJK);
            FormattedCharSequence orderedText = Text.literal(stringSplitPart).m_6270_(style).m_7532_();
            orderedTexts.add(orderedText);
            totalHeight = (int)((float)totalHeight + 10.0f * (isCJK ? fontSizeRatio : 1.0f));
            int width = (int)Math.ceil((float)textRenderer.m_92724_(orderedText) * (isCJK ? fontSizeRatio : 1.0f));
            if (width <= totalWidth) continue;
            totalWidth = width;
        }
        if (maxHeight >= 0.0f && (float)totalHeight / scale > maxHeight) {
            scale = (float)totalHeight / maxHeight;
        }
        matrices.m_85836_();
        if (maxWidth >= 0.0f && (float)totalWidth > maxWidth * scale) {
            totalWidthScaled = maxWidth * scale;
            scaleX = (float)totalWidth / maxWidth;
        } else {
            totalWidthScaled = totalWidth;
            scaleX = scale;
        }
        matrices.m_85841_(1.0f / scaleX, 1.0f / scale, 1.0f / scale);
        float offset = verticalAlignment.getOffset(y * scale, totalHeight);
        for (int i = 0; i < orderedTexts.size(); ++i) {
            float extraScale;
            isCJK = (Boolean)isCJKList.get(i);
            float f = extraScale = isCJK ? fontSizeRatio : 1.0f;
            if (isCJK) {
                matrices.m_85836_();
                matrices.m_85841_(extraScale, extraScale, 1.0f);
            }
            float xOffset = horizontalAlignment.getOffset(xAlignment.getOffset(x * scaleX, totalWidth), (float)textRenderer.m_92724_((FormattedCharSequence)orderedTexts.get(i)) * extraScale - (float)totalWidth);
            float shade = light == 0xF000F0 ? 1.0f : Math.min((float)LightTexture.m_109883_((int)light) / 16.0f * 0.1f + 0.7f, 1.0f);
            int a = (isCJK ? textColorCjk : textColor) >> 24 & 0xFF;
            int r = (int)((float)((isCJK ? textColorCjk : textColor) >> 16 & 0xFF) * shade);
            int g = (int)((float)((isCJK ? textColorCjk : textColor) >> 8 & 0xFF) * shade);
            int b = (int)((float)((isCJK ? textColorCjk : textColor) & 0xFF) * shade);
            if (immediate != null) {
                UtilitiesClient.drawInBatch(textRenderer, (FormattedCharSequence)orderedTexts.get(i), xOffset / extraScale, offset / extraScale, (a << 24) + (r << 16) + (g << 8) + b, shadow, matrices.m_85850_().m_252922_(), (MultiBufferSource)immediate, 0, light);
            }
            if (isCJK) {
                matrices.m_85849_();
            }
            offset += 10.0f * extraScale;
        }
        matrices.m_85849_();
        if (drawingCallback != null) {
            float x1 = xAlignment.getOffset(x, totalWidthScaled / scale);
            float y1 = verticalAlignment.getOffset(y, (float)totalHeight / scale);
            drawingCallback.drawingCallback(x1, y1, x1 + totalWidthScaled / scale, y1 + (float)totalHeight / scale);
        }
    }

    public static void drawLine(PoseStack matrices, MultiBufferSource vertexConsumers, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b) {
        VertexConsumer vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110504_());
        PoseStack.Pose pose = matrices.m_85850_();
        vertexConsumer.m_252986_(pose.m_252922_(), x1, y1, z1).m_6122_(r, g, b, 255).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(pose.m_252922_(), x2, y2, z2).m_6122_(r, g, b, 255).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void drawRectangle(VertexConsumer vertexConsumer, double x1, double y1, double x2, double y2, int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (a == 0) {
            return;
        }
        vertexConsumer.m_5483_(x1, y1, 0.0).m_6122_(r, g, b, a).m_5752_();
        vertexConsumer.m_5483_(x1, y2, 0.0).m_6122_(r, g, b, a).m_5752_();
        vertexConsumer.m_5483_(x2, y2, 0.0).m_6122_(r, g, b, a).m_5752_();
        vertexConsumer.m_5483_(x2, y1, 0.0).m_6122_(r, g, b, a).m_5752_();
    }

    public static void drawTexture(PoseStack matrices, VertexConsumer vertexConsumer, float x1, float y1, float z1, float x2, float y2, float z2, Direction facing, int color, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, x1, y1, z1, x2, y2, z2, 0.0f, 0.0f, 1.0f, 1.0f, facing, color, light);
    }

    public static void drawTexture(PoseStack matrices, VertexConsumer vertexConsumer, float x, float y, float width, float height, Direction facing, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, x, y, 0.0f, x + width, y + height, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, light);
    }

    public static void drawTexture(PoseStack matrices, VertexConsumer vertexConsumer, float x, float y, float width, float height, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, x, y, 0.0f, x + width, y + height, 0.0f, u1, v1, u2, v2, facing, color, light);
    }

    public static void drawTexture(PoseStack matrices, VertexConsumer vertexConsumer, float x1, float y1, float z1, float x2, float y2, float z2, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        IDrawing.drawTexture(matrices, vertexConsumer, x1, y2, z1, x2, y2, z2, x2, y1, z2, x1, y1, z1, u1, v1, u2, v2, facing, color, light);
    }

    public static void drawTexture(PoseStack matrices, VertexConsumer vertexConsumer, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        Vec3i vec3i = facing.m_122436_();
        PoseStack.Pose pose = matrices.m_85850_();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (a == 0) {
            return;
        }
        vertexConsumer.m_252986_(pose.m_252922_(), x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), (float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_()).m_5752_();
        vertexConsumer.m_252986_(pose.m_252922_(), x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), (float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_()).m_5752_();
        vertexConsumer.m_252986_(pose.m_252922_(), x3, y3, z3).m_6122_(r, g, b, a).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), (float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_()).m_5752_();
        vertexConsumer.m_252986_(pose.m_252922_(), x4, y4, z4).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), (float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_()).m_5752_();
    }

    public static void setPositionAndWidth(AbstractWidget widget, int x, int y, int widgetWidth) {
        UtilitiesClient.setWidgetX(widget, x);
        UtilitiesClient.setWidgetY(widget, y);
        widget.m_93674_(Mth.m_14045_((int)widgetWidth, (int)0, (int)(380 - (widget instanceof WidgetBetterTextField ? 4 : 0))));
    }

    public static void narrateOrAnnounce(String message) {
        String newMessage = IGui.formatStationName(message).replace("  ", " ");
        if (!newMessage.isEmpty()) {
            LocalPlayer player;
            if (Config.useTTSAnnouncements()) {
                Narrator.getNarrator().say(newMessage, true);
            }
            if (Config.showAnnouncementMessages() && (player = Minecraft.m_91087_().f_91074_) != null) {
                player.m_5661_((Component)Text.literal(newMessage), false);
            }
        }
    }

    @FunctionalInterface
    public static interface DrawingCallback {
        public void drawingCallback(float var1, float var2, float var3, float var4);
    }
}

